<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class ObjectDefinition extends \Google\Collection
{
  protected $collection_key = 'propertyDefinitions';
  public $name;
  protected $optionsType = ObjectOptions::class;
  protected $optionsDataType = '';
  protected $propertyDefinitionsType = PropertyDefinition::class;
  protected $propertyDefinitionsDataType = 'array';

  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param ObjectOptions
   */
  public function setOptions(ObjectOptions $options)
  {
    $this->options = $options;
  }
  /**
   * @return ObjectOptions
   */
  public function getOptions()
  {
    return $this->options;
  }
  /**
   * @param PropertyDefinition[]
   */
  public function setPropertyDefinitions($propertyDefinitions)
  {
    $this->propertyDefinitions = $propertyDefinitions;
  }
  /**
   * @return PropertyDefinition[]
   */
  public function getPropertyDefinitions()
  {
    return $this->propertyDefinitions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ObjectDefinition::class, 'Google_Service_CloudSearch_ObjectDefinition');
