<?php

/**
 * BaseProject
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                    $projectId                                   Type: integer(4), primary key
 * @property int                                    $customerId                                  Type: integer(4)
 * @property int                                    $is_deleted                                  Type: integer(1), default "0"
 * @property string                                 $name                                        Type: string(100)
 * @property string                                 $description                                 Type: string(256)
 * @property Customer                               $Customer                                    
 * @property Doctrine_Collection|ProjectActivity[]  $ProjectActivity                             
 * @property Doctrine_Collection|ProjectAdmin[]     $ProjectAdmin                                
 * @property Doctrine_Collection|TimesheetItem[]    $TimesheetItem                               
 *  
 * @method int                                      getProjectid()                               Type: integer(4), primary key
 * @method int                                      getCustomerid()                              Type: integer(4)
 * @method int                                      getIsDeleted()                               Type: integer(1), default "0"
 * @method string                                   getName()                                    Type: string(100)
 * @method string                                   getDescription()                             Type: string(256)
 * @method Customer                                 getCustomer()                                
 * @method Doctrine_Collection|ProjectActivity[]    getProjectActivity()                         
 * @method Doctrine_Collection|ProjectAdmin[]       getProjectAdmin()                            
 * @method Doctrine_Collection|TimesheetItem[]      getTimesheetItem()                           
 *  
 * @method Project                                  setProjectid(int $val)                       Type: integer(4), primary key
 * @method Project                                  setCustomerid(int $val)                      Type: integer(4)
 * @method Project                                  setIsDeleted(int $val)                       Type: integer(1), default "0"
 * @method Project                                  setName(string $val)                         Type: string(100)
 * @method Project                                  setDescription(string $val)                  Type: string(256)
 * @method Project                                  setCustomer(Customer $val)                   
 * @method Project                                  setProjectActivity(Doctrine_Collection $val) 
 * @method Project                                  setProjectAdmin(Doctrine_Collection $val)    
 * @method Project                                  setTimesheetItem(Doctrine_Collection $val)   
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseProject extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_project');
        $this->hasColumn('project_id as projectId', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('customer_id as customerId', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('is_deleted', 'integer', 1, array(
             'type' => 'integer',
             'default' => '0',
             'length' => 1,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('description', 'string', 256, array(
             'type' => 'string',
             'length' => 256,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Customer', array(
             'local' => 'customer_id',
             'foreign' => 'customer_id'));

        $this->hasMany('ProjectActivity', array(
             'local' => 'project_id',
             'foreign' => 'project_id'));

        $this->hasMany('ProjectAdmin', array(
             'local' => 'project_id',
             'foreign' => 'project_id'));

        $this->hasMany('TimesheetItem', array(
             'local' => 'project_id',
             'foreign' => 'projectId'));
    }
}