/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class TemporalAdjusters {
    private TemporalAdjusters() {
    }

    public static TemporalAdjuster ofDateAdjuster(UnaryOperator<LocalDate> unaryOperator) {
        Objects.requireNonNull(unaryOperator, "dateBasedAdjuster");
        return temporal -> {
            LocalDate localDate = LocalDate.from(temporal);
            LocalDate localDate2 = (LocalDate)unaryOperator.apply(localDate);
            return temporal.with(localDate2);
        };
    }

    public static TemporalAdjuster firstDayOfMonth() {
        return temporal -> temporal.with(ChronoField.DAY_OF_MONTH, 1L);
    }

    public static TemporalAdjuster lastDayOfMonth() {
        return temporal -> temporal.with(ChronoField.DAY_OF_MONTH, temporal.range(ChronoField.DAY_OF_MONTH).getMaximum());
    }

    public static TemporalAdjuster firstDayOfNextMonth() {
        return temporal -> temporal.with(ChronoField.DAY_OF_MONTH, 1L).plus(1L, ChronoUnit.MONTHS);
    }

    public static TemporalAdjuster firstDayOfYear() {
        return temporal -> temporal.with(ChronoField.DAY_OF_YEAR, 1L);
    }

    public static TemporalAdjuster lastDayOfYear() {
        return temporal -> temporal.with(ChronoField.DAY_OF_YEAR, temporal.range(ChronoField.DAY_OF_YEAR).getMaximum());
    }

    public static TemporalAdjuster firstDayOfNextYear() {
        return temporal -> temporal.with(ChronoField.DAY_OF_YEAR, 1L).plus(1L, ChronoUnit.YEARS);
    }

    public static TemporalAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters.dayOfWeekInMonth(1, dayOfWeek);
    }

    public static TemporalAdjuster lastInMonth(DayOfWeek dayOfWeek) {
        return TemporalAdjusters.dayOfWeekInMonth(-1, dayOfWeek);
    }

    public static TemporalAdjuster dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        Objects.requireNonNull(dayOfWeek, "dayOfWeek");
        int n2 = dayOfWeek.getValue();
        if (n >= 0) {
            return temporal -> {
                Temporal temporal2 = temporal.with(ChronoField.DAY_OF_MONTH, 1L);
                int n3 = temporal2.get(ChronoField.DAY_OF_WEEK);
                int n4 = (n2 - n3 + 7) % 7;
                n4 = (int)((long)n4 + ((long)n - 1L) * 7L);
                return temporal2.plus(n4, ChronoUnit.DAYS);
            };
        }
        return temporal -> {
            Temporal temporal2 = temporal.with(ChronoField.DAY_OF_MONTH, temporal.range(ChronoField.DAY_OF_MONTH).getMaximum());
            int n3 = temporal2.get(ChronoField.DAY_OF_WEEK);
            int n4 = n2 - n3;
            n4 = n4 == 0 ? 0 : (n4 > 0 ? n4 - 7 : n4);
            n4 = (int)((long)n4 - ((long)(-n) - 1L) * 7L);
            return temporal2.plus(n4, ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster next(DayOfWeek dayOfWeek) {
        int n = dayOfWeek.getValue();
        return temporal -> {
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            int n3 = n2 - n;
            return temporal.plus(n3 >= 0 ? (long)(7 - n3) : (long)(-n3), ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster nextOrSame(DayOfWeek dayOfWeek) {
        int n = dayOfWeek.getValue();
        return temporal -> {
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            if (n2 == n) {
                return temporal;
            }
            int n3 = n2 - n;
            return temporal.plus(n3 >= 0 ? (long)(7 - n3) : (long)(-n3), ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster previous(DayOfWeek dayOfWeek) {
        int n = dayOfWeek.getValue();
        return temporal -> {
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            int n3 = n - n2;
            return temporal.minus(n3 >= 0 ? (long)(7 - n3) : (long)(-n3), ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster previousOrSame(DayOfWeek dayOfWeek) {
        int n = dayOfWeek.getValue();
        return temporal -> {
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            if (n2 == n) {
                return temporal;
            }
            int n3 = n - n2;
            return temporal.minus(n3 >= 0 ? (long)(7 - n3) : (long)(-n3), ChronoUnit.DAYS);
        };
    }
}

