/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class DocumentDictionary
implements Dictionary {
    protected final IndexReader reader;
    protected final String payloadField;
    private final String field;
    private final String weightField;

    public DocumentDictionary(IndexReader reader, String field, String weightField) {
        this(reader, field, weightField, null);
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField) {
        this.reader = reader;
        this.field = field;
        this.weightField = weightField;
        this.payloadField = payloadField;
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new DocumentInputIterator(this.payloadField != null);
    }

    protected class DocumentInputIterator
    implements InputIterator {
        private final int docCount;
        private final Set<String> relevantFields;
        private final boolean hasPayloads;
        private final Bits liveDocs;
        private int currentDocId = -1;
        private long currentWeight;
        private BytesRef currentPayload;
        private final NumericDocValues weightValues;

        public DocumentInputIterator(boolean hasPayloads) throws IOException {
            this.hasPayloads = hasPayloads;
            this.docCount = DocumentDictionary.this.reader.maxDoc() - 1;
            this.weightValues = DocumentDictionary.this.weightField != null ? MultiDocValues.getNumericValues((IndexReader)DocumentDictionary.this.reader, (String)DocumentDictionary.this.weightField) : null;
            this.liveDocs = DocumentDictionary.this.reader.leaves().size() > 0 ? MultiFields.getLiveDocs((IndexReader)DocumentDictionary.this.reader) : null;
            this.relevantFields = this.getRelevantFields(DocumentDictionary.this.field, DocumentDictionary.this.weightField, DocumentDictionary.this.payloadField);
        }

        @Override
        public long weight() {
            return this.currentWeight;
        }

        public Comparator<BytesRef> getComparator() {
            return null;
        }

        public BytesRef next() throws IOException {
            while (this.currentDocId < this.docCount) {
                IndexableField fieldVal;
                ++this.currentDocId;
                if (this.liveDocs != null && !this.liveDocs.get(this.currentDocId)) continue;
                Document doc = DocumentDictionary.this.reader.document(this.currentDocId, this.relevantFields);
                BytesRef tempPayload = null;
                BytesRef tempTerm = null;
                if (this.hasPayloads) {
                    IndexableField payload = doc.getField(DocumentDictionary.this.payloadField);
                    if (payload == null || payload.binaryValue() == null && payload.stringValue() == null) continue;
                    BytesRef bytesRef = tempPayload = payload.binaryValue() != null ? payload.binaryValue() : new BytesRef((CharSequence)payload.stringValue());
                }
                if ((fieldVal = doc.getField(DocumentDictionary.this.field)) == null || fieldVal.binaryValue() == null && fieldVal.stringValue() == null) continue;
                tempTerm = fieldVal.stringValue() != null ? new BytesRef((CharSequence)fieldVal.stringValue()) : fieldVal.binaryValue();
                this.currentPayload = tempPayload;
                this.currentWeight = this.getWeight(doc, this.currentDocId);
                return tempTerm;
            }
            return null;
        }

        @Override
        public BytesRef payload() {
            return this.currentPayload;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        protected long getWeight(Document doc, int docId) {
            IndexableField weight = doc.getField(DocumentDictionary.this.weightField);
            if (weight != null) {
                return weight.numericValue() != null ? weight.numericValue().longValue() : 0L;
            }
            if (this.weightValues != null) {
                return this.weightValues.get(docId);
            }
            return 0L;
        }

        private Set<String> getRelevantFields(String ... fields) {
            HashSet<String> relevantFields = new HashSet<String>();
            for (String relevantField : fields) {
                if (relevantField == null) continue;
                relevantFields.add(relevantField);
            }
            return relevantFields;
        }
    }
}

