/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opensolaris.opengrok.jdbc.ConnectionResource;

public class ConnectionManager {
    private final String url;
    private final ConcurrentLinkedQueue<ConnectionResource> connections = new ConcurrentLinkedQueue();

    public ConnectionManager(String driverClass, String url) throws ClassNotFoundException {
        Class.forName(driverClass);
        this.url = url;
    }

    Connection openConnection() throws SQLException {
        return DriverManager.getConnection(this.url);
    }

    public synchronized ConnectionResource getConnectionResource() throws SQLException {
        ConnectionResource cr = this.connections.poll();
        if (cr == null || !cr.isValid()) {
            cr = new ConnectionResource(this);
        }
        return cr;
    }

    public void releaseConnection(ConnectionResource cr) throws SQLException {
        cr.rollback();
        this.connections.offer(cr);
    }
}

