/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryCache;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.jdbc.ConnectionManager;
import org.opensolaris.opengrok.jdbc.ConnectionResource;
import org.opensolaris.opengrok.jdbc.InsertQuery;
import org.opensolaris.opengrok.jdbc.PreparedQuery;

class JDBCHistoryCache
implements HistoryCache {
    private boolean historyIndexDone = false;
    private static final String SCHEMA = "OPENGROK";
    private static final String[] TABLES = new String[]{"REPOSITORIES", "FILES", "AUTHORS", "CHANGESETS", "FILECHANGES", "DIRECTORIES", "DIRCHANGES"};
    private static final Properties QUERIES = new Properties();
    private static final PreparedQuery GET_AUTHORS;
    private static final InsertQuery ADD_AUTHOR;
    private static final PreparedQuery GET_DIRS;
    private static final PreparedQuery GET_FILES;
    private static final InsertQuery INSERT_DIR;
    private static final InsertQuery INSERT_FILE;
    private static final PreparedQuery GET_LATEST_REVISION;
    private static final PreparedQuery GET_LAST_MODIFIED_TIMES;
    private static final PreparedQuery GET_FILEMOVES_COUNT;
    private static final int MAX_RETRIES = 2;
    private static final int MAX_MESSAGE_LENGTH = 32672;
    private ConnectionManager connectionManager;
    private final String jdbcDriverClass;
    private final String jdbcConnectionURL;
    private final AtomicInteger nextFileId = new AtomicInteger();
    private final AtomicInteger nextDirId = new AtomicInteger();
    private final AtomicInteger nextChangesetId = new AtomicInteger();
    private final AtomicInteger nextAuthorId = new AtomicInteger();
    private String info;
    private static final PreparedQuery IS_DIR_IN_CACHE;
    private static final PreparedQuery GET_FILE_HISTORY;
    private static final PreparedQuery GET_FILE_HISTORY_FOLDED;
    private static final PreparedQuery GET_DIR_HISTORY;
    private static final PreparedQuery GET_CS_FILES;
    private static final PreparedQuery GET_REV_ID;
    private static final PreparedQuery GET_REPOSITORY;
    private static final InsertQuery INSERT_REPOSITORY;
    private static final InsertQuery ADD_CHANGESET;
    private static final PreparedQuery ADD_DIRCHANGE;
    private static final PreparedQuery ADD_FILECHANGE;
    private static final PreparedQuery ADD_FILEMOVE;

    JDBCHistoryCache() {
        this(RuntimeEnvironment.getInstance().getDatabaseDriver(), RuntimeEnvironment.getInstance().getDatabaseUrl());
    }

    JDBCHistoryCache(String jdbcDriverClass, String url) {
        this.jdbcDriverClass = jdbcDriverClass;
        this.jdbcConnectionURL = url;
    }

    @Override
    public boolean supportsRepository(Repository repository) {
        return repository.hasHistoryForDirectories();
    }

    private static void handleSQLException(SQLException sqle, int attemptNo) throws SQLException {
        boolean isTransient = false;
        for (Throwable cause : sqle) {
            if (!(cause instanceof SQLTransientException)) continue;
            isTransient = true;
            break;
        }
        if (!isTransient || attemptNo >= 2) {
            throw sqle;
        }
        Logger logger = OpenGrokLogger.getLogger();
        logger.info("Transient database failure detected. Retrying.");
        logger.log(Level.FINE, "Transient database failure details:", sqle);
    }

    private static String getQuery(String key) {
        return QUERIES.getProperty(key);
    }

    private void initDB(Statement s) throws SQLException {
        DatabaseMetaData dmd = s.getConnection().getMetaData();
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "REPOSITORIES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableRepositories"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "DIRECTORIES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableDirectories"));
        }
        if (!JDBCHistoryCache.columnExists(dmd, SCHEMA, "DIRECTORIES", "PARENT")) {
            s.execute(JDBCHistoryCache.getQuery("alterTableDirectoriesParent"));
            s.execute(JDBCHistoryCache.getQuery("alterTableDirectoriesParentPathConstraint"));
            JDBCHistoryCache.fillDirectoriesParentColumn(s);
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "FILES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableFiles"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "AUTHORS")) {
            s.execute(JDBCHistoryCache.getQuery("createTableAuthors"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "CHANGESETS")) {
            s.execute(JDBCHistoryCache.getQuery("createTableChangesets"));
            s.execute(JDBCHistoryCache.getQuery("createIndexChangesetsRepoIdDesc"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "DIRCHANGES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableDirchanges"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "FILECHANGES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableFilechanges"));
        }
        if (!JDBCHistoryCache.tableExists(dmd, SCHEMA, "FILEMOVES")) {
            s.execute(JDBCHistoryCache.getQuery("createTableFilemoves"));
        }
        JDBCHistoryCache.initIdGenerator(s, "getMaxFileId", this.nextFileId);
        JDBCHistoryCache.initIdGenerator(s, "getMaxDirId", this.nextDirId);
        JDBCHistoryCache.initIdGenerator(s, "getMaxChangesetId", this.nextChangesetId);
        JDBCHistoryCache.initIdGenerator(s, "getMaxAuthorId", this.nextAuthorId);
        StringBuilder infoBuilder = new StringBuilder();
        infoBuilder.append(this.getClass().getSimpleName() + "\n");
        infoBuilder.append("Driver class: " + this.jdbcDriverClass + "\n");
        infoBuilder.append("URL: " + this.jdbcConnectionURL + "\n");
        infoBuilder.append("Database name: " + dmd.getDatabaseProductName() + "\n");
        infoBuilder.append("Database version: " + dmd.getDatabaseProductVersion() + "\n");
        this.info = infoBuilder.toString();
    }

    private static void fillDirectoriesParentColumn(Statement s) throws SQLException {
        try (PreparedStatement update = s.getConnection().prepareStatement(JDBCHistoryCache.getQuery("updateDirectoriesParent"));
             ResultSet rs = s.executeQuery(JDBCHistoryCache.getQuery("getAllDirectories"));){
            while (rs.next()) {
                update.setInt(1, rs.getInt("REPOSITORY"));
                update.setString(2, JDBCHistoryCache.getParentPath(rs.getString("PATH")));
                update.setInt(3, rs.getInt("ID"));
                update.executeUpdate();
            }
        }
    }

    private static boolean tableExists(DatabaseMetaData dmd, String schema, String table) throws SQLException {
        try (ResultSet rs = dmd.getTables(null, schema, table, new String[]{"TABLE"});){
            boolean bl = rs.next();
            return bl;
        }
    }

    private static boolean columnExists(DatabaseMetaData dmd, String schema, String table, String column) throws SQLException {
        try (ResultSet rs = dmd.getColumns(null, schema, table, column);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private static void initIdGenerator(Statement s, String stmtKey, AtomicInteger generator) throws SQLException {
        try (ResultSet rs = s.executeQuery(JDBCHistoryCache.getQuery(stmtKey));){
            if (rs.next()) {
                int val = rs.getInt(1);
                if (!rs.wasNull()) {
                    generator.set(val + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws HistoryException {
        try {
            this.connectionManager = new ConnectionManager(this.jdbcDriverClass, this.jdbcConnectionURL);
            int i = 0;
            while (true) {
                ConnectionResource conn = this.connectionManager.getConnectionResource();
                try {
                    try (Statement stmt = conn.createStatement();){
                        this.initDB(stmt);
                    }
                    conn.commit();
                    return;
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                }
                finally {
                    this.connectionManager.releaseConnection(conn);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean hasCacheForDirectory(File file, Repository repository) throws HistoryException {
        assert (file.isDirectory());
        int i = 0;
        while (true) {
            boolean bl;
            Throwable throwable;
            ResultSet rs;
            ConnectionResource conn;
            block21: {
                block22: {
                    conn = this.connectionManager.getConnectionResource();
                    PreparedStatement ps = conn.getStatement(IS_DIR_IN_CACHE);
                    ps.setString(1, JDBCHistoryCache.toUnixPath(repository.getDirectoryName()));
                    ps.setString(2, JDBCHistoryCache.getSourceRootRelativePath(file));
                    rs = ps.executeQuery();
                    throwable = null;
                    bl = rs.next();
                    if (rs == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                rs.close();
            }
            this.connectionManager.releaseConnection(conn);
            return bl;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (rs != null) {
                                        if (throwable != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            rs.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (SQLException sqle) {
                                JDBCHistoryCache.handleSQLException(sqle, i);
                                this.connectionManager.releaseConnection(conn);
                            }
                        }
                        catch (Throwable throwable6) {
                            this.connectionManager.releaseConnection(conn);
                            throw throwable6;
                        }
                        ++i;
                        continue;
                    }
                    catch (SQLException sqle) {
                        throw new HistoryException(sqle);
                    }
                }
            }
            break;
        }
    }

    private static String toUnixPath(String path) {
        return path.replace(File.separatorChar, '/');
    }

    private static String toUnixPath(File file) throws HistoryException {
        try {
            return JDBCHistoryCache.toUnixPath(file.getCanonicalPath());
        }
        catch (IOException ioe) {
            throw new HistoryException(ioe);
        }
    }

    private static String getSourceRootRelativePath(File file) throws HistoryException {
        String filePath = JDBCHistoryCache.toUnixPath(file);
        String rootPath = RuntimeEnvironment.getInstance().getSourceRootPath();
        return JDBCHistoryCache.getRelativePath(filePath, rootPath);
    }

    private static String getRelativePath(String filePath, String rootPath) {
        assert (filePath.startsWith(rootPath));
        return filePath.substring(rootPath.length());
    }

    private static String getBaseName(String fullPath) {
        int idx = fullPath.lastIndexOf(47);
        return idx >= 0 ? fullPath.substring(idx + 1) : fullPath;
    }

    private static String getParentPath(String fullPath) {
        int idx = fullPath.lastIndexOf(47);
        return idx >= 0 ? fullPath.substring(0, idx) : fullPath;
    }

    private static String[] splitPath(String fullPath) {
        if (fullPath.isEmpty() || fullPath.charAt(0) != '/') {
            throw new IllegalArgumentException("Not a full path: " + fullPath);
        }
        return fullPath.substring(1).split("/");
    }

    private static String unsplitPath(String[] pathElts, int num) {
        StringBuilder out = new StringBuilder("");
        for (int i = 0; i < num; ++i) {
            out.append("/").append(pathElts[i]);
        }
        return out.toString();
    }

    private static String truncate(String str, int length) {
        if (str.length() < length) {
            throw new IllegalArgumentException();
        }
        String suffix = " (...)";
        return length < suffix.length() ? str.substring(0, length) : str.substring(0, length - suffix.length()) + suffix;
    }

    @Override
    public History get(File file, Repository repository, boolean withFiles) throws HistoryException {
        try {
            int i = 0;
            while (true) {
                try {
                    return this.getHistory(file, repository, withFiles);
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFilemovesCount() throws SQLException {
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        try {
            PreparedStatement cntPS = conn.getStatement(GET_FILEMOVES_COUNT);
            try (ResultSet rs = cntPS.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private History getHistory(File file, Repository repository, boolean withFiles) throws HistoryException, SQLException {
        String filePath = JDBCHistoryCache.getSourceRootRelativePath(file);
        String reposPath = JDBCHistoryCache.toUnixPath(repository.getDirectoryName());
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        try {
            PreparedStatement ps;
            if (file.isDirectory()) {
                ps = conn.getStatement(GET_DIR_HISTORY);
                ps.setString(2, filePath);
            } else {
                ps = conn.getStatement(RuntimeEnvironment.isRenamedFilesEnabled() && this.getFilemovesCount() > 0 ? GET_FILE_HISTORY : GET_FILE_HISTORY_FOLDED);
                ps.setString(2, JDBCHistoryCache.getParentPath(filePath));
                ps.setString(3, JDBCHistoryCache.getBaseName(filePath));
            }
            ps.setString(1, reposPath);
            PreparedStatement filePS = withFiles ? conn.getStatement(GET_CS_FILES) : null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ResultSet fileRS;
                    block28: {
                        String revision = rs.getString(1);
                        String author = rs.getString(2);
                        Timestamp time = rs.getTimestamp(3);
                        String message = rs.getString(4);
                        HistoryEntry entry = new HistoryEntry(revision, time, author, null, message, true);
                        entries.add(entry);
                        if (!withFiles) continue;
                        int changeset = rs.getInt(5);
                        filePS.setInt(1, changeset);
                        fileRS = filePS.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (fileRS.next()) {
                                entry.addFile(fileRS.getString(1));
                            }
                            if (fileRS == null) continue;
                            if (throwable == null) break block28;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (fileRS == null) throw throwable3;
                                if (throwable == null) {
                                    fileRS.close();
                                    throw throwable3;
                                }
                                try {
                                    fileRS.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            fileRS.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    fileRS.close();
                }
            }
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
        History history = new History();
        history.setHistoryEntries(entries);
        if (!env.isTagsEnabled()) return history;
        if (!repository.hasFileBasedTags()) return history;
        repository.assignTagsInHistory(history);
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(History history, Repository repository) throws HistoryException {
        try {
            ConnectionResource conn = this.connectionManager.getConnectionResource();
            try {
                this.storeHistory(conn, history, repository);
            }
            finally {
                this.connectionManager.releaseConnection(conn);
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdForRevision(String revision, int repoId) throws SQLException {
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        try {
            PreparedStatement ps = conn.getStatement(GET_REV_ID);
            ps.setString(1, revision);
            ps.setInt(2, repoId);
            ResultSet rs = ps.executeQuery();
            int n = rs.next() ? Integer.valueOf(rs.getString(1)) : -1;
            return n;
        }
        catch (SQLException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "getIdForRevision exception" + e);
            int n = -1;
            return n;
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
    }

    private void storeHistory(ConnectionResource conn, History history, final Repository repository) throws SQLException {
        Integer reposId = null;
        Map<String, Integer> authors = null;
        HashMap<String, Integer> filesNf = null;
        HashMap<String, Integer> directories = null;
        PreparedStatement addChangeset = null;
        PreparedStatement addDirchange = null;
        PreparedStatement addFilechange = null;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        List<HistoryEntry> entries = history.getHistoryEntries();
        if (entries.isEmpty()) {
            return;
        }
        OpenGrokLogger.getLogger().log(Level.FINE, "Storing history for repo {0}", new Object[]{repository.getDirectoryName()});
        int i = 0;
        while (true) {
            try {
                if (reposId == null) {
                    reposId = this.getRepositoryId(conn, repository);
                    conn.commit();
                }
                if (authors == null) {
                    authors = this.getAuthors(conn, history, reposId);
                    conn.commit();
                }
                if (directories == null || filesNf == null) {
                    HashMap<String, Integer> dirs = new HashMap<String, Integer>();
                    HashMap<String, Integer> fls = new HashMap<String, Integer>();
                    this.getFilesAndDirectories(conn, history, reposId, dirs, fls);
                    conn.commit();
                    directories = dirs;
                    filesNf = fls;
                }
                if (addChangeset == null) {
                    addChangeset = conn.getStatement(ADD_CHANGESET);
                }
                if (addDirchange == null) {
                    addDirchange = conn.getStatement(ADD_DIRCHANGE);
                }
                if (addFilechange != null) break;
                addFilechange = conn.getStatement(ADD_FILECHANGE);
            }
            catch (SQLException sqle) {
                JDBCHistoryCache.handleSQLException(sqle, i);
                conn.rollback();
                ++i;
                continue;
            }
            break;
        }
        final HashMap<String, Integer> files = filesNf;
        addChangeset.setInt(1, reposId);
        ListIterator<HistoryEntry> it = entries.listIterator(entries.size());
        block9: while (it.hasPrevious()) {
            HistoryEntry entry = it.previous();
            int i2 = 0;
            while (true) {
                try {
                    addChangeset.setString(2, entry.getRevision());
                    addChangeset.setInt(3, authors.get(entry.getAuthor()));
                    addChangeset.setTimestamp(4, new Timestamp(entry.getDate().getTime()));
                    String msg = entry.getMessage();
                    if (msg.length() > 32672) {
                        msg = JDBCHistoryCache.truncate(msg, 32672);
                    }
                    addChangeset.setString(5, msg);
                    int changesetId = this.nextChangesetId.getAndIncrement();
                    addChangeset.setInt(6, changesetId);
                    addChangeset.executeUpdate();
                    HashSet<String> addedDirs = new HashSet<String>();
                    addDirchange.setInt(1, changesetId);
                    addFilechange.setInt(1, changesetId);
                    for (String file : entry.getFiles()) {
                        String repodir = "";
                        try {
                            repodir = env.getPathRelativeToSourceRoot(new File(repository.getDirectoryName()), 0);
                        }
                        catch (IOException ex) {
                            OpenGrokLogger.getLogger().log(Level.WARNING, "File exception" + ex);
                            continue;
                        }
                        String fullPath = JDBCHistoryCache.toUnixPath(file);
                        if (!history.isRenamed(file.substring(repodir.length() + 1)) || !RuntimeEnvironment.isRenamedFilesEnabled()) {
                            int fileId = (Integer)files.get(fullPath);
                            addFilechange.setInt(2, fileId);
                            addFilechange.executeUpdate();
                        }
                        String[] pathElts = JDBCHistoryCache.splitPath(fullPath);
                        for (int j = 0; j < pathElts.length; ++j) {
                            String dir = JDBCHistoryCache.unsplitPath(pathElts, j);
                            if (addedDirs.contains(dir)) continue;
                            addDirchange.setInt(2, (Integer)directories.get(dir));
                            addDirchange.executeUpdate();
                            addedDirs.add(dir);
                        }
                    }
                    conn.commit();
                    continue block9;
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i2);
                    conn.rollback();
                    ++i2;
                    continue;
                }
                break;
            }
        }
        if (!RuntimeEnvironment.isRenamedFilesEnabled()) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(history.getRenamedFiles().size());
        for (String filename : history.getRenamedFiles()) {
            String file_path = repository.getDirectoryName() + File.separatorChar + filename;
            final File file = new File(file_path);
            final String repo_path = file_path.substring(env.getSourceRootPath().length());
            RuntimeEnvironment.getHistoryRenamedExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        JDBCHistoryCache.this.doRenamedHistory(repository, file, files, repo_path);
                    }
                    catch (Exception ex) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "doRenamedHistory exception" + ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "latch exception" + ex);
        }
        OpenGrokLogger.getLogger().log(Level.FINE, "Done storing history for repo {0}", new Object[]{repository.getDirectoryName()});
    }

    @Override
    public void optimize() throws HistoryException {
        try {
            ConnectionResource conn = this.connectionManager.getConnectionResource();
            try {
                this.updateIndexCardinalityStatistics(conn);
                this.checkpointDatabase(conn);
            }
            finally {
                this.connectionManager.releaseConnection(conn);
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    private void updateIndexCardinalityStatistics(ConnectionResource conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        if (this.procedureExists(dmd, "SYSCS_UTIL", "SYSCS_UPDATE_STATISTICS")) {
            try (PreparedStatement ps = conn.prepareStatement("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS(?, ?, NULL)");){
                ps.setString(1, SCHEMA);
                for (String table : TABLES) {
                    ps.setString(2, table);
                    int i = 0;
                    while (true) {
                        try {
                            ps.execute();
                        }
                        catch (SQLException sqle) {
                            JDBCHistoryCache.handleSQLException(sqle, i);
                            conn.rollback();
                            ++i;
                            continue;
                        }
                        break;
                    }
                    conn.commit();
                }
            }
        }
    }

    private void checkpointDatabase(ConnectionResource conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        if (this.procedureExists(dmd, "SYSCS_UTIL", "SYSCS_CHECKPOINT_DATABASE")) {
            try (Statement s = conn.createStatement();){
                s.execute("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            }
            conn.commit();
        }
    }

    private boolean procedureExists(DatabaseMetaData dmd, String schema, String proc) throws SQLException {
        try (ResultSet rs = dmd.getProcedures(null, schema, proc);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private int getRepositoryId(ConnectionResource conn, Repository repository) throws SQLException {
        String reposPath = JDBCHistoryCache.toUnixPath(repository.getDirectoryName());
        PreparedStatement reposIdPS = conn.getStatement(GET_REPOSITORY);
        reposIdPS.setString(1, reposPath);
        try (ResultSet reposIdRS = reposIdPS.executeQuery();){
            if (reposIdRS.next()) {
                int n = reposIdRS.getInt(1);
                return n;
            }
        }
        PreparedStatement insert = conn.getStatement(INSERT_REPOSITORY);
        insert.setString(1, reposPath);
        insert.executeUpdate();
        return this.getGeneratedIntKey(insert);
    }

    private Map<String, Integer> getAuthors(ConnectionResource conn, History history, int reposId) throws SQLException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PreparedStatement ps = conn.getStatement(GET_AUTHORS);
        ps.setInt(1, reposId);
        ResultSet rs = ps.executeQuery();
        Object object = null;
        try {
            while (rs.next()) {
                map.put(rs.getString(1), rs.getInt(2));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        PreparedStatement insert = conn.getStatement(ADD_AUTHOR);
        insert.setInt(1, reposId);
        for (HistoryEntry entry : history.getHistoryEntries()) {
            String author = entry.getAuthor();
            if (map.containsKey(author)) continue;
            int id = this.nextAuthorId.getAndIncrement();
            insert.setString(2, author);
            insert.setInt(3, id);
            insert.executeUpdate();
            map.put(author, id);
            conn.commit();
        }
        return map;
    }

    private void getFilesAndDirectories(ConnectionResource conn, History history, int reposId, Map<String, Integer> dirMap, Map<String, Integer> fileMap) throws SQLException {
        this.populateFileOrDirMap(conn.getStatement(GET_DIRS), reposId, dirMap);
        this.populateFileOrDirMap(conn.getStatement(GET_FILES), reposId, fileMap);
        int insertCount = 0;
        PreparedStatement insDir = conn.getStatement(INSERT_DIR);
        PreparedStatement insFile = conn.getStatement(INSERT_FILE);
        for (HistoryEntry entry : history.getHistoryEntries()) {
            for (String file : entry.getFiles()) {
                String fullPath = JDBCHistoryCache.toUnixPath(file);
                if (fileMap.containsKey(fullPath)) continue;
                int dir = this.addAllDirs(insDir, reposId, fullPath, dirMap);
                int fileId = this.nextFileId.getAndIncrement();
                insFile.setInt(1, dir);
                insFile.setString(2, JDBCHistoryCache.getBaseName(fullPath));
                insFile.setInt(3, fileId);
                insFile.executeUpdate();
                fileMap.put(fullPath, fileId);
                if (++insertCount % 30 != 0) continue;
                conn.commit();
            }
        }
    }

    private void populateFileOrDirMap(PreparedStatement ps, int reposId, Map<String, Integer> map) throws SQLException {
        ps.setInt(1, reposId);
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                map.put(rs.getString(1), rs.getInt(2));
            }
        }
    }

    private int addAllDirs(PreparedStatement ps, int reposId, String fullPath, Map<String, Integer> map) throws SQLException {
        String[] pathElts = JDBCHistoryCache.splitPath(fullPath);
        String parent = JDBCHistoryCache.unsplitPath(pathElts, pathElts.length - 1);
        Integer dir = map.get(parent);
        if (dir == null) {
            for (int i = 0; i < pathElts.length; ++i) {
                Integer prevDirId = dir;
                String path = JDBCHistoryCache.unsplitPath(pathElts, i);
                dir = map.get(path);
                if (dir != null) continue;
                dir = this.nextDirId.getAndIncrement();
                ps.setInt(1, reposId);
                ps.setString(2, path);
                ps.setInt(3, dir);
                ps.setObject(4, (Object)prevDirId, 4);
                ps.executeUpdate();
                map.put(path, dir);
            }
        }
        return dir;
    }

    private Integer getGeneratedIntKey(Statement stmt) throws SQLException {
        try (ResultSet keys = stmt.getGeneratedKeys();){
            Integer n = keys.next() ? Integer.valueOf(keys.getInt(1)) : null;
            return n;
        }
    }

    @Override
    public String getLatestCachedRevision(Repository repository) throws HistoryException {
        try {
            int i = 0;
            while (true) {
                try {
                    return this.getLatestRevisionForRepository(repository);
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    /*
     * Loose catch block
     */
    private String getLatestRevisionForRepository(Repository repository) throws SQLException {
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        try {
            PreparedStatement ps = conn.getStatement(GET_LATEST_REVISION);
            ps.setString(1, JDBCHistoryCache.toUnixPath(repository.getDirectoryName()));
            try (ResultSet rs = ps.executeQuery();){
                String string = rs.next() ? rs.getString(1) : null;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
    }

    @Override
    public Map<String, Date> getLastModifiedTimes(File directory, Repository repository) throws HistoryException {
        try {
            int i = 0;
            while (true) {
                try {
                    return this.getLastModifiedTimesForAllFiles(directory, repository);
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Date> getLastModifiedTimesForAllFiles(File directory, Repository repository) throws HistoryException, SQLException {
        HashMap<String, Date> map = new HashMap<String, Date>();
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        try {
            PreparedStatement ps = conn.getStatement(GET_LAST_MODIFIED_TIMES);
            ps.setString(1, JDBCHistoryCache.toUnixPath(repository.getDirectoryName()));
            ps.setString(2, JDBCHistoryCache.getSourceRootRelativePath(directory));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getTimestamp(2));
                }
            }
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
        return map;
    }

    @Override
    public void clear(Repository repository) throws HistoryException {
        try {
            int i = 0;
            while (true) {
                try {
                    this.clearHistoryForRepository(repository);
                    return;
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqle) {
            throw new HistoryException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistoryForRepository(Repository repository) throws SQLException {
        ConnectionResource conn = this.connectionManager.getConnectionResource();
        try (PreparedStatement ps = conn.prepareStatement(JDBCHistoryCache.getQuery("clearRepository"));){
            ps.setInt(1, this.getRepositoryId(conn, repository));
            ps.execute();
            conn.commit();
        }
        finally {
            this.connectionManager.releaseConnection(conn);
        }
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRenamedHistory(Repository repository, File file, Map<String, Integer> files, String repo_path) throws SQLException {
        History hist;
        PreparedStatement addFilemove = null;
        PreparedStatement addFilechange = null;
        try {
            hist = repository.getHistory(file);
        }
        catch (HistoryException ex) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "cannot get history for " + file + " because of exception " + ex);
            return;
        }
        int fileId = files.get(repo_path);
        block7: for (HistoryEntry entry : hist.getHistoryEntries()) {
            int i = 0;
            while (true) {
                ConnectionResource conn = this.connectionManager.getConnectionResource();
                addFilemove = conn.getStatement(ADD_FILEMOVE);
                addFilechange = conn.getStatement(ADD_FILECHANGE);
                try {
                    int changesetId = this.getIdForRevision(entry.getRevision(), this.getRepositoryId(conn, repository));
                    if (entry.getFiles().contains(repo_path)) {
                        addFilechange.setInt(1, changesetId);
                        addFilechange.setInt(2, fileId);
                        addFilechange.executeUpdate();
                    } else {
                        addFilemove.setInt(1, changesetId);
                        addFilemove.setInt(2, fileId);
                        addFilemove.executeUpdate();
                    }
                    conn.commit();
                    continue block7;
                }
                catch (SQLException sqle) {
                    JDBCHistoryCache.handleSQLException(sqle, i);
                    conn.rollback();
                }
                finally {
                    this.connectionManager.releaseConnection(conn);
                    continue block7;
                }
                ++i;
            }
        }
    }

    @Override
    public void setHistoryIndexDone() {
        this.historyIndexDone = true;
    }

    @Override
    public boolean isHistoryIndexDone() {
        return this.historyIndexDone;
    }

    static {
        Class<JDBCHistoryCache> klazz = JDBCHistoryCache.class;
        try (InputStream in = klazz.getResourceAsStream(klazz.getSimpleName() + "_queries.properties");){
            if (in != null) {
                QUERIES.load(in);
            }
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
        GET_AUTHORS = new PreparedQuery(JDBCHistoryCache.getQuery("getAuthors"));
        ADD_AUTHOR = new InsertQuery(JDBCHistoryCache.getQuery("addAuthor"));
        GET_DIRS = new PreparedQuery(JDBCHistoryCache.getQuery("getDirectories"));
        GET_FILES = new PreparedQuery(JDBCHistoryCache.getQuery("getFiles"));
        INSERT_DIR = new InsertQuery(JDBCHistoryCache.getQuery("addDirectory"));
        INSERT_FILE = new InsertQuery(JDBCHistoryCache.getQuery("addFile"));
        GET_LATEST_REVISION = new PreparedQuery(JDBCHistoryCache.getQuery("getLatestCachedRevision"));
        GET_LAST_MODIFIED_TIMES = new PreparedQuery(JDBCHistoryCache.getQuery("getLastModifiedTimes"));
        GET_FILEMOVES_COUNT = new PreparedQuery(JDBCHistoryCache.getQuery("getFilemovesCount"));
        IS_DIR_IN_CACHE = new PreparedQuery(JDBCHistoryCache.getQuery("hasCacheForDirectory"));
        GET_FILE_HISTORY = new PreparedQuery(JDBCHistoryCache.getQuery("getFileHistory"));
        GET_FILE_HISTORY_FOLDED = new PreparedQuery(JDBCHistoryCache.getQuery("getFileHistoryFolded"));
        GET_DIR_HISTORY = new PreparedQuery(JDBCHistoryCache.getQuery("getDirHistory"));
        GET_CS_FILES = new PreparedQuery(JDBCHistoryCache.getQuery("getFilesInChangeset"));
        GET_REV_ID = new PreparedQuery(JDBCHistoryCache.getQuery("getChangesetIdForRevision"));
        GET_REPOSITORY = new PreparedQuery(JDBCHistoryCache.getQuery("getRepository"));
        INSERT_REPOSITORY = new InsertQuery(JDBCHistoryCache.getQuery("addRepository"));
        ADD_CHANGESET = new InsertQuery(JDBCHistoryCache.getQuery("addChangeset"));
        ADD_DIRCHANGE = new PreparedQuery(JDBCHistoryCache.getQuery("addDirchange"));
        ADD_FILECHANGE = new PreparedQuery(JDBCHistoryCache.getQuery("addFilechange"));
        ADD_FILEMOVE = new PreparedQuery(JDBCHistoryCache.getQuery("addFilemove"));
    }
}

