/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CudaArch;
import org.clang.basic.CudaVersion;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.directory_iterator;
import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.DriverGlobals;
import org.clang.driver.Multilib;
import org.clang.driver.MultilibSet;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.DetectedMultilibs;
import org.clang.driver.impl.ToolChainsStatics;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$;
import org.clang.driver.tools.impl.GccStatics;
import org.clang.driver.tools.impl.GnutoolsStatics;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.CollectionUtils;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.convert_iterator;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallSet;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class Generic_GCC
extends ToolChain
implements Destructors.ClassWithDestructor {
    protected GCCInstallationDetector GCCInstallation;
    protected CudaInstallationDetector CudaInstallation;
    private std_ptr.unique_ptr<GccStatics.Preprocessor> Preprocess;
    private std_ptr.unique_ptr<GccStatics.Compiler> Compile;

    public Generic_GCC(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        this.GCCInstallation = new GCCInstallationDetector(D);
        this.CudaInstallation = new CudaInstallationDetector(D);
        this.Preprocess = new std_ptr.unique_ptr();
        this.Compile = new std_ptr.unique_ptr();
        this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
        if (std.$noteq_T_string$C((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
            this.getProgramPaths().push_back((Object)this.getDriver().Dir);
        }
    }

    @Override
    public void $destroy() {
        this.Compile.$destroy();
        this.Preprocess.$destroy();
        this.CudaInstallation.$destroy();
        this.GCCInstallation.$destroy();
        super.$destroy();
    }

    @Override
    public void printVerboseInfo(raw_ostream OS) {
        this.GCCInstallation.print(OS);
        this.CudaInstallation.print(OS);
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPICDefault() {
        return this.getArch() == Triple.ArchType.x86_64 && this.getTriple().isOSWindows();
    }

    @Override
    public boolean isPIEDefault() {
        return false;
    }

    @Override
    public boolean isPICDefaultForced() {
        return this.getArch() == Triple.ArchType.x86_64 && this.getTriple().isOSWindows();
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        switch (this.getTriple().getArch()) {
            case aarch64: 
            case aarch64_be: 
            case arm: 
            case thumb: 
            case armeb: 
            case thumbeb: 
            case x86_64: 
            case x86: 
            case mips: 
            case mipsel: 
            case ppc: 
            case ppc64: 
            case ppc64le: 
            case systemz: 
            case bpfel: 
            case bpfeb: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Tool getTool(Action.ActionClass AC) {
        switch (AC) {
            case PreprocessJobClass: {
                if (!this.Preprocess.$bool()) {
                    this.Preprocess.reset((Object)new GccStatics.Preprocessor(this));
                }
                return (Tool)this.Preprocess.get();
            }
            case CompileJobClass: {
                if (!this.Compile.$bool()) {
                    this.Compile.reset((Object)new GccStatics.Compiler(this));
                }
                return (Tool)this.Compile.get();
            }
        }
        return super.getTool(AC);
    }

    @Override
    protected Tool buildAssembler() {
        return new GnutoolsStatics.Assembler(this);
    }

    @Override
    protected Tool buildLinker() {
        return new GccStatics.Linker(this);
    }

    protected boolean isTarget64Bit() {
        return this.getTriple().isArch64Bit();
    }

    protected boolean isTarget32Bit() {
        return this.getTriple().isArch32Bit();
    }

    protected boolean addLibStdCXXIncludePaths(Twine Base, Twine Suffix, StringRef GCCTriple, StringRef GCCMultiarchTriple, StringRef TargetMultiarchTriple, Twine IncludeSuffix, ArgList DriverArgs, ArgStringList CC1Args) {
        if (!this.getVFS().exists(llvm.$add_Twine((Twine)Base, (Twine)Suffix))) {
            return false;
        }
        Generic_GCC.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)Base, (Twine)Suffix));
        if (GCCMultiarchTriple.empty() && TargetMultiarchTriple.empty() || this.getVFS().exists(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine(NativePointer.$SLASH)), (Twine)new Twine(GCCTriple)), (Twine)IncludeSuffix))) {
            Generic_GCC.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine(NativePointer.$SLASH)), (Twine)new Twine(GCCTriple)), (Twine)IncludeSuffix));
        } else {
            Generic_GCC.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Base, (Twine)new Twine(NativePointer.$SLASH)), (Twine)new Twine(GCCMultiarchTriple)), (Twine)Suffix), (Twine)IncludeSuffix));
            Generic_GCC.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Base, (Twine)new Twine(NativePointer.$SLASH)), (Twine)new Twine(TargetMultiarchTriple)), (Twine)Suffix));
        }
        Generic_GCC.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine("/backward")));
        return true;
    }

    @Override
    public String toString() {
        return "GCCInstallation=" + this.GCCInstallation + ", CudaInstallation=" + this.CudaInstallation + ", Preprocess=" + this.Preprocess + ", Compile=" + this.Compile + super.toString();
    }

    public static class CudaInstallationDetector
    implements Destructors.ClassWithDestructor {
        private Driver D;
        private boolean IsValid;
        private CudaVersion Version;
        private std.string InstallPath;
        private std.string BinPath;
        private std.string LibPath;
        private std.string LibDevicePath;
        private std.string IncludePath;
        private StringMap<std.string> LibDeviceMap;
        private SmallSet<CudaArch> ArchsWithVersionTooLowErrors;

        public CudaInstallationDetector(Driver D) {
            this.D = D;
            this.IsValid = false;
            this.Version = CudaVersion.UNKNOWN;
            this.InstallPath = new std.string();
            this.BinPath = new std.string();
            this.LibPath = new std.string();
            this.LibDevicePath = new std.string();
            this.IncludePath = new std.string();
            this.LibDeviceMap = new StringMap((Object)std.string.EMPTY);
            this.ArchsWithVersionTooLowErrors = new SmallSet(4, BasicClangGlobals.CUDA_ARCH_COMPARATOR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(Triple TargetTriple, ArgList Args) {
            SmallVector CudaPathCandidates = new SmallVector(4, (Object)new std.string());
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_cuda_path_EQ.getValue()))) {
                CudaPathCandidates.push_back((Object)Args.getLastArgValue(new OptSpecifier(options.ID.OPT_cuda_path_EQ.getValue())).$basic_string());
            } else {
                CudaPathCandidates.push_back((Object)std.$add_string$C_T((std.string)this.D.SysRoot, (String)"/usr/local/cuda"));
                CudaPathCandidates.push_back((Object)std.$add_string$C_T((std.string)this.D.SysRoot, (String)"/usr/local/cuda-7.5"));
                CudaPathCandidates.push_back((Object)std.$add_string$C_T((std.string)this.D.SysRoot, (String)"/usr/local/cuda-7.0"));
            }
            for (std.string CudaPath : CudaPathCandidates) {
                ErrorOr VersionFile = null;
                try {
                    if (CudaPath.empty() || !this.D.getVFS().exists(new Twine(CudaPath))) continue;
                    this.InstallPath.$assign(CudaPath);
                    this.BinPath.$assignMove(std.$add_string$C_T((std.string)CudaPath, (String)"/bin"));
                    this.IncludePath.$assignMove(std.$add_string$C_T((std.string)this.InstallPath, (String)"/include"));
                    this.LibDevicePath.$assignMove(std.$add_string$C_T((std.string)this.InstallPath, (String)"/nvvm/libdevice"));
                    this.LibPath.$assignMove(std.$add_string$C_T((std.string)this.InstallPath, (char.ptr)(TargetTriple.isArch64Bit() ? NativePointer.$((String)"/lib64") : NativePointer.$((String)"/lib"))));
                    FileSystem FS = this.D.getVFS();
                    if (!FS.exists(new Twine(this.IncludePath)) || !FS.exists(new Twine(this.BinPath)) || !FS.exists(new Twine(this.LibPath)) || !FS.exists(new Twine(this.LibDevicePath))) continue;
                    std_errors.error_code EC = new std_errors.error_code();
                    fs.directory_iterator LI = null;
                    fs.directory_iterator LE = null;
                    try {
                        LI = new fs.directory_iterator(new Twine(this.LibDevicePath), EC);
                        LE = new fs.directory_iterator();
                        while (!EC.$bool() && LI.$noteq(LE)) {
                            StringRef LibDeviceName;
                            StringRef FilePath = new StringRef(LI.$arrow().path());
                            StringRef FileName = path.filename((StringRef)FilePath);
                            if (FileName.startswith(LibDeviceName = new StringRef("libdevice.")) && FileName.endswith(".bc")) {
                                StringRef GpuArch = FileName.slice(LibDeviceName.size(), FileName.find((byte)46, LibDeviceName.size()));
                                ((std.string)this.LibDeviceMap.$at(GpuArch)).$assignMove(FilePath.str());
                                if (llvm.$eq_StringRef((StringRef)GpuArch, (String)"compute_20")) {
                                    ((std.string)this.LibDeviceMap.$at("sm_20")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_21")).$assignMove(FilePath.$basic_string());
                                } else if (llvm.$eq_StringRef((StringRef)GpuArch, (String)"compute_30")) {
                                    ((std.string)this.LibDeviceMap.$at("sm_30")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_32")).$assignMove(FilePath.$basic_string());
                                } else if (llvm.$eq_StringRef((StringRef)GpuArch, (String)"compute_35")) {
                                    ((std.string)this.LibDeviceMap.$at("sm_35")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_37")).$assignMove(FilePath.$basic_string());
                                } else if (llvm.$eq_StringRef((StringRef)GpuArch, (String)"compute_50")) {
                                    ((std.string)this.LibDeviceMap.$at("sm_50")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_52")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_53")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_60")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_61")).$assignMove(FilePath.$basic_string());
                                    ((std.string)this.LibDeviceMap.$at("sm_62")).$assignMove(FilePath.$basic_string());
                                }
                            }
                            LI.$assign(LI.increment(EC));
                        }
                    }
                    finally {
                        if (LE != null) {
                            LE.$destroy();
                        }
                        if (LI != null) {
                            LI.$destroy();
                        }
                    }
                    VersionFile = FS.getBufferForFile(new Twine(std.$add_string$C_T((std.string)this.InstallPath, (String)"/version.txt")));
                    this.Version = !VersionFile.$bool() ? CudaVersion.CUDA_70 : ToolChainsStatics.ParseCudaVersionFile(((MemoryBuffer)((std_ptr.unique_ptr)VersionFile.$star()).$arrow()).getBuffer());
                    this.IsValid = true;
                    break;
                }
                finally {
                    if (VersionFile == null) continue;
                    VersionFile.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void CheckCudaVersionSupportsArch(CudaArch Arch) {
            if (Arch == CudaArch.UNKNOWN || this.Version == CudaVersion.UNKNOWN || Unsigned.$greater_uint((int)this.ArchsWithVersionTooLowErrors.count((Object)Arch), (int)0)) {
                return;
            }
            CudaVersion RequiredVersion = BasicClangGlobals.MinVersionForCudaArch((CudaArch)Arch);
            if (this.Version.$less((Object)RequiredVersion)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    this.ArchsWithVersionTooLowErrors.insert((Object)Arch);
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.D.Diag(317))), (StringRef)new StringRef(this.InstallPath)), (char.ptr)BasicClangGlobals.CudaArchToString((CudaArch)Arch)), (char.ptr)BasicClangGlobals.CudaVersionToString((CudaVersion)this.Version)), (char.ptr)BasicClangGlobals.CudaVersionToString((CudaVersion)RequiredVersion)));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }

        public boolean isValid() {
            return this.IsValid;
        }

        public void print(raw_ostream OS) {
            if (this.isValid()) {
                OS.$out("Found CUDA installation: ").$out(this.InstallPath).$out(", version ").$out(BasicClangGlobals.CudaVersionToString((CudaVersion)this.Version)).$out(NativePointer.$LF);
            }
        }

        public CudaVersion version() {
            return this.Version;
        }

        public StringRef getInstallPath() {
            return new StringRef(this.InstallPath);
        }

        public StringRef getBinPath() {
            return new StringRef(this.BinPath);
        }

        public StringRef getIncludePath() {
            return new StringRef(this.IncludePath);
        }

        public StringRef getLibPath() {
            return new StringRef(this.LibPath);
        }

        public StringRef getLibDevicePath() {
            return new StringRef(this.LibDevicePath);
        }

        public std.string getLibDeviceFile(StringRef Gpu) {
            return (std.string)this.LibDeviceMap.lookup(new StringRef(Gpu));
        }

        public void $destroy() {
            this.ArchsWithVersionTooLowErrors.$destroy();
            this.LibDeviceMap.$destroy();
            this.IncludePath.$destroy();
            this.LibDevicePath.$destroy();
            this.LibPath.$destroy();
            this.BinPath.$destroy();
            this.InstallPath.$destroy();
        }

        public String toString() {
            return "D=" + this.D + ", IsValid=" + this.IsValid + ", Version=" + this.Version + ", InstallPath=" + this.InstallPath + ", BinPath=" + this.BinPath + ", LibPath=" + this.LibPath + ", LibDevicePath=" + this.LibDevicePath + ", IncludePath=" + this.IncludePath + ", LibDeviceMap=" + this.LibDeviceMap + ", ArchsWithVersionTooLowErrors=" + this.ArchsWithVersionTooLowErrors;
        }
    }

    public static class GCCInstallationDetector
    implements Destructors.ClassWithDestructor {
        private boolean IsValid = false;
        private Triple GCCTriple = new Triple();
        private Driver D;
        private std.string GCCInstallPath;
        private std.string GCCParentLibPath;
        private Multilib SelectedMultilib;
        private Optional<Multilib> BiarchSibling;
        private GCCVersion Version;
        private std.set<std.string> CandidateGCCInstallPaths;
        private MultilibSet Multilibs;

        public GCCInstallationDetector(Driver D) {
            this.D = D;
            this.GCCInstallPath = new std.string();
            this.GCCParentLibPath = new std.string();
            this.SelectedMultilib = new Multilib();
            this.BiarchSibling = new Optional();
            this.Version = new GCCVersion();
            this.CandidateGCCInstallPaths = new std.set();
            this.Multilibs = new MultilibSet();
        }

        public void init(Triple TargetTriple, ArgList Args) {
            this.init(TargetTriple, Args, (ArrayRef<std.string>)ArrayRef.None());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(Triple TargetTriple, ArgList Args, ArrayRef<std.string> ExtraTripleAliases) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Triple BiarchVariantTriple = TargetTriple.isArch32Bit() ? TargetTriple.get64BitArchVariant() : TargetTriple.get32BitArchVariant();
                SmallVector CandidateLibDirs = new SmallVector(4, (Object)new StringRef());
                SmallVector CandidateBiarchLibDirs = new SmallVector(4, (Object)new StringRef());
                SmallVector CandidateTripleAliases = new SmallVector(16, (Object)new StringRef());
                SmallVector CandidateBiarchTripleAliases = new SmallVector(16, (Object)new StringRef());
                GCCInstallationDetector.CollectLibDirsAndTriples(TargetTriple, BiarchVariantTriple, (SmallVectorImpl<StringRef>)CandidateLibDirs, (SmallVectorImpl<StringRef>)CandidateTripleAliases, (SmallVectorImpl<StringRef>)CandidateBiarchLibDirs, (SmallVectorImpl<StringRef>)CandidateBiarchTripleAliases);
                SmallVector Prefixes = new SmallVector(8, (type.iterator)this.D.PrefixDirs.begin(), (type.iterator)this.D.PrefixDirs.end(), (Object)new std.string());
                StringRef GCCToolchainDir = ToolChainsStatics.getGCCToolchainDir(Args);
                if (llvm.$noteq_StringRef((StringRef)GCCToolchainDir, (String)"")) {
                    if (GCCToolchainDir.back() == 47) {
                        GCCToolchainDir.$assignMove(GCCToolchainDir.drop_back());
                    }
                    Prefixes.push_back((Object)GCCToolchainDir.$basic_string());
                } else {
                    if (!this.D.SysRoot.empty()) {
                        Prefixes.push_back((Object)this.D.SysRoot);
                        Prefixes.push_back((Object)std.$add_string$C_T((std.string)this.D.SysRoot, (String)"/usr"));
                    }
                    Prefixes.push_back((Object)std.$add_string$C_T((std.string)this.D.InstalledDir, (String)"/.."));
                    if (this.D.SysRoot.empty()) {
                        Prefixes.push_back((Object)new std.string((CharSequence)"/opt/rh/devtoolset-4/root/usr"));
                        Prefixes.push_back((Object)new std.string((CharSequence)"/opt/rh/devtoolset-3/root/usr"));
                        Prefixes.push_back((Object)new std.string((CharSequence)"/opt/rh/devtoolset-2/root/usr"));
                        Prefixes.push_back((Object)new std.string((CharSequence)"/opt/rh/devtoolset-1.1/root/usr"));
                        Prefixes.push_back((Object)new std.string((CharSequence)"/opt/rh/devtoolset-1.0/root/usr"));
                        Prefixes.push_back((Object)new std.string((CharSequence)"/usr"));
                    }
                }
                $c$.clean((Object)this.Version.$assignMove((GCCVersion)$c$.track((Object)GCCVersion.Parse(new StringRef("0.0.0")))));
                for (std.string Prefix : Prefixes) {
                    std.string LibDir;
                    if (!this.D.getVFS().exists(new Twine(Prefix))) continue;
                    for (StringRef Suffix : CandidateLibDirs) {
                        LibDir = std.$add_string$C_string((std.string)Prefix, (std.string)Suffix.str());
                        if (!this.D.getVFS().exists(new Twine(LibDir))) continue;
                        for (std.string Candidate : ExtraTripleAliases) {
                            this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, new StringRef(Candidate));
                        }
                        for (std.string Candidate : CandidateTripleAliases) {
                            this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, new StringRef((StringRef)Candidate));
                        }
                    }
                    for (StringRef Suffix : CandidateBiarchLibDirs) {
                        LibDir = std.$add_string$C_string((std.string)Prefix, (std.string)Suffix.str());
                        if (!this.D.getVFS().exists(new Twine(LibDir))) continue;
                        for (std.string Candidate : CandidateBiarchTripleAliases) {
                            this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, new StringRef((StringRef)Candidate), true);
                        }
                    }
                }
            }
            finally {
                $c$.$destroy();
            }
        }

        public boolean isValid() {
            return this.IsValid;
        }

        public Triple getTriple() {
            return this.GCCTriple;
        }

        public StringRef getInstallPath() {
            return new StringRef(this.GCCInstallPath);
        }

        public StringRef getParentLibPath() {
            return new StringRef(this.GCCParentLibPath);
        }

        public Multilib getMultilib() {
            return this.SelectedMultilib;
        }

        public MultilibSet getMultilibs() {
            return this.Multilibs;
        }

        public boolean getBiarchSibling(Multilib M) {
            if (this.BiarchSibling.hasValue()) {
                M.$assign((Multilib)this.BiarchSibling.getValue());
                return true;
            }
            return false;
        }

        public GCCVersion getVersion() {
            return this.Version;
        }

        public void print(raw_ostream OS) {
            for (std.string InstallPath : this.CandidateGCCInstallPaths) {
                OS.$out("Found candidate GCC installation: ").$out(InstallPath).$out(NativePointer.$LF);
            }
            if (!this.GCCInstallPath.empty()) {
                OS.$out("Selected GCC installation: ").$out(this.GCCInstallPath).$out(NativePointer.$LF);
            }
            for (Multilib Multilib2 : this.Multilibs) {
                DriverGlobals.$out_raw_ostream_Multilib(OS.$out("Candidate multilib: "), Multilib2).$out(NativePointer.$LF);
            }
            if (this.Multilibs.size() != 0 || !this.SelectedMultilib.isDefault()) {
                DriverGlobals.$out_raw_ostream_Multilib(OS.$out("Selected multilib: "), this.SelectedMultilib).$out(NativePointer.$LF);
            }
        }

        private static type.iterator<?, StringRef> begin(char.ptr[] strings) {
            return new convert_iterator((type.iterator)NativePointer.create_type$ptr((Object[])strings), (CollectionUtils.Converter)CharPtrToStringRefConverter.INSTANCE);
        }

        private static type.iterator<?, StringRef> end(char.ptr[] strings) {
            return new convert_iterator((type.iterator)NativePointer.create_type$ptr((Object[])strings, (int)strings.length), (CollectionUtils.Converter)CharPtrToStringRefConverter.INSTANCE);
        }

        private static void CollectLibDirsAndTriples(Triple TargetTriple, Triple BiarchTriple, SmallVectorImpl<StringRef> LibDirs, SmallVectorImpl<StringRef> TripleAliases, SmallVectorImpl<StringRef> BiarchLibDirs, SmallVectorImpl<StringRef> BiarchTripleAliases) {
            char.ptr[] AArch64LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.AArch64LibDirs;
            char.ptr[] AArch64Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.AArch64Triples;
            char.ptr[] AArch64beLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.AArch64beLibDirs;
            char.ptr[] AArch64beTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.AArch64beTriples;
            char.ptr[] ARMLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMLibDirs;
            char.ptr[] ARMTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMTriples;
            char.ptr[] ARMHFTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMHFTriples;
            char.ptr[] ARMebLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMebLibDirs;
            char.ptr[] ARMebTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMebTriples;
            char.ptr[] ARMebHFTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.ARMebHFTriples;
            char.ptr[] X86_64LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.X86_64LibDirs;
            char.ptr[] X86_64Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.X86_64Triples;
            char.ptr[] X32LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.X32LibDirs;
            char.ptr[] X86LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.X86LibDirs;
            char.ptr[] X86Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.X86Triples;
            char.ptr[] MIPSLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPSLibDirs;
            char.ptr[] MIPSTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPSTriples;
            char.ptr[] MIPSELLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPSELLibDirs;
            char.ptr[] MIPSELTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPSELTriples;
            char.ptr[] MIPS64LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPS64LibDirs;
            char.ptr[] MIPS64Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPS64Triples;
            char.ptr[] MIPS64ELLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPS64ELLibDirs;
            char.ptr[] MIPS64ELTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.MIPS64ELTriples;
            char.ptr[] PPCLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPCLibDirs;
            char.ptr[] PPCTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPCTriples;
            char.ptr[] PPC64LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPC64LibDirs;
            char.ptr[] PPC64Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPC64Triples;
            char.ptr[] PPC64LELibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPC64LELibDirs;
            char.ptr[] PPC64LETriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.PPC64LETriples;
            char.ptr[] SPARCv8LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SPARCv8LibDirs;
            char.ptr[] SPARCv8Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SPARCv8Triples;
            char.ptr[] SPARCv9LibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SPARCv9LibDirs;
            char.ptr[] SPARCv9Triples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SPARCv9Triples;
            char.ptr[] SystemZLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SystemZLibDirs;
            char.ptr[] SystemZTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SystemZTriples;
            char.ptr[] SolarisSPARCLibDirs = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SolarisSPARCLibDirs;
            char.ptr[] SolarisSPARCTriples = Generic_GCC$GCCInstallationDetector$CollectLibDirsAndTriples$$.SolarisSPARCTriples;
            if (TargetTriple.getOS() == Triple.OSType.Solaris) {
                LibDirs.append(GCCInstallationDetector.begin(SolarisSPARCLibDirs), GCCInstallationDetector.end(SolarisSPARCLibDirs));
                TripleAliases.append(GCCInstallationDetector.begin(SolarisSPARCTriples), GCCInstallationDetector.end(SolarisSPARCTriples));
                return;
            }
            switch (TargetTriple.getArch()) {
                case aarch64: {
                    LibDirs.append(GCCInstallationDetector.begin(AArch64LibDirs), GCCInstallationDetector.end(AArch64LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(AArch64Triples), GCCInstallationDetector.end(AArch64Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(AArch64LibDirs), GCCInstallationDetector.end(AArch64LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(AArch64Triples), GCCInstallationDetector.end(AArch64Triples));
                    break;
                }
                case aarch64_be: {
                    LibDirs.append(GCCInstallationDetector.begin(AArch64beLibDirs), GCCInstallationDetector.end(AArch64beLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(AArch64beTriples), GCCInstallationDetector.end(AArch64beTriples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(AArch64beLibDirs), GCCInstallationDetector.end(AArch64beLibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(AArch64beTriples), GCCInstallationDetector.end(AArch64beTriples));
                    break;
                }
                case arm: 
                case thumb: {
                    LibDirs.append(GCCInstallationDetector.begin(ARMLibDirs), GCCInstallationDetector.end(ARMLibDirs));
                    if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                        TripleAliases.append(GCCInstallationDetector.begin(ARMHFTriples), GCCInstallationDetector.end(ARMHFTriples));
                        break;
                    }
                    TripleAliases.append(GCCInstallationDetector.begin(ARMTriples), GCCInstallationDetector.end(ARMTriples));
                    break;
                }
                case armeb: 
                case thumbeb: {
                    LibDirs.append(GCCInstallationDetector.begin(ARMebLibDirs), GCCInstallationDetector.end(ARMebLibDirs));
                    if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                        TripleAliases.append(GCCInstallationDetector.begin(ARMebHFTriples), GCCInstallationDetector.end(ARMebHFTriples));
                        break;
                    }
                    TripleAliases.append(GCCInstallationDetector.begin(ARMebTriples), GCCInstallationDetector.end(ARMebTriples));
                    break;
                }
                case x86_64: {
                    LibDirs.append(GCCInstallationDetector.begin(X86_64LibDirs), GCCInstallationDetector.end(X86_64LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                    if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                        BiarchLibDirs.append(GCCInstallationDetector.begin(X32LibDirs), GCCInstallationDetector.end(X32LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                        break;
                    }
                    BiarchLibDirs.append(GCCInstallationDetector.begin(X86LibDirs), GCCInstallationDetector.end(X86LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(X86Triples), GCCInstallationDetector.end(X86Triples));
                    break;
                }
                case x86: {
                    LibDirs.append(GCCInstallationDetector.begin(X86LibDirs), GCCInstallationDetector.end(X86LibDirs));
                    if (TargetTriple.isOSIAMCU()) break;
                    TripleAliases.append(GCCInstallationDetector.begin(X86Triples), GCCInstallationDetector.end(X86Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(X86_64LibDirs), GCCInstallationDetector.end(X86_64LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                    break;
                }
                case mips: {
                    LibDirs.append(GCCInstallationDetector.begin(MIPSLibDirs), GCCInstallationDetector.end(MIPSLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(MIPS64LibDirs), GCCInstallationDetector.end(MIPS64LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPS64Triples), GCCInstallationDetector.end(MIPS64Triples));
                    break;
                }
                case mipsel: {
                    LibDirs.append(GCCInstallationDetector.begin(MIPSELLibDirs), GCCInstallationDetector.end(MIPSELLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(MIPSELTriples), GCCInstallationDetector.end(MIPSELTriples));
                    TripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(MIPS64ELLibDirs), GCCInstallationDetector.end(MIPS64ELLibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPS64ELTriples), GCCInstallationDetector.end(MIPS64ELTriples));
                    break;
                }
                case mips64: {
                    LibDirs.append(GCCInstallationDetector.begin(MIPS64LibDirs), GCCInstallationDetector.end(MIPS64LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(MIPS64Triples), GCCInstallationDetector.end(MIPS64Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(MIPSLibDirs), GCCInstallationDetector.end(MIPSLibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                    break;
                }
                case mips64el: {
                    LibDirs.append(GCCInstallationDetector.begin(MIPS64ELLibDirs), GCCInstallationDetector.end(MIPS64ELLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(MIPS64ELTriples), GCCInstallationDetector.end(MIPS64ELTriples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(MIPSELLibDirs), GCCInstallationDetector.end(MIPSELLibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSELTriples), GCCInstallationDetector.end(MIPSELTriples));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                    break;
                }
                case ppc: {
                    LibDirs.append(GCCInstallationDetector.begin(PPCLibDirs), GCCInstallationDetector.end(PPCLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(PPCTriples), GCCInstallationDetector.end(PPCTriples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(PPC64LibDirs), GCCInstallationDetector.end(PPC64LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(PPC64Triples), GCCInstallationDetector.end(PPC64Triples));
                    break;
                }
                case ppc64: {
                    LibDirs.append(GCCInstallationDetector.begin(PPC64LibDirs), GCCInstallationDetector.end(PPC64LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(PPC64Triples), GCCInstallationDetector.end(PPC64Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(PPCLibDirs), GCCInstallationDetector.end(PPCLibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(PPCTriples), GCCInstallationDetector.end(PPCTriples));
                    break;
                }
                case ppc64le: {
                    LibDirs.append(GCCInstallationDetector.begin(PPC64LELibDirs), GCCInstallationDetector.end(PPC64LELibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(PPC64LETriples), GCCInstallationDetector.end(PPC64LETriples));
                    break;
                }
                case sparc: 
                case sparcel: {
                    LibDirs.append(GCCInstallationDetector.begin(SPARCv8LibDirs), GCCInstallationDetector.end(SPARCv8LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(SPARCv8Triples), GCCInstallationDetector.end(SPARCv8Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(SPARCv9LibDirs), GCCInstallationDetector.end(SPARCv9LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(SPARCv9Triples), GCCInstallationDetector.end(SPARCv9Triples));
                    break;
                }
                case sparcv9: {
                    LibDirs.append(GCCInstallationDetector.begin(SPARCv9LibDirs), GCCInstallationDetector.end(SPARCv9LibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(SPARCv9Triples), GCCInstallationDetector.end(SPARCv9Triples));
                    BiarchLibDirs.append(GCCInstallationDetector.begin(SPARCv8LibDirs), GCCInstallationDetector.end(SPARCv8LibDirs));
                    BiarchTripleAliases.append(GCCInstallationDetector.begin(SPARCv8Triples), GCCInstallationDetector.end(SPARCv8Triples));
                    break;
                }
                case systemz: {
                    LibDirs.append(GCCInstallationDetector.begin(SystemZLibDirs), GCCInstallationDetector.end(SystemZLibDirs));
                    TripleAliases.append(GCCInstallationDetector.begin(SystemZTriples), GCCInstallationDetector.end(SystemZTriples));
                    break;
                }
            }
            TripleAliases.push_back((Object)new StringRef(TargetTriple.str()));
            if (std.$noteq_string$C((std.string)TargetTriple.str(), (std.string)BiarchTriple.str())) {
                BiarchTripleAliases.push_back((Object)new StringRef(BiarchTriple.str()));
            }
        }

        private void ScanLibDirForGCCTriple(Triple TargetTriple, ArgList Args, std.string LibDir, StringRef CandidateTriple) {
            this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, CandidateTriple, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ScanLibDirForGCCTriple(Triple TargetTriple, ArgList Args, std.string LibDir, StringRef CandidateTriple, boolean NeedsBiarchSuffix) {
            Triple.ArchType TargetArch = TargetTriple.getArch();
            std.string[][] LibAndInstallSuffixes = new std.string[][]{{std.$add_T_string((String)"/gcc/", (std.string)CandidateTriple.str()), new std.string((CharSequence)"/../../..")}, {std.$add_T_string((String)"/gcc-cross/", (std.string)CandidateTriple.str()), new std.string((CharSequence)"/../../..")}, {std.$add_string((std.string)std.$add_string_T((std.string)std.$add_T_string((String)"/", (std.string)CandidateTriple.str()), (String)"/gcc/"), (std.string)CandidateTriple.str()), new std.string((CharSequence)"/../../../..")}, {std.$add_T_string((String)"/", (std.string)CandidateTriple.str()), new std.string((CharSequence)"/../..")}, {std.$add_T_string((String)"/i386-linux-gnu/gcc/", (std.string)CandidateTriple.str()), new std.string((CharSequence)"/../../../..")}};
            if (TargetTriple.getOS() == Triple.OSType.Solaris) {
                this.scanLibDirForGCCTripleSolaris(TargetTriple, Args, LibDir, new StringRef(CandidateTriple), NeedsBiarchSuffix);
                return;
            }
            int NumLibSuffixes = llvm.array_lengthof((Object[])LibAndInstallSuffixes) - (TargetArch != Triple.ArchType.x86 ? 1 : 0);
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)NumLibSuffixes)) {
                StringRef LibSuffix = new StringRef(LibAndInstallSuffixes[i][0]);
                std_errors.error_code EC = new std_errors.error_code();
                directory_iterator LI = this.D.getVFS().dir_begin(llvm.$add_Twine((Twine)new Twine(LibDir), (Twine)new Twine(LibSuffix)), EC);
                directory_iterator LE = new directory_iterator();
                while (!EC.$bool() && LI.$noteq(LE)) {
                    block16: {
                        GCCVersion CandidateVersion = null;
                        DetectedMultilibs Detected = null;
                        try {
                            StringRef VersionText = path.filename((StringRef)LI.$arrow().getName());
                            CandidateVersion = GCCVersion.Parse(new StringRef(VersionText));
                            if (CandidateVersion.Major != -1 && !this.CandidateGCCInstallPaths.insert((Object)LI.$arrow().getName().$basic_string()).second || CandidateVersion.isOlderThan(4, 1, 1) || CandidateVersion.$lesseq(this.Version)) break block16;
                            Detected = new DetectedMultilibs();
                            if (ToolChainsStatics.isArmOrThumbArch(TargetArch) && TargetTriple.isAndroid()) {
                                ToolChainsStatics.findAndroidArmMultilibs(this.D, TargetTriple, LI.$arrow().getName(), Args, Detected);
                            } else if (ToolChainsStatics.isMipsArch(TargetArch) ? !ToolChainsStatics.findMIPSMultilibs(this.D, TargetTriple, LI.$arrow().getName(), Args, Detected) : !ToolChainsStatics.findBiarchMultilibs(this.D, TargetTriple, LI.$arrow().getName(), Args, NeedsBiarchSuffix, Detected)) break block16;
                            this.Multilibs.$assign(Detected.Multilibs);
                            this.SelectedMultilib.$assign(Detected.SelectedMultilib);
                            this.BiarchSibling.$assign(Detected.BiarchSibling);
                            this.Version.$assign(CandidateVersion);
                            this.GCCTriple.setTriple(new Twine(CandidateTriple));
                            this.GCCInstallPath.$assignMove(std.$add_string((std.string)std.$add_string_T((std.string)std.$add_string$C((std.string)LibDir, (std.string)LibAndInstallSuffixes[i][0]), (String)"/"), (std.string)VersionText.str()));
                            this.GCCParentLibPath.$assignMove(std.$add_string$C((std.string)this.GCCInstallPath, (std.string)LibAndInstallSuffixes[i][1]));
                            this.IsValid = true;
                        }
                        finally {
                            if (Detected != null) {
                                Detected.$destroy();
                            }
                            if (CandidateVersion != null) {
                                CandidateVersion.$destroy();
                            }
                        }
                    }
                    LI.$assign(LI.increment(EC));
                }
                ++i;
            }
        }

        private void scanLibDirForGCCTripleSolaris(Triple TargetArch, ArgList Args, std.string LibDir, StringRef CandidateTriple) {
            this.scanLibDirForGCCTripleSolaris(TargetArch, Args, LibDir, CandidateTriple, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanLibDirForGCCTripleSolaris(Triple TargetArch, ArgList Args, std.string LibDir, StringRef CandidateTriple, boolean NeedsBiarchSuffix) {
            std_errors.error_code EC = new std_errors.error_code();
            directory_iterator LI = this.D.getVFS().dir_begin(new Twine(LibDir), EC);
            directory_iterator LE = new directory_iterator();
            while (!EC.$bool() && LI.$noteq(LE)) {
                block15: {
                    GCCVersion CandidateVersion = null;
                    try {
                        StringRef VersionText = path.filename((StringRef)LI.$arrow().getName());
                        CandidateVersion = GCCVersion.Parse(new StringRef(VersionText));
                        if (CandidateVersion.Major != -1 && !this.CandidateGCCInstallPaths.insert((Object)LI.$arrow().getName().$basic_string()).second || CandidateVersion.isOlderThan(4, 1, 1) || CandidateVersion.$lesseq(this.Version)) break block15;
                        this.GCCInstallPath.$assignMove(std.$add_string((std.string)std.$add_string_T((std.string)std.$add_string((std.string)std.$add_string$C_T((std.string)LibDir, (String)"/"), (std.string)VersionText.str()), (String)"/lib/gcc/"), (std.string)CandidateTriple.str()));
                        if (!this.D.getVFS().exists(new Twine(this.GCCInstallPath))) break block15;
                        std_errors.error_code EEC = new std_errors.error_code();
                        directory_iterator LLI = this.D.getVFS().dir_begin(new Twine(this.GCCInstallPath), EEC);
                        directory_iterator LLE = new directory_iterator();
                        while (!EEC.$bool() && LLI.$noteq(LLE)) {
                            GCCVersion CandidateSubVersion = null;
                            try {
                                StringRef SubVersionText = path.filename((StringRef)LLI.$arrow().getName());
                                CandidateSubVersion = GCCVersion.Parse(new StringRef(SubVersionText));
                                if (CandidateSubVersion.$greater(this.Version)) {
                                    this.Version.$assign(CandidateSubVersion);
                                }
                            }
                            finally {
                                if (CandidateSubVersion != null) {
                                    CandidateSubVersion.$destroy();
                                }
                            }
                            LLI.$assign(LLI.increment(EEC));
                        }
                        this.GCCTriple.setTriple(new Twine(CandidateTriple));
                        this.GCCInstallPath.$addassign(std.$add_T_string$C((String)"/", (std.string)this.Version.Text));
                        this.GCCParentLibPath.$assignMove(std.$add_string$C_T((std.string)this.GCCInstallPath, (String)"/../../../../"));
                        this.IsValid = true;
                    }
                    finally {
                        if (CandidateVersion != null) {
                            CandidateVersion.$destroy();
                        }
                    }
                }
                LI.$assign(LI.increment(EC));
            }
        }

        public void $destroy() {
            this.Multilibs.$destroy();
            this.CandidateGCCInstallPaths.$destroy();
            this.Version.$destroy();
            this.BiarchSibling.$destroy();
            this.SelectedMultilib.$destroy();
            this.GCCParentLibPath.$destroy();
            this.GCCInstallPath.$destroy();
            this.GCCTriple.$destroy();
        }

        public String toString() {
            return "IsValid=" + this.IsValid + ", GCCTriple=" + this.GCCTriple + ", D=" + this.D + ", GCCInstallPath=" + this.GCCInstallPath + ", GCCParentLibPath=" + this.GCCParentLibPath + ", SelectedMultilib=" + this.SelectedMultilib + ", BiarchSibling=" + this.BiarchSibling + ", Version=" + this.Version + ", CandidateGCCInstallPaths=" + this.CandidateGCCInstallPaths + ", Multilibs=" + this.Multilibs;
        }

        private static final class CharPtrToStringRefConverter
        implements CollectionUtils.Converter<char.ptr, StringRef> {
            static final CharPtrToStringRefConverter INSTANCE = new CharPtrToStringRefConverter();

            private CharPtrToStringRefConverter() {
            }

            public Class<StringRef> getToClass() {
                return StringRef.class;
            }

            public StringRef convert(char.ptr from) {
                return new StringRef(from);
            }
        }
    }

    public static class GCCVersion
    implements Destructors.ClassWithDestructor {
        public std.string Text;
        public int Major;
        public int Minor;
        public int Patch;
        public final int.ref MajorRef = new int.ref(this){
            final /* synthetic */ GCCVersion this$0;
            {
                this.this$0 = this$0;
            }

            public int $deref() {
                return this.this$0.Major;
            }

            public int $set(int value) {
                this.this$0.Major = value;
                return this.this$0.Major;
            }
        };
        public final int.ref MinorRef = new int.ref(this){
            final /* synthetic */ GCCVersion this$0;
            {
                this.this$0 = this$0;
            }

            public int $deref() {
                return this.this$0.Minor;
            }

            public int $set(int value) {
                this.this$0.Minor = value;
                return this.this$0.Minor;
            }
        };
        public final int.ref PatchRef = new int.ref(this){
            final /* synthetic */ GCCVersion this$0;
            {
                this.this$0 = this$0;
            }

            public int $deref() {
                return this.this$0.Patch;
            }

            public int $set(int value) {
                this.this$0.Patch = value;
                return this.this$0.Patch;
            }
        };
        public std.string MajorStr;
        public std.string MinorStr;
        public std.string PatchSuffix;

        public GCCVersion(std.string Text, int Major, int Minor, int Patch, String MajorStr, String MinorStr, String PatchSuffix) {
            this.Text = Text;
            this.Major = Major;
            this.Minor = Minor;
            this.Patch = Patch;
            this.MajorStr = new std.string((CharSequence)MajorStr);
            this.MinorStr = new std.string((CharSequence)MinorStr);
            this.PatchSuffix = new std.string((CharSequence)PatchSuffix);
        }

        public GCCVersion(std.string Text, int Major, int Minor, int Patch, char.ptr MajorStr, char.ptr MinorStr, char.ptr PatchSuffix) {
            this.Text = Text;
            this.Major = Major;
            this.Minor = Minor;
            this.Patch = Patch;
            this.MajorStr = new std.string(MajorStr);
            this.MinorStr = new std.string(MinorStr);
            this.PatchSuffix = new std.string(PatchSuffix);
        }

        public static GCCVersion Parse(StringRef VersionText) {
            int EndNumber;
            GCCVersion BadVersion = new GCCVersion(VersionText.str(), -1, -1, -1, NativePointer.$EMPTY, NativePointer.$EMPTY, NativePointer.$EMPTY);
            std_pair.pair First = VersionText.split((byte)46);
            std_pair.pair Second = ((StringRef)First.second).split((byte)46);
            GCCVersion GoodVersion = new GCCVersion(VersionText.str(), -1, -1, -1, NativePointer.$EMPTY, NativePointer.$EMPTY, NativePointer.$EMPTY);
            if (((StringRef)First.first).getAsInteger$Signed(10, GoodVersion.MajorRef) || GoodVersion.Major < 0) {
                return BadVersion;
            }
            GoodVersion.MajorStr.$assignMove(((StringRef)First.first).str());
            if (((StringRef)First.second).empty()) {
                return GoodVersion;
            }
            if (((StringRef)Second.first).getAsInteger$Signed(10, GoodVersion.MinorRef) || GoodVersion.Minor < 0) {
                return BadVersion;
            }
            GoodVersion.MinorStr.$assignMove(((StringRef)Second.first).str());
            StringRef PatchText = new StringRef(GoodVersion.PatchSuffix.$assignMove(((StringRef)Second.second).str()));
            if (!PatchText.empty() && (EndNumber = PatchText.find_first_not_of("0123456789")) != 0) {
                if (PatchText.slice(0, EndNumber).getAsInteger$Signed(10, GoodVersion.PatchRef) || GoodVersion.Patch < 0) {
                    return BadVersion;
                }
                GoodVersion.PatchSuffix.$assignMove(PatchText.substr(EndNumber).$basic_string());
            }
            return GoodVersion;
        }

        public boolean isOlderThan(int RHSMajor, int RHSMinor, int RHSPatch) {
            return this.isOlderThan(RHSMajor, RHSMinor, RHSPatch, new StringRef());
        }

        public boolean isOlderThan(int RHSMajor, int RHSMinor, int RHSPatch, StringRef RHSPatchSuffix) {
            if (this.Major != RHSMajor) {
                return this.Major < RHSMajor;
            }
            if (this.Minor != RHSMinor) {
                return this.Minor < RHSMinor;
            }
            if (this.Patch != RHSPatch) {
                if (RHSPatch == -1) {
                    return true;
                }
                if (this.Patch == -1) {
                    return false;
                }
                return this.Patch < RHSPatch;
            }
            if (llvm.$noteq_StringRef((StringRef)new StringRef(this.PatchSuffix), (StringRef)RHSPatchSuffix)) {
                if (RHSPatchSuffix.empty()) {
                    return true;
                }
                if (this.PatchSuffix.empty()) {
                    return false;
                }
                return llvm.$less_StringRef((StringRef)new StringRef(this.PatchSuffix), (StringRef)RHSPatchSuffix);
            }
            return false;
        }

        public boolean $less(GCCVersion RHS) {
            return this.isOlderThan(RHS.Major, RHS.Minor, RHS.Patch, new StringRef(RHS.PatchSuffix));
        }

        public boolean $greater(GCCVersion RHS) {
            return RHS.$less(this);
        }

        public boolean $lesseq(GCCVersion RHS) {
            return !this.$greater(RHS);
        }

        public boolean $greatereq(GCCVersion RHS) {
            return !this.$less(RHS);
        }

        public GCCVersion(GCCVersion $Prm0) {
            this.Text = new std.string($Prm0.Text);
            this.Major = $Prm0.Major;
            this.Minor = $Prm0.Minor;
            this.Patch = $Prm0.Patch;
            this.MajorStr = new std.string($Prm0.MajorStr);
            this.MinorStr = new std.string($Prm0.MinorStr);
            this.PatchSuffix = new std.string($Prm0.PatchSuffix);
        }

        public GCCVersion(JavaDifferentiators.JD.Move _dparam, GCCVersion $Prm0) {
            this.Text = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Text);
            this.Major = $Prm0.Major;
            this.Minor = $Prm0.Minor;
            this.Patch = $Prm0.Patch;
            this.MajorStr = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.MajorStr);
            this.MinorStr = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.MinorStr);
            this.PatchSuffix = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.PatchSuffix);
        }

        public GCCVersion $assign(GCCVersion $Prm0) {
            this.Text.$assign($Prm0.Text);
            this.Major = $Prm0.Major;
            this.Minor = $Prm0.Minor;
            this.Patch = $Prm0.Patch;
            this.MajorStr.$assign($Prm0.MajorStr);
            this.MinorStr.$assign($Prm0.MinorStr);
            this.PatchSuffix.$assign($Prm0.PatchSuffix);
            return this;
        }

        public GCCVersion $assignMove(GCCVersion $Prm0) {
            this.Text.$assignMove($Prm0.Text);
            this.Major = $Prm0.Major;
            this.Minor = $Prm0.Minor;
            this.Patch = $Prm0.Patch;
            this.MajorStr.$assignMove($Prm0.MajorStr);
            this.MinorStr.$assignMove($Prm0.MinorStr);
            this.PatchSuffix.$assignMove($Prm0.PatchSuffix);
            return this;
        }

        public void $destroy() {
            this.PatchSuffix.$destroy();
            this.MinorStr.$destroy();
            this.MajorStr.$destroy();
            this.Text.$destroy();
        }

        public GCCVersion() {
            this.Text = new std.string();
            this.MajorStr = new std.string();
            this.MinorStr = new std.string();
            this.PatchSuffix = new std.string();
        }

        public String toString() {
            return "Text=" + this.Text + ", Major=" + this.Major + ", Minor=" + this.Minor + ", Patch=" + this.Patch + ", MajorStr=" + this.MajorStr + ", MinorStr=" + this.MinorStr + ", PatchSuffix=" + this.PatchSuffix;
        }
    }
}

