/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RefreshAction
extends SingleHostAction {
    private static final RequestProcessor RP = new RequestProcessor("RefreshAction", 1);

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"RefreshMenuItem");
    }

    @Override
    protected boolean enable(ExecutionEnvironment env) {
        return env.isRemote() && ConnectionManager.getInstance().isConnectedTo(env);
    }

    @Override
    public boolean isVisible(Node node) {
        ExecutionEnvironment env = (ExecutionEnvironment)node.getLookup().lookup(ExecutionEnvironment.class);
        return env != null && env.isRemote() && Boolean.getBoolean("remote.host.actions.refresh");
    }

    @Override
    protected void performAction(final ExecutionEnvironment env, Node node) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject rootFO;
                if (ConnectionManager.getInstance().isConnectedTo(env) && (rootFO = FileSystemProvider.getFileObject((ExecutionEnvironment)env, (String)"/")) != null) {
                    FileSystemProvider.scheduleRefresh((FileObject)rootFO);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RefreshAction.class, (String)"RefreshScheduled", (Object)env.getDisplayName()));
                }
            }
        });
    }
}

