/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitSubmoduleStatus;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class SubmoduleStatusCommand
extends GitCommand {
    private final VCSFileProxy[] roots;
    private final LinkedHashMap<VCSFileProxy, GitSubmoduleStatus> statuses;
    private final ProgressMonitor monitor;

    public SubmoduleStatusCommand(JGitRepository repository, GitClassFactory classFactory, VCSFileProxy[] roots, ProgressMonitor monitor) {
        super(repository, classFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.statuses = new LinkedHashMap();
    }

    public Map<VCSFileProxy, GitSubmoduleStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "submodule");
        this.addArgument(0, "status");
        this.addFiles(0, this.roots);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        SubmoduleStatusCommand.this.parseStatusOutput(output);
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseStatusOutput(String output) {
        for (String line : output.split("\n")) {
            if (line.indexOf(32) < 0) continue;
            char c = line.charAt(0);
            String[] s = (line = line.substring(1)).split(" ");
            if (s.length != 2) continue;
            VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)s[1]);
            GitSubmoduleStatus.StatusType st = GitSubmoduleStatus.StatusType.INITIALIZED;
            switch (c) {
                case '-': {
                    st = GitSubmoduleStatus.StatusType.UNINITIALIZED;
                    break;
                }
                case '+': {
                    st = GitSubmoduleStatus.StatusType.REV_CHECKED_OUT;
                    break;
                }
                case 'U': {
                    st = GitSubmoduleStatus.StatusType.MISSING;
                }
            }
            this.statuses.put(file, this.getClassFactory().createSubmoduleStatus(st, file));
        }
    }
}

