/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class MavenSourceLevelImpl
implements SourceLevelQueryImplementation2 {
    static final Pattern PROFILE = Pattern.compile("-profile (compact1|compact2|compact3){1}?");
    private final Project project;

    public MavenSourceLevelImpl(Project proj) {
        this.project = proj;
    }

    private String getSourceLevelString(FileObject javaFile) {
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return null;
        }
        URI uri = Utilities.toURI((File)file);
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        String property = "maven.compiler.source";
        String param = "source";
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI testuri : nbprj.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
            property = "maven.compiler.testSource";
            param = "testSource";
        }
        for (URI testuri : nbprj.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
            property = "maven.compiler.testSource";
            param = "testSource";
        }
        String sourceLevel = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", param, goal, property);
        if (sourceLevel != null) {
            return sourceLevel;
        }
        if ("testCompile".equals(goal) && (sourceLevel = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "source", "testCompile", "maven.compiler.source")) != null) {
            return sourceLevel;
        }
        String version = PluginPropertyUtils.getPluginVersion(nbprj.getOriginalMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
        if (version == null || new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("2.3")) >= 0) {
            return "1.5";
        }
        return "1.3";
    }

    private SourceLevelQuery.Profile getSourceProfile(FileObject javaFile) {
        Matcher match;
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return SourceLevelQuery.Profile.DEFAULT;
        }
        URI uri = Utilities.toURI((File)file);
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI testuri : nbprj.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        for (URI testuri : nbprj.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        String args = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", goal, null);
        if (args != null && (match = PROFILE.matcher(args)).find()) {
            String prof = match.group(1);
            SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)prof);
            return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
        }
        String compilerArgumentsProfile = PluginPropertyUtils.getPluginPropertyBuildable(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", goal, new ConfigBuilder());
        if (compilerArgumentsProfile != null) {
            SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)compilerArgumentsProfile);
            return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
        }
        String[] compilerArgs = PluginPropertyUtils.getPluginPropertyList(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgs", "arg", goal);
        if (compilerArgs != null) {
            Iterator<String> it = Arrays.asList(compilerArgs).iterator();
            while (it.hasNext()) {
                String p = it.next();
                if (!"-profile".equals(p) || !it.hasNext()) continue;
                String prof = it.next();
                SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)prof);
                return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
            }
        }
        return SourceLevelQuery.Profile.DEFAULT;
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        return new ResultImpl(javaFile);
    }

    private class ResultImpl
    implements SourceLevelQueryImplementation2.Result2,
    PropertyChangeListener {
        private final FileObject javaFile;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MavenSourceLevelImpl.access$100(MavenSourceLevelImpl.this).getLookup().lookup(NbMavenProject.class));
        private String cachedLevel = null;
        private SourceLevelQuery.Profile cachedProfile;
        private final Object CACHE_LOCK = new Object();

        ResultImpl(FileObject javaFile) {
            this.javaFile = javaFile;
            ((NbMavenProject)MavenSourceLevelImpl.this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.pcl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSourceLevel() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedLevel == null) {
                    this.cachedLevel = MavenSourceLevelImpl.this.getSourceLevelString(this.javaFile);
                }
                return this.cachedLevel;
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                Project p = (Project)evt.getSource();
                if (((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).isUnloadable()) {
                    return;
                }
                Object object = this.CACHE_LOCK;
                synchronized (object) {
                    this.cachedLevel = null;
                    this.cachedProfile = null;
                }
                this.cs.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceLevelQuery.Profile getProfile() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedProfile == null) {
                    this.cachedProfile = MavenSourceLevelImpl.this.getSourceProfile(this.javaFile);
                }
                return this.cachedProfile;
            }
        }
    }

    private static class ConfigBuilder
    implements PluginPropertyUtils.ConfigurationBuilder<String> {
        private ConfigBuilder() {
        }

        @Override
        public String build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
            Xpp3Dom prof;
            Xpp3Dom args;
            if (configRoot != null && (args = configRoot.getChild("compilerArguments")) != null && (prof = args.getChild("profile")) != null) {
                return prof.getValue();
            }
            return null;
        }
    }
}

