/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.symtab;

import java.util.ArrayList;
import org.netbeans.modules.cnd.modelimpl.parser.symtab.SymTab;
import org.netbeans.modules.cnd.modelimpl.parser.symtab.SymTabEntry;
import org.openide.util.CharSequences;

public final class SymTabStack {
    private final ArrayList<SymTab> stack = new ArrayList();

    public static SymTabStack create() {
        return new SymTabStack();
    }

    private SymTabStack() {
    }

    public SymTab push() {
        SymTab symTab = new SymTab(this.stack.size(), CharSequences.empty());
        this.stack.add(symTab);
        return symTab;
    }

    public SymTab push(CharSequence name) {
        assert (CharSequences.isCompact((CharSequence)name)) : "only compact strings allowed";
        SymTab symTab = new SymTab(this.stack.size(), name);
        this.stack.add(symTab);
        return symTab;
    }

    public SymTab push(SymTab symTab) {
        this.stack.add(symTab);
        return symTab;
    }

    public SymTab pop() {
        if (!this.stack.isEmpty()) {
            return this.stack.remove(this.stack.size() - 1);
        }
        return null;
    }

    public SymTab pop(CharSequence name) {
        if (!this.stack.isEmpty() && this.stack.get(this.stack.size() - 1).getName().equals(name)) {
            return this.stack.remove(this.stack.size() - 1);
        }
        return null;
    }

    public SymTabEntry lookupLocal(CharSequence entry) {
        assert (CharSequences.isCompact((CharSequence)entry)) : "only compact strings allowed";
        return this.getLocal().lookup(entry);
    }

    public SymTabEntry lookup(CharSequence entry) {
        assert (CharSequences.isCompact((CharSequence)entry)) : "only compact strings allowed";
        assert (this.stack.size() > 0);
        SymTabEntry out = null;
        for (int i = this.stack.size() - 1; i >= 0 && (out = this.stack.get(i).lookup(entry)) == null; --i) {
        }
        return out;
    }

    public SymTabEntry enterLocal(CharSequence entry) {
        return this.getLocal().enter(entry);
    }

    public void importToLocal(SymTab symTab) {
        this.getLocal().importSymTab(symTab);
    }

    public int getSize() {
        return this.stack.size();
    }

    private SymTab getLocal() {
        return this.stack.get(this.stack.size() - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SymTabStack, nestingLevel=").append(this.stack.size());
        sb.append(", stack=");
        for (SymTab symTab : this.stack) {
            sb.append("\n").append(symTab);
        }
        return sb.toString();
    }
}

