/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class NamespaceAliasImpl
extends OffsetableDeclarationBase<CsmNamespaceAlias>
implements CsmNamespaceAlias,
RawNamable {
    private final CharSequence alias;
    private final CharSequence namespace;
    private final CharSequence rawName;
    private CsmUID<CsmNamespace> referencedNamespaceUID = null;
    private CsmUID<CsmScope> scopeUID = null;

    private NamespaceAliasImpl(AST ast, CsmFile file, CsmScope scope) {
        super(file, NamespaceAliasImpl.getStartOffset(ast), NamespaceAliasImpl.getEndOffset(ast));
        AST token;
        this._setScope(scope);
        this.rawName = NamespaceAliasImpl.createRawName(ast);
        this.alias = NameCache.getManager().getString(AstUtil.getText(ast));
        for (token = ast.getFirstChild(); token != null && token.getType() != 6; token = token.getNextSibling()) {
        }
        StringBuilder sb = new StringBuilder();
        if (token == null) {
            if (FileImpl.reportErrors) {
                int ln = ast.getLine();
                int col = ast.getColumn();
                AST child = ast.getFirstChild();
                if (child != null) {
                    ln = child.getLine();
                    col = child.getColumn();
                }
                System.err.println("Corrupted AST for namespace alias in " + file.getAbsolutePath() + ' ' + ln + ":" + col);
            }
            this.namespace = CharSequences.empty();
        } else {
            for (token = token.getNextSibling(); token != null; token = token.getNextSibling()) {
                sb.append(AstUtil.getText(token));
            }
            this.namespace = QualifiedNameCache.getManager().getString((CharSequence)sb);
        }
    }

    private NamespaceAliasImpl(CharSequence alias, CharSequence namespace, CharSequence rawName, CsmScope scope, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this._setScope(scope);
        this.rawName = rawName;
        this.alias = alias;
        this.namespace = namespace;
    }

    public static NamespaceAliasImpl create(AST ast, CsmFile file, CsmScope scope, boolean global) {
        NamespaceAliasImpl namespaceAliasImpl = new NamespaceAliasImpl(ast, file, scope);
        if (!global) {
            Utils.setSelfUID(namespaceAliasImpl);
        }
        return namespaceAliasImpl;
    }

    private void _setScope(CsmScope scope) {
        this.scopeUID = UIDCsmConverter.scopeToUID(scope);
        assert (this.scopeUID != null || scope == null);
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        assert (scope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        return scope;
    }

    public CsmNamespace getReferencedNamespace() {
        if (!this.isValid()) {
            return null;
        }
        CsmNamespace res = null;
        if (CharSequenceUtilities.startsWith((CharSequence)this.namespace, (CharSequence)"::")) {
            res = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(this.namespace.subSequence("::".length(), this.namespace.length()), true);
        } else {
            CsmScope scope = this.getScope();
            if (scope instanceof CsmNamespace) {
                CsmNamespace currentNamespace = (CsmNamespace)scope;
                do {
                    if (currentNamespace.isGlobal()) continue;
                    StringBuilder sb = new StringBuilder(currentNamespace.getQualifiedName());
                    sb.append("::");
                    sb.append(this.namespace);
                    res = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(sb, true);
                } while (res == null && (currentNamespace = currentNamespace.getParent()) != null);
            }
            if (res == null) {
                res = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(this.namespace, true);
            }
        }
        return res;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_ALIAS;
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public CharSequence getName() {
        return this.getAlias();
    }

    public CharSequence getQualifiedName() {
        CharSequence scopeQName;
        CsmScope scope = this.getScope();
        if ((scope instanceof CsmNamespace || scope instanceof CsmNamespaceDefinition) && (scopeQName = ((CsmQualifiedNamedElement)scope).getQualifiedName()) != null && scopeQName.length() > 0) {
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)scopeQName, (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    private static CharSequence createRawName(AST node) {
        AST token;
        for (token = node.getFirstChild(); token != null && token.getType() != 6; token = token.getNextSibling()) {
        }
        if (token != null && (token = token.getNextSibling()) != null && token.getType() == 574) {
            return AstUtil.getRawName(token.getFirstChild());
        }
        return CharSequences.empty();
    }

    @Override
    public CharSequence[] getRawName() {
        return AstUtil.toRawName(this.rawName);
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.alias + '=' + this.namespace + this.getPositionString();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope scope = this._getScope();
        if (scope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)scope).removeDeclaration(this);
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.alias != null);
        PersistentUtils.writeUTF(this.alias, output);
        assert (this.namespace != null);
        PersistentUtils.writeUTF(this.namespace, output);
        PersistentUtils.writeUTF(this.rawName, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedNamespaceUID, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    public NamespaceAliasImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.alias = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.alias != null);
        this.namespace = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.namespace != null);
        this.rawName = PersistentUtils.readUTF(input, NameCache.getManager());
        this.referencedNamespaceUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    public static class NamespaceAliasBuilder
    implements CsmObjectBuilder {
        private CharSequence name;
        private CharSequence namespaceName;
        private int nameStartOffset;
        private int nameEndOffset;
        private CsmDeclaration.Kind kind = CsmDeclaration.Kind.CLASS;
        private CsmFile file;
        private final FileContent fileContent;
        private int startOffset;
        private int endOffset;
        CsmVisibility visibility;
        private CsmObjectBuilder parent;
        private CsmScope scope;
        private NamespaceAliasImpl instance;
        private final List<CsmOffsetableDeclaration> declarations = new ArrayList<CsmOffsetableDeclaration>();

        public NamespaceAliasBuilder(FileContent fileContent) {
            assert (fileContent != null);
            this.fileContent = fileContent;
        }

        public void setKind(CsmDeclaration.Kind kind) {
            this.kind = kind;
        }

        public void setName(CharSequence name, int startOffset, int endOffset) {
            if (this.name == null) {
                this.name = name;
                this.nameStartOffset = startOffset;
                this.nameEndOffset = endOffset;
            }
        }

        public void setNamespaceName(CharSequence namespaceName) {
            this.namespaceName = namespaceName;
        }

        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public CharSequence getName() {
            return this.name;
        }

        public void setFile(CsmFile file) {
            this.file = file;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setParent(CsmObjectBuilder parent) {
            this.parent = parent;
        }

        public void addDeclaration(CsmOffsetableDeclaration decl) {
            this.declarations.add(decl);
        }

        private NamespaceAliasImpl getNamespaceAliasInstance() {
            CsmOffsetableDeclaration decl;
            if (this.instance != null) {
                return this.instance;
            }
            MutableDeclarationsContainer container = null;
            if (this.parent == null) {
                container = this.fileContent;
            } else if (this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                container = ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).getNamespaceDefinitionInstance();
            }
            if (container != null && this.name != null && (decl = container.findExistingDeclaration(this.startOffset, this.name, this.kind)) != null && NamespaceAliasImpl.class.equals(decl.getClass())) {
                this.instance = (NamespaceAliasImpl)decl;
            }
            return this.instance;
        }

        public void setScope(CsmScope scope) {
            assert (scope != null);
            this.scope = scope;
        }

        public CsmScope getScope() {
            if (this.scope != null) {
                return this.scope;
            }
            if (this.parent == null) {
                this.scope = (NamespaceImpl)this.file.getProject().getGlobalNamespace();
            } else if (this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                this.scope = ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).getNamespace();
            }
            return this.scope;
        }

        public NamespaceAliasImpl create() {
            NamespaceAliasImpl using = this.getNamespaceAliasInstance();
            CsmScope s = this.getScope();
            if (using == null && s != null && this.name != null && this.getScope() != null) {
                using = new NamespaceAliasImpl(this.name, this.namespaceName, this.name, this.scope, this.file, this.startOffset, this.endOffset);
                if (this.parent != null) {
                    ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).addDeclaration(using);
                } else {
                    this.fileContent.addDeclaration(using);
                }
            }
            if (this.getScope() instanceof CsmNamespace) {
                ((NamespaceImpl)this.getScope()).addDeclaration(using);
            }
            return using;
        }
    }
}

