/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion.entries;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionItem;
import org.netbeans.modules.php.smarty.editor.completion.entries.CodeCompletionEntries;
import org.netbeans.modules.php.smarty.editor.completion.entries.CodeCompletionEntryMetadata;
import org.openide.util.Exceptions;

public class SmartyCodeCompletionOffer {
    private static final ArrayList<TplCompletionItem> completionItemsFunctions = new ArrayList();
    private static final ArrayList<TplCompletionItem> completionItemsModifiers = new ArrayList();
    private static final HashMap<String, ArrayList<TplCompletionItem>> completionItemsFunctionParams = new HashMap();

    public static ArrayList<TplCompletionItem> getFunctions() {
        return completionItemsFunctions;
    }

    public static ArrayList<TplCompletionItem> getVariableModifiers() {
        return completionItemsModifiers;
    }

    public static HashMap<String, ArrayList<TplCompletionItem>> getFunctionParameters() {
        return completionItemsFunctionParams;
    }

    private static void loadFunctions(String[] types) {
        for (String completionType : types) {
            Collection<CodeCompletionEntryMetadata> ccList = SmartyCodeCompletionOffer.parseCCData(completionType);
            if (completionType.equals("built-in-functions")) {
                for (CodeCompletionEntryMetadata entryMetadata : ccList) {
                    completionItemsFunctions.add(new TplCompletionItem.BuiltInFunctionsCompletionItem(entryMetadata.getKeyword(), entryMetadata.getHelp(), entryMetadata.getHelpUrl()));
                    completionItemsFunctionParams.put(entryMetadata.getKeyword(), entryMetadata.getParameters());
                }
                continue;
            }
            if (!completionType.equals("custom-functions")) continue;
            for (CodeCompletionEntryMetadata entryMetadata : ccList) {
                completionItemsFunctions.add(new TplCompletionItem.CustomFunctionsCompletionItem(entryMetadata.getKeyword(), entryMetadata.getHelp(), entryMetadata.getHelpUrl()));
                completionItemsFunctionParams.put(entryMetadata.getKeyword(), entryMetadata.getParameters());
            }
        }
    }

    private static void loadModifiers(String functionsFile) {
        Collection<CodeCompletionEntryMetadata> ccList = SmartyCodeCompletionOffer.parseCCData(functionsFile);
        for (CodeCompletionEntryMetadata entryMetadata : ccList) {
            completionItemsModifiers.add(new TplCompletionItem.VariableModifiersCompletionItem(entryMetadata.getKeyword(), entryMetadata.getHelp(), entryMetadata.getHelpUrl()));
        }
    }

    private static Collection<CodeCompletionEntryMetadata> parseCCData(String filePath) {
        ArrayList<CodeCompletionEntryMetadata> ccList = new ArrayList<CodeCompletionEntryMetadata>();
        InputStream inputStream = SmartyCodeCompletionOffer.class.getResourceAsStream("defs/" + filePath + ".xml");
        try {
            Collection<CodeCompletionEntryMetadata> ccData = CodeCompletionEntries.readAllCodeCompletionEntriesFromXML(inputStream, filePath);
            ccList.addAll(ccData);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ccList;
    }

    static {
        SmartyCodeCompletionOffer.loadFunctions(new String[]{"built-in-functions", "custom-functions"});
        SmartyCodeCompletionOffer.loadModifiers("variable-modifiers");
    }
}

