/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons;

import java.awt.Color;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.PropertySheet;

public class ColorManager {
    private static final String TITLE_BACKGROUND = "TreeList.titleBackground";
    private static final String TITLE_SELECTION_BACKGROUND = "TreeList.titleSelectionBackground";
    private static final String ROOT_BACKGROUND = "TreeList.rootBackground";
    private static final String ROOT_SELECTION_BACKGROUND = "TreeList.rootSelectionBackground";
    private static ColorManager theInstance;
    private final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
    private final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    private final boolean isWindows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    private Color defaultBackground = UIManager.getColor("Tree.textBackground") == null ? UIManager.getColor("white") : UIManager.getColor("Tree.textBackground");
    private Color defaultForeground = UIManager.getColor("black");
    private Color disabledColor = Color.gray;
    private Color linkColor = null;
    private Color errorColor = new Color(153, 0, 0);
    private Color stableBuildColor = new Color(0, 153, 0);
    private Color unstableBuildColor = Color.yellow.darker().darker();
    private Color titleBackground;
    private Color titleSelectedBackground;
    private Color expandableRootBackground = null;
    private Color expandableRootForeground = null;
    private Color expandableRootSelectedBackground = null;
    private Color expandableRootSelectedForeground = null;

    private ColorManager() {
        this.deriveTreeListColors();
    }

    public static ColorManager getDefault() {
        if (null == theInstance) {
            theInstance = new ColorManager();
        }
        return theInstance;
    }

    public Color getDefaultBackground() {
        if (this.isAqua) {
            return UIManager.getColor("NbExplorerView.background");
        }
        return this.defaultBackground;
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public Color getStableBuildColor() {
        return this.stableBuildColor;
    }

    public static ColorManager getTheInstance() {
        return theInstance;
    }

    public Color getUnstableBuildColor() {
        return this.unstableBuildColor;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public Color getTitleSelectedBackground() {
        return this.titleSelectedBackground;
    }

    public Color getExpandableRootBackground() {
        return this.expandableRootBackground;
    }

    public Color getExpandableRootForeground() {
        return this.expandableRootForeground;
    }

    public Color getExpandableRootSelectedBackground() {
        return this.expandableRootSelectedBackground;
    }

    public Color getExpandableRootSelectedForeground() {
        return this.expandableRootSelectedForeground;
    }

    public boolean isAqua() {
        return this.isAqua;
    }

    public boolean isGtk() {
        return this.isGtk;
    }

    public boolean isNimbus() {
        return this.isNimbus;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    private void deriveTreeListColors() {
        int blue;
        int green;
        int red;
        new PropertySheet();
        Color controlColor = UIManager.getColor("control");
        if (controlColor == null) {
            controlColor = Color.LIGHT_GRAY;
        }
        if (this.isNimbus || this.isGtk) {
            this.expandableRootBackground = UIManager.getColor("Menu.background");
            this.expandableRootSelectedBackground = UIManager.getColor("Tree.selectionBackground");
        } else {
            this.expandableRootBackground = UIManager.getColor(ROOT_BACKGROUND);
            if (this.expandableRootBackground == null) {
                this.expandableRootBackground = UIManager.getColor("PropSheet.setBackground");
            }
            this.expandableRootSelectedBackground = UIManager.getColor(ROOT_SELECTION_BACKGROUND);
            if (this.expandableRootSelectedBackground == null) {
                this.expandableRootSelectedBackground = UIManager.getColor("PropSheet.selectedSetBackground");
            }
        }
        if (this.expandableRootBackground == null && this.expandableRootBackground == null) {
            red = ColorManager.adjustColorComponent(controlColor.getRed(), -25, -25);
            green = ColorManager.adjustColorComponent(controlColor.getGreen(), -25, -25);
            blue = ColorManager.adjustColorComponent(controlColor.getBlue(), -25, -25);
            this.expandableRootBackground = new Color(red, green, blue);
        }
        if (this.isAqua) {
            this.expandableRootBackground = new Color((int)Math.max(0.0, (double)this.expandableRootBackground.getRed() * 0.85), (int)Math.max(0.0, (double)this.expandableRootBackground.getGreen() * 0.85), (int)Math.max(0.0, (double)this.expandableRootBackground.getBlue() * 0.85));
        }
        if (this.expandableRootSelectedBackground == null) {
            Color col;
            Color color = col = this.isWindows ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (col == null) {
                col = Color.BLUE;
            }
            red = ColorManager.adjustColorComponent(col.getRed(), -25, -25);
            green = ColorManager.adjustColorComponent(col.getGreen(), -25, -25);
            blue = ColorManager.adjustColorComponent(col.getBlue(), -25, -25);
            this.expandableRootSelectedBackground = new Color(red, green, blue);
        }
        this.titleBackground = UIManager.getColor(TITLE_BACKGROUND);
        if (this.titleBackground == null) {
            this.titleBackground = Color.gray;
        }
        this.titleSelectedBackground = UIManager.getColor(TITLE_SELECTION_BACKGROUND);
        if (this.titleSelectedBackground == null) {
            this.titleSelectedBackground = this.expandableRootSelectedBackground;
        }
        this.expandableRootForeground = UIManager.getColor("PropSheet.setForeground");
        if (this.isNimbus || this.isGtk) {
            this.expandableRootForeground = new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        if (this.expandableRootForeground == null) {
            this.expandableRootForeground = UIManager.getColor("Table.foreground");
            if (this.expandableRootForeground == null) {
                this.expandableRootForeground = UIManager.getColor("textText");
                if (this.expandableRootForeground == null) {
                    this.expandableRootForeground = Color.BLACK;
                }
            }
        }
        this.expandableRootSelectedForeground = UIManager.getColor("PropSheet.selectedSetForeground");
        if (this.expandableRootSelectedForeground == null) {
            this.expandableRootSelectedForeground = UIManager.getColor("Table.selectionForeground");
            if (this.expandableRootSelectedForeground == null) {
                this.expandableRootSelectedForeground = Color.WHITE;
            }
        }
        if (this.isAqua) {
            this.expandableRootSelectedForeground = Color.black;
        }
        this.linkColor = UIManager.getColor("nb.html.link.foreground");
        if (null == this.linkColor) {
            this.linkColor = new Color(1461115);
        }
    }

    private static int adjustColorComponent(int base, int adjBright, int adjDark) {
        base = base > 128 ? (base -= adjBright) : (base += adjDark);
        if (base < 0) {
            base = 0;
        }
        if (base > 255) {
            base = 255;
        }
        return base;
    }
}

