/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.j2me.project.ui.customizer.AddMIDletPanel;
import org.netbeans.modules.j2me.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.j2me.project.ui.customizer.MIDletScanner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class J2MEMIDletsPanel
extends JPanel {
    private final DefaultComboBoxModel cbmClassesForAdd;
    private final DefaultComboBoxModel cbmIconsForAdd;
    protected HashSet<String> classes;
    protected HashSet<String> icons;
    private final MIDletsTableModel model;
    private final J2MEProjectProperties uiProperties;
    private final ListSelectionListener listSelectionListener;
    private final ChangeListener changeListener;
    private JButton addButton;
    private JButton downButton;
    private JButton editButton;
    private JPanel errorPanel;
    private JTable midletsTable;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JLabel tableLabel;
    private JButton upButton;

    public J2MEMIDletsPanel(J2MEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.model = this.uiProperties.MIDLETS_TABLE_MODEL;
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"ACSN_CustMIDlets"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"ACSD_CustMIDlets"));
        this.cbmClassesForAdd = new DefaultComboBoxModel();
        this.cbmIconsForAdd = new DefaultComboBoxModel();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                if (J2MEMIDletsPanel.this.classes != null && !J2MEMIDletsPanel.this.classes.containsAll(J2MEMIDletsPanel.this.model.getClasses())) {
                    ((ErrorPanel)J2MEMIDletsPanel.this.errorPanel).setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
                } else if (J2MEMIDletsPanel.this.icons != null && !J2MEMIDletsPanel.this.icons.containsAll(J2MEMIDletsPanel.this.model.getIcons())) {
                    ((ErrorPanel)J2MEMIDletsPanel.this.errorPanel).setErrorBundleMessage("ERR_CustMIDlets_WrongIcons");
                } else {
                    ((ErrorPanel)J2MEMIDletsPanel.this.errorPanel).setErrorBundleMessage(null);
                }
            }
        });
        this.midletsTable.setSelectionMode(0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int i = J2MEMIDletsPanel.this.midletsTable.getSelectedRow();
                boolean enabled = J2MEMIDletsPanel.this.midletsTable.isEnabled();
                boolean selected = enabled && i >= 0;
                J2MEMIDletsPanel.this.editButton.setEnabled(selected);
                J2MEMIDletsPanel.this.removeButton.setEnabled(selected);
                J2MEMIDletsPanel.this.upButton.setEnabled(enabled && i > 0);
                J2MEMIDletsPanel.this.downButton.setEnabled(selected && i < J2MEMIDletsPanel.this.model.getRowCount() - 1);
            }
        };
        this.midletsTable.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.midletsTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 1 && J2MEMIDletsPanel.this.classes != null && !J2MEMIDletsPanel.this.classes.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.midletsTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 2 && J2MEMIDletsPanel.this.icons != null && !J2MEMIDletsPanel.this.icons.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.midletsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    J2MEMIDletsPanel.this.editButtonActionPerformed(null);
                }
            }
        });
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int i;
                J2MEMIDletsPanel.this.classes = new HashSet();
                for (i = 0; i < J2MEMIDletsPanel.this.cbmClassesForAdd.getSize(); ++i) {
                    J2MEMIDletsPanel.this.classes.add((String)J2MEMIDletsPanel.this.cbmClassesForAdd.getElementAt(i));
                }
                J2MEMIDletsPanel.this.icons = new HashSet();
                for (i = 0; i < J2MEMIDletsPanel.this.cbmIconsForAdd.getSize(); ++i) {
                    J2MEMIDletsPanel.this.icons.add((String)J2MEMIDletsPanel.this.cbmIconsForAdd.getElementAt(i));
                }
                J2MEMIDletsPanel.this.model.fireTableDataChanged();
            }
        };
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.icons = null;
        this.classes = null;
        MIDletScanner scanner = MIDletScanner.getDefault(this.uiProperties);
        scanner.scan(this.cbmClassesForAdd, this.cbmIconsForAdd, this.changeListener);
        String[] propertyNames = this.uiProperties.MIDLETS_PROPERTY_NAMES;
        String[] values = new String[propertyNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
        }
        this.model.setDataDelegates(values);
        this.midletsTable.setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.listSelectionListener.valueChanged(null);
    }

    private void initComponents() {
        this.tableLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.midletsTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.tableLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.midletsTable.setModel(this.model);
        this.scrollPane.setViewportView(this.midletsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEMIDletsPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 12, 0, 8);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEMIDletsPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEMIDletsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.upButton.text"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEMIDletsPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.upButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"J2MEMIDletsPanel.downButton.text"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEMIDletsPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 12, 8);
        this.add((Component)this.downButton, gridBagConstraints);
        GroupLayout errorPanelLayout = new GroupLayout(this.errorPanel);
        this.errorPanel.setLayout(errorPanelLayout);
        errorPanelLayout.setHorizontalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        errorPanelLayout.setVerticalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String cname;
        int i;
        HashSet<String> hs = new HashSet<String>();
        for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
            hs.add(this.model.getValueAt(i2, 2).trim());
        }
        for (i = 0; i < this.cbmClassesForAdd.getSize() && hs.contains(this.cbmClassesForAdd.getElementAt(i)); ++i) {
        }
        String string = cname = i < this.cbmClassesForAdd.getSize() ? (String)this.cbmClassesForAdd.getElementAt(i) : null;
        if (cname != null) {
            cname = cname.trim();
        }
        AddMIDletPanel p = new AddMIDletPanel(null, cname, null, this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor desc = new DialogDescriptor((Object)p, NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"Title_CustMIDlets_AddMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.J2MEMIDletsPanel"), null);
        p.setDialogDescriptor(desc);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            this.model.addRow(p.getName(), p.getClazz(), p.getIcon());
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0) {
            return;
        }
        String[] s = this.model.getRow(editedRow).split(",", 3);
        AddMIDletPanel p = new AddMIDletPanel(s[0].trim(), s[2].trim(), s[1].trim(), this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor desc = new DialogDescriptor((Object)p, NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"Title_CustMIDlets_EditMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.J2MEMIDletsPanel"), null);
        p.setDialogDescriptor(desc);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            this.model.setRow(editedRow, p.getName(), p.getClazz(), p.getIcon());
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0) {
            return;
        }
        this.model.remove(editedRow);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 1) {
            return;
        }
        this.model.moveUp(editedRow);
        this.midletsTable.getSelectionModel().setSelectionInterval(editedRow - 1, editedRow - 1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0 || editedRow > this.midletsTable.getRowCount() - 2) {
            return;
        }
        this.model.moveDown(editedRow);
        this.midletsTable.getSelectionModel().setSelectionInterval(editedRow + 1, editedRow + 1);
    }

    public static class MIDletsTableModel
    extends AbstractTableModel {
        public static final String PREFIX = "MIDlet-";
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final int[] COLUMN_MAP = new int[]{0, 2, 1};
        private static final String[] COLUMN_NAMES = new String[]{NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"LBL_CustMIDletsName_Name"), NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"LBL_CustMIDlets_Class"), NbBundle.getMessage(J2MEMIDletsPanel.class, (String)"LBL_CustMIDlets_Icon")};
        private static final long serialVersionUID = -7485135564331430899L;
        private final J2MEProjectProperties uiProperties;
        private boolean dataDelegatesWereSet = false;

        public MIDletsTableModel(J2MEProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public String getColumnName(int column) {
            assert (column < 3);
            return COLUMN_NAMES[column];
        }

        public Set<String> getClasses() {
            HashSet<String> classes = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                classes.add(this.getValueAt(i, 1));
            }
            return classes;
        }

        public Set<String> getIcons() {
            HashSet<String> icons = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                String icon = this.getValueAt(i, 2);
                if (icon.length() <= 0) continue;
                icons.add(icon);
            }
            return icons;
        }

        public void addRow(String name, String clazz, String icon) {
            ++this.rows;
            this.setRow(this.rows - 1, name + ',' + icon + ',' + clazz);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
        }

        protected String getRow(int row) {
            assert (row < this.rows);
            String value = this.map.get(PREFIX + String.valueOf(row + 1));
            return value == null ? ",," : value;
        }

        private void setRow(int row, String value) {
            assert (row < this.rows);
            this.map.put(PREFIX + String.valueOf(row + 1), value);
        }

        public void remove(int row) {
            for (int i = row; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(row, row);
        }

        public void moveUp(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row - 1));
            this.setRow(row - 1, r);
            this.fireTableRowsUpdated(row - 1, row);
        }

        public void moveDown(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row + 1));
            this.setRow(row + 1, r);
            this.fireTableRowsUpdated(row, row + 1);
        }

        @Override
        public String getValueAt(int row, int column) {
            assert (column < 3);
            return this.getRow(row).split(",", 3)[COLUMN_MAP[column]].trim();
        }

        public synchronized Object[] getDataDelegates() {
            if (!this.dataDelegatesWereSet) {
                String[] propertyNames = this.uiProperties.MIDLETS_PROPERTY_NAMES;
                String[] values = new String[propertyNames.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
                }
                this.setDataDelegates(values);
            }
            return new Object[]{this.map};
        }

        public synchronized void setDataDelegates(String[] data) {
            this.map = data[0] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[0]);
            this.rows = 0;
            for (String key : this.map.keySet()) {
                if (!key.startsWith(PREFIX)) continue;
                try {
                    int i = Integer.parseInt(key.substring(PREFIX.length()));
                    if (i <= this.rows) continue;
                    this.rows = i;
                }
                catch (NumberFormatException nfe) {
                    assert (false) : nfe;
                }
            }
            this.fireTableDataChanged();
            this.dataDelegatesWereSet = true;
        }

        public void setRow(int row, String name, String clazz, String icon) {
            this.setRow(row, name + ',' + icon + ',' + clazz);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

