/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.commit;

import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ConflictResolvedAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "resolve";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 16448;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        final VCSFileProxy[] files = ctx.getFiles();
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                SvnClient client = null;
                try {
                    client = Subversion.getInstance().getClient(ctx, (SvnProgressSupport)this);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException(ctx, ex, false, false);
                }
                if (client == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    VCSFileProxy file = files[i];
                    try {
                        ConflictResolvedAction.perform(file, client);
                        continue;
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                }
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    public static void perform(final VCSFileProxy file) throws SVNClientException {
        SvnProgressSupport support = new SvnProgressSupport(VCSFileProxySupport.getFileSystem((VCSFileProxy)file)){

            @Override
            protected void perform() {
                try {
                    SvnClient client = Subversion.getInstance().getClient(file);
                    if (client != null) {
                        ConflictResolvedAction.perform(file, client);
                    }
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                }
            }
        };
        SVNUrl url = ContextAction.getSvnUrl(new Context(file));
        support.start(Subversion.getInstance().getRequestProcessor(url), url, NbBundle.getMessage(ConflictResolvedAction.class, (String)"LBL_ResolvingConflicts"));
    }

    private static void perform(VCSFileProxy file, SvnClient client) throws SVNClientException {
        FileObject folder;
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        client.resolved(file);
        cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        VCSFileProxy parent = file.getParentFile();
        if (parent != null && (folder = parent.toFileObject()) != null) {
            folder.refresh();
        }
    }
}

