/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.commit;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.SvnFileNode;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class CommitTableModel
extends AbstractTableModel {
    public static final String COLUMN_NAME_COMMIT = "commit";
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    private final int STATUS_DELETED = 2304;
    private final int STATUS_NEW = 4100;
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private CommitOptions[] commitOptions;
    private SvnFileNode[] nodes;
    private Index index;
    private String[] columns;

    public CommitTableModel(String[] columns) {
        this.setColumns(columns);
        this.setNodes(new SvnFileNode[0]);
    }

    void setNodes(SvnFileNode[] nodes) {
        this.nodes = nodes;
        this.index = new Index();
        this.defaultCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        HashMap<SvnFileNode, CommitOptions> ret = new HashMap<SvnFileNode, CommitOptions>(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            ret.put(this.nodes[i], this.commitOptions[i]);
        }
        return ret;
    }

    @Override
    public String getColumnName(int column) {
        return columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return Boolean.class;
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals(COLUMN_NAME_COMMIT);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return this.commitOptions[rowIndex] != CommitOptions.EXCLUDE;
        }
        if (col.equals(COLUMN_NAME_NAME)) {
            return this.nodes[rowIndex].getName();
        }
        if (col.equals(COLUMN_NAME_BRANCH)) {
            String branch = this.nodes[rowIndex].getCopy();
            return branch == null ? "" : branch;
        }
        if (col.equals(COLUMN_NAME_STATUS)) {
            SvnFileNode node = this.nodes[rowIndex];
            FileInformation finfo = node.getInformation();
            return finfo.getStatusText();
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return this.commitOptions[rowIndex];
        }
        if (col.equals(COLUMN_NAME_PATH)) {
            String shortPath = null;
            if (this.rootFile != null) {
                shortPath = this.rootFile.repositoryPath + '/';
            } else {
                shortPath = this.nodes[rowIndex].getLocation();
                if (shortPath == null) {
                    shortPath = NbBundle.getMessage(CommitTableModel.class, (String)"CTL_CommitForm_NotInRepository");
                }
            }
            return shortPath;
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_ACTION)) {
            this.commitOptions[rowIndex] = (CommitOptions)aValue;
        } else if (col.equals(COLUMN_NAME_COMMIT)) {
            this.commitOptions[rowIndex] = this.getCommitOptions(rowIndex, (Boolean)aValue);
        } else {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.includeExcludeTree(new int[]{rowIndex}, this.commitOptions[rowIndex] != CommitOptions.EXCLUDE, false);
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    private void defaultCommitOptions() {
        if (this.nodes.length == 0) {
            return;
        }
        boolean excludeNew = SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.nodes[0].getFile())).getExludeNewFiles();
        this.commitOptions = SvnUtils.createDefaultCommitOptions(this.nodes, excludeNew);
        this.ensureFilesExcluded();
    }

    public SvnFileNode getNode(int row) {
        return this.nodes[row];
    }

    public CommitOptions getOptions(int row) {
        return this.commitOptions[row];
    }

    void setRootFile(String repositoryPath, String rootLocalPath) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = repositoryPath;
        this.rootFile.rootLocalPath = rootLocalPath;
    }

    void setIncluded(int[] rows, boolean include, boolean recursively) {
        for (int rowIndex : rows) {
            this.commitOptions[rowIndex] = this.getCommitOptions(rowIndex, include);
        }
        this.includeExcludeTree(rows, include, recursively);
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    void setAdded(int[] rows, CommitOptions addOption) {
        for (int rowIndex : rows) {
            this.commitOptions[rowIndex] = addOption;
        }
        this.includeExcludeTree(rows, true, false);
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    private void includeExcludeTree(int[] rows, boolean include, boolean recursively) {
        LinkedList<Integer> rowList = new LinkedList<Integer>();
        for (int row : rows) {
            rowList.add(row);
        }
        if (include) {
            this.includeExcludeChildren(rowList, recursively ? -1 : 2304, true);
            this.includeExcludeParents(rowList, 4100, true);
        } else {
            this.includeExcludeChildren(rowList, recursively ? -1 : 4100, false);
            this.includeExcludeParents(rowList, 2304, false);
        }
    }

    private CommitOptions getCommitOptions(int rowIndex, boolean include) {
        return include ? this.getCommitOptions(rowIndex) : CommitOptions.EXCLUDE;
    }

    private CommitOptions getCommitOptions(int rowIndex) {
        SvnFileNode node = this.nodes[rowIndex];
        return SvnUtils.getDefaultCommitOptions(node, false);
    }

    private void ensureFilesExcluded() {
        LinkedList<Integer> newFilesExcluded = new LinkedList<Integer>();
        LinkedList<Integer> deletedFilesExcluded = new LinkedList<Integer>();
        for (int i = 0; i < this.nodes.length; ++i) {
            SvnFileNode node = this.nodes[i];
            if (CommitOptions.EXCLUDE.equals(this.commitOptions[i]) && (node.getInformation().getStatus() & 0x1004) != 0) {
                newFilesExcluded.add(i);
                continue;
            }
            if (!CommitOptions.EXCLUDE.equals(this.commitOptions[i]) || (node.getInformation().getStatus() & 0x900) == 0) continue;
            deletedFilesExcluded.add(i);
        }
        this.includeExcludeChildren(newFilesExcluded, 4100, false);
        this.includeExcludeParents(deletedFilesExcluded, 2304, false);
    }

    private void includeExcludeParents(Collection<Integer> nodeIndexes, int statusMask, boolean include) {
        boolean includeExcludeWholeTree = include && (statusMask & 0x900) != 0 || !include && (statusMask & 0x1004) != 0;
        HashSet<Integer> toCheck = new HashSet<Integer>();
        boolean[] checkedNodes = new boolean[this.nodes.length];
        block0: for (int nodeIndex : nodeIndexes) {
            checkedNodes[nodeIndex] = true;
            Integer parentIndex = nodeIndex;
            while (parentIndex != null && (this.nodes[parentIndex].getInformation().getStatus() & statusMask) != 0) {
                nodeIndex = parentIndex;
                if (!includeExcludeWholeTree && this.includeExcludeEnabled(nodeIndex, include)) {
                    this.commitOptions[nodeIndex] = this.getCommitOptions(nodeIndex, include);
                }
                if ((parentIndex = this.index.getParent(nodeIndex)) == null || !checkedNodes[parentIndex]) continue;
                continue block0;
            }
            toCheck.add(nodeIndex);
        }
        if (includeExcludeWholeTree) {
            this.includeExcludeChildren(toCheck, statusMask, include);
        }
    }

    private void includeExcludeChildren(Collection<Integer> nodeIndexes, int statusMask, boolean include) {
        boolean[] checkedNodes = new boolean[this.nodes.length];
        HashSet<Integer> toCheck = new HashSet<Integer>();
        for (int nodeIndex : nodeIndexes) {
            toCheck.add(nodeIndex);
        }
        while (!toCheck.isEmpty()) {
            Integer[] childrenIndexes;
            Iterator it = toCheck.iterator();
            Integer nodeIndex = (Integer)it.next();
            it.remove();
            if (checkedNodes[nodeIndex]) continue;
            checkedNodes[nodeIndex.intValue()] = true;
            SvnFileNode node = this.nodes[nodeIndex];
            if ((node.getInformation().getStatus() & statusMask) == 0) continue;
            if (this.includeExcludeEnabled(nodeIndex, include)) {
                this.commitOptions[nodeIndex.intValue()] = this.getCommitOptions(nodeIndex, include);
            }
            if ((childrenIndexes = this.index.getChildren(nodeIndex)) == null) continue;
            toCheck.addAll(Arrays.asList(childrenIndexes));
        }
    }

    private boolean includeExcludeEnabled(int nodeIndex, boolean include) {
        return !include || this.commitOptions[nodeIndex] == CommitOptions.EXCLUDE;
    }

    static {
        ResourceBundle loc = NbBundle.getBundle(CommitTableModel.class);
        columnLabels.put(COLUMN_NAME_COMMIT, new String[]{loc.getString("CTL_CommitTable_Column_Commit"), loc.getString("CTL_CommitTable_Column_Description")});
        columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_BRANCH, new String[]{loc.getString("CTL_CommitTable_Column_Branch"), loc.getString("CTL_CommitTable_Column_Branch")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
    }

    private class Index {
        private HashMap<VCSFileProxy, Value> fileToIndex;

        public Index() {
            this.constructIndex();
        }

        private void constructIndex() {
            int i;
            this.fileToIndex = new HashMap(CommitTableModel.this.nodes.length);
            for (i = 0; i < CommitTableModel.this.nodes.length; ++i) {
                Value value = new Value(i);
                this.fileToIndex.put(CommitTableModel.this.nodes[i].getFile(), value);
            }
            for (i = 0; i < CommitTableModel.this.nodes.length; ++i) {
                Value value;
                VCSFileProxy parentFile = CommitTableModel.this.nodes[i].getFile().getParentFile();
                if (parentFile == null || (value = this.fileToIndex.get(parentFile)) == null) continue;
                value.addChild(i);
            }
        }

        private Integer getParent(int nodeIndex) {
            VCSFileProxy parentFile = CommitTableModel.this.nodes[nodeIndex].getFile().getParentFile();
            Value parentValue = parentFile == null ? null : this.fileToIndex.get(parentFile);
            return parentValue == null ? null : parentValue.nodeIndex;
        }

        private Integer[] getChildren(int nodeIndex) {
            Value value = this.fileToIndex.get(CommitTableModel.this.nodes[nodeIndex].getFile());
            return value == null || value.childrenIndexes == null ? null : value.childrenIndexes.toArray(new Integer[value.childrenIndexes.size()]);
        }

        private class Value {
            private Integer nodeIndex;
            private Set<Integer> childrenIndexes;

            private Value(int index2) {
                this.nodeIndex = index2;
            }

            private void addChild(int childIndex) {
                if (this.childrenIndexes == null) {
                    this.childrenIndexes = new HashSet<Integer>();
                }
                this.childrenIndexes.add(childIndex);
            }
        }
    }

    private static class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

