/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.DebugComponent;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Verifier {
    static int verbose = 1;
    static String packageName = null;
    static boolean printTrace = false;

    public static void main(String[] stringArray) {
        int n;
        Object object;
        boolean bl = true;
        List<String> list = Arrays.asList(stringArray);
        if (list.contains("-C") || list.contains("--commandoptionsfile")) {
            if (stringArray.length == 2 && (stringArray[0].equals("-C") || stringArray[0].equals("--commandoptionsfile"))) {
                try {
                    object = new FileInputStream(new File(stringArray[1]).getCanonicalPath());
                    stringArray = Verifier.getArgsFromFile((FileInputStream)object);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.exit(1);
                }
            } else {
                Verifier.printUsageAndExit();
            }
        }
        for (n = 0; n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-'; ++n) {
            object = stringArray[n];
            if (((String)object).equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (((String)object).equals("-nobanner")) {
                bl = false;
                continue;
            }
            if (((String)object).equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (((String)object).equals("-help")) {
                Verifier.printUsageAndExit();
                continue;
            }
            if (((String)object).equals("-version")) {
                Messages.println("Main.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            if (((String)object).equals("-package") && n + 1 < stringArray.length) {
                packageName = stringArray[++n];
                continue;
            }
            Verifier.printUsageAndExit();
        }
        if (n == stringArray.length) {
            Verifier.printUsageAndExit();
        }
        Messages.println("Main.3", ToolsVersion.getVersion(2));
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        boolean bl2 = false;
        while (n < stringArray.length) {
            try {
                String string = stringArray[n];
                File file = new File(string);
                if (string.endsWith(".exp")) {
                    ImportComponent.readExportFile(file);
                } else {
                    if (verbose >= 1) {
                        Messages.println("Main.4", string);
                    }
                    Messages.numWarning = 0;
                    Cap.readComponents(file);
                    Verifier.consistencyChecks();
                    if (verbose >= 1) {
                        Messages.println("Main.5", Messages.numWarning);
                    }
                    bl2 = true;
                }
            }
            catch (VerifierError verifierError) {
                Messages.printSevere("Main.2", Messages.numWarning, verifierError.getMessage(), Messages.format("Main.6"));
                System.exit(2);
            }
            ++n;
        }
        if (!bl2 && verbose >= 1) {
            Verifier.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("Main.1");
        System.exit(2);
    }

    private static void consistencyChecks() {
        Cap.Header.verify();
        if (Cap.debugComponentDataBuffer != null) {
            if (Cap.Header.minorVersion() == 2) {
                Cap.Debug = new DebugComponent(Cap.debugComponentDataBuffer);
            } else {
                Cap.addCustomComponent(Cap.debugComponentDataBuffer, Cap.debugComponentTag);
            }
        }
        Cap.Directory.verify();
        Cap.Descriptor.verify();
        Cap.Import.verify();
        if (Cap.Export != null) {
            Cap.Export.findExportFile();
        }
        Cap.Import.initialize();
        Classref.initialize();
        AbstrInterp.initialize();
        Cap.ConstantPool.verify();
        Cap.Class.verify();
        Cap.Method.verify();
        Cap.StaticField.verify();
        Cap.ReferenceLocation.verify();
        if (Cap.Applet != null) {
            Cap.Applet.verify();
        }
        if (Cap.Export != null) {
            Cap.Export.verify();
        }
        Cap.Import.checkUnreferencedPackages();
        Cap.Header.checkIntFlag();
        if (Cap.Debug != null && Cap.capMinorVersion == 2) {
            Cap.Debug.verify();
        }
    }

    public static void verifyCap(FileInputStream fileInputStream, String string, Vector<File> vector) throws Exception {
        packageName = string;
        ImportComponent.resetExportFileList();
        for (int i = 0; i < vector.size(); ++i) {
            ImportComponent.readExportFile(vector.elementAt(i));
        }
        Cap.readComponents(fileInputStream);
        Verifier.consistencyChecks();
    }

    private static String[] getArgsFromFile(FileInputStream fileInputStream) {
        String[] stringArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString());
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

