/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfMethod
extends MethodDefinition {
    private int name_index;
    private int descriptor_index;
    EfConstantPool constant_pool;

    public EfMethod(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfMethod(MethodDefinition methodDefinition, EfConstantPool efConstantPool) {
        super(methodDefinition);
        this.access_flags &= 0xFFFFFEFF;
        this.access_flags &= 0xFFFFF7FF;
        this.constant_pool = efConstantPool;
        this.name_index = this.constant_pool.addConstantUtf8(this.method_name);
        this.descriptor_index = this.constant_pool.addConstantUtf8(this.descriptor);
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.token = dataInputStream.readUnsignedByte();
        this.access_flags = dataInputStream.readShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getUtf8String();
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "method_info {");
        printWriter.println(string + "\ttoken\t" + Integer.toString(this.token));
        printWriter.println(string + "\taccess_flags\t" + Modifier.toString(this.access_flags));
        printWriter.println(string + "\tname_index\t" + this.name_index + "\t\t// " + this.method_name);
        printWriter.println(string + "\tDescriptor_Index\t" + this.descriptor_index + "\t\t// " + this.descriptor);
        printWriter.println(string + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.token);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.descriptor_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }
}

