/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.CadT1;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ServerT1Protocol {
    CadT1 cad;
    private Vector<CadServerListener> listeners = new Vector();
    protected boolean numSeq = false;
    protected boolean numSeqTx = true;
    protected boolean numSeqRcv = true;
    protected T1Block nextIBlock = null;
    protected int nextBlockDataOffset = 0;
    protected T1Block blockOutgoing;
    protected T1Block blockIncoming;
    protected boolean lastBlockFlag = false;
    int sizeINF;
    private int sizeIFSD;
    private int sizeIFSC;
    private boolean recvFirstBlock = true;
    private static final int T1SERVER_STATE_CLOSED = 0;
    private static final int T1SERVER_STATE_OPEN = 1;
    private static final int T1SERVER_STATE_ACTIVE = 2;
    private int serverState = 0;

    public ServerT1Protocol(InputStream inputStream, OutputStream outputStream) {
        this.cad = new CadT1(inputStream, outputStream);
        this.sizeIFSC = 32;
        this.sizeIFSD = 32;
        this.blockOutgoing = new T1Block();
        this.blockIncoming = new T1Block();
    }

    public void addCadServerListener(CadServerListener cadServerListener) {
        this.listeners.addElement(cadServerListener);
    }

    public void removeCadServerListener(CadServerListener cadServerListener) {
        this.listeners.removeElement(cadServerListener);
    }

    private void notifyPowerDown() {
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((CadServerListener)vector.elementAt(i)).powerDown(new CadEvent(this));
        }
    }

    private void placeDataInBuffer(byte[] byArray, short[] sArray, short s, short s2) {
        byte[] byArray2 = this.nextIBlock.getINFBytes();
        int n = this.nextIBlock.getLEN() - this.nextBlockDataOffset;
        if (n + s > s2) {
            int n2 = s2 - s;
            System.arraycopy(byArray2, this.nextBlockDataOffset, byArray, s, n2);
            sArray[0] = (short)n2;
            this.nextBlockDataOffset += n2;
            this.lastBlockFlag = false;
        } else {
            System.arraycopy(byArray2, this.nextBlockDataOffset, byArray, s, n);
            sArray[0] = (short)n;
            this.lastBlockFlag = this.nextIBlock.isLastBlock();
            this.nextIBlock = null;
            this.nextBlockDataOffset = 0;
        }
    }

    private short t1ReplySBlock(boolean[] blArray) throws T1Exception, IOException {
        byte by = this.blockIncoming.getSBlockType();
        switch (by) {
            case -64: 
            case -63: {
                throw new T1Exception(-125);
            }
            case -61: {
                throw new T1Exception(-124);
            }
            case -62: {
                boolean bl = true;
                while (bl) {
                    boolean bl2;
                    byte by2;
                    this.blockOutgoing.setSBlock((byte)0, (byte)0, -30, 0);
                    boolean bl3 = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                    if (!bl3) {
                        this.notifyPowerDown();
                    }
                    if ((by2 = this.blockIncoming.getBlockType()) == 0) {
                        bl2 = this.blockIncoming.getSequence();
                        if (bl2 != this.numSeqRcv) {
                            this.numSeqRcv = bl2;
                            this.nextIBlock = this.blockIncoming;
                            blArray[0] = false;
                            bl = false;
                            continue;
                        }
                        throw new T1Exception(-126);
                    }
                    if (by2 == -128) {
                        bl2 = this.blockIncoming.getSequence();
                        if (bl2 != this.numSeqTx) {
                            blArray[0] = true;
                            continue;
                        }
                        throw new T1Exception(-124);
                    }
                    throw new T1Exception(-126);
                }
                break;
            }
            default: {
                throw new T1Exception(-124);
            }
        }
        return 0;
    }

    public short t1SndBlockRcvAck(byte[] byArray, int n, int n2, boolean bl) throws T1Exception {
        try {
            boolean bl2 = true;
            block7: while (bl2) {
                this.blockOutgoing.setIBlock((byte)0, (byte)0, this.numSeq, bl, byArray, n, n2);
                boolean bl3 = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!bl3) {
                    this.notifyPowerDown();
                }
                this.numSeqTx = this.numSeq;
                this.numSeq = !this.numSeq;
                byte by = this.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        if (!bl) {
                            throw new T1Exception(-124);
                        }
                        boolean bl4 = this.blockIncoming.getSequence();
                        if (bl4 != this.numSeqRcv) {
                            this.numSeqRcv = bl4;
                            this.nextIBlock = this.blockIncoming;
                            bl2 = false;
                            this.lastBlockFlag = false;
                            continue block7;
                        }
                        this.numSeq = !this.numSeq;
                        bl2 = true;
                        continue block7;
                    }
                    case -128: {
                        boolean bl4 = this.blockIncoming.getSequence();
                        if (bl) {
                            if (bl4 != this.numSeqTx) {
                                throw new T1Exception(-126);
                            }
                            this.numSeq = !this.numSeq;
                            bl2 = true;
                            continue block7;
                        }
                        if (bl4 != this.numSeqTx) {
                            bl2 = false;
                            continue block7;
                        }
                        this.numSeq = !this.numSeq;
                        bl2 = true;
                        continue block7;
                    }
                    case -64: {
                        boolean[] blArray = new boolean[]{bl2};
                        short s = this.t1ReplySBlock(blArray);
                        bl2 = blArray[0];
                        if (s == 0) continue block7;
                        return s;
                    }
                }
                throw new T1Exception(-126);
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public short t1RcvBlock(byte[] byArray, short[] sArray, short s, short s2) throws T1Exception {
        try {
            if (this.nextIBlock != null) {
                this.placeDataInBuffer(byArray, sArray, s, s2);
            } else {
                boolean bl = true;
                block12: while (bl) {
                    boolean bl2;
                    byte by;
                    boolean bl3;
                    if (this.recvFirstBlock) {
                        bl3 = this.cad.receiveBlock(this.blockIncoming);
                        if (!bl3) {
                            this.notifyPowerDown();
                        }
                        this.recvFirstBlock = false;
                        by = this.blockIncoming.getBlockType();
                        switch (by) {
                            case 0: {
                                bl2 = this.blockIncoming.getSequence();
                                if (bl2 != this.numSeqRcv) {
                                    this.numSeqRcv = bl2;
                                    this.nextIBlock = this.blockIncoming;
                                    this.nextBlockDataOffset = 0;
                                    bl = false;
                                    break;
                                }
                                bl = true;
                                break;
                            }
                            case -128: {
                                throw new T1Exception(-126);
                            }
                            case -64: {
                                throw new T1Exception(-126);
                            }
                            default: {
                                throw new T1Exception(-126);
                            }
                        }
                        continue;
                    }
                    this.blockOutgoing.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
                    bl3 = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                    if (!bl3) {
                        this.notifyPowerDown();
                    }
                    by = this.blockIncoming.getBlockType();
                    switch (by) {
                        case 0: {
                            bl2 = this.blockIncoming.getSequence();
                            if (bl2 != this.numSeqRcv) {
                                this.numSeqRcv = bl2;
                                this.nextIBlock = this.blockIncoming;
                                this.nextBlockDataOffset = 0;
                                bl = false;
                                continue block12;
                            }
                            bl = true;
                            continue block12;
                        }
                        case -128: {
                            bl = true;
                            continue block12;
                        }
                        case -64: {
                            boolean[] blArray = new boolean[]{bl};
                            short s3 = this.t1ReplySBlock(blArray);
                            bl = blArray[0];
                            if (s3 == 0) continue block12;
                            return s3;
                        }
                    }
                    throw new T1Exception(-126);
                }
                this.placeDataInBuffer(byArray, sArray, s, s2);
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public boolean t1Abort() throws T1Exception {
        try {
            boolean bl = true;
            block7: while (bl) {
                this.blockOutgoing.setSBlock((byte)0, (byte)0, -62, 0);
                boolean bl2 = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!bl2) {
                    this.notifyPowerDown();
                }
                byte by = this.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean bl3 = this.blockIncoming.getSequence();
                        if (bl3 != this.numSeqTx) {
                            bl = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte by2 = this.blockIncoming.getSBlockType();
                        if (by2 != -30) {
                            throw new T1Exception(-126);
                        }
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public boolean t1Wait() throws T1Exception {
        try {
            boolean bl = true;
            block7: while (bl) {
                this.blockOutgoing.setSBlock((byte)0, (byte)0, -61, 0);
                boolean bl2 = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!bl2) {
                    this.notifyPowerDown();
                }
                byte by = this.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean bl3 = this.blockIncoming.getSequence();
                        if (bl3 != this.numSeqTx) {
                            bl = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte by2 = this.blockIncoming.getSBlockType();
                        if (by2 != -29) {
                            throw new T1Exception(-126);
                        }
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public byte t1GetNAD() {
        return 0;
    }

    public short t1GetIFSC() {
        return (short)this.sizeIFSC;
    }

    public short t1GetIFSD() {
        return (short)this.sizeIFSD;
    }

    public boolean t1LastBlockReceived() {
        return this.lastBlockFlag;
    }

    public void sendATR(byte[] byArray) throws IOException, T1Exception {
        while (!this.cad.receivePowerUp()) {
        }
        this.powerUp();
        this.cad.sendATR(byArray);
        this.serverState = 2;
    }

    private void powerUp() {
        this.serverState = 1;
    }

    private void powerDown() {
        this.serverState = 0;
    }
}

