/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.openide.filesystems.FileSystem;

public final class ProviderPropertyType<T> {
    public static final ProviderPropertyType<String> ExecLogPropertyType = new ProviderPropertyType("exec-log-file", PropertyKind.MakeLogFile);
    public static final ProviderPropertyType<String> MakeLogPropertyType = new ProviderPropertyType("make-log-file", PropertyKind.MakeLogFile);
    public static final ProviderPropertyType<FileSystem> LogFileSystemPropertyType = new ProviderPropertyType("log-filesystem", PropertyKind.ArtifactFileSystem);
    public static final ProviderPropertyType<String> RestrictSourceRootPropertyType = new ProviderPropertyType("restrict_source_root", PropertyKind.String);
    public static final ProviderPropertyType<String> RestrictCompileRootPropertyType = new ProviderPropertyType("restrict_compile_root", PropertyKind.String);
    public static final ProviderPropertyType<String> ExecutablePropertyType = new ProviderPropertyType("executable", PropertyKind.BinaryFile);
    public static final ProviderPropertyType<FileSystem> BinaryFileSystemPropertyType = new ProviderPropertyType("binary-filesystem", PropertyKind.ArtifactFileSystem);
    public static final ProviderPropertyType<String[]> LibrariesPropertyType = new ProviderPropertyType("libraries", PropertyKind.BinaryFiles);
    public static final ProviderPropertyType<Boolean> FindMainPropertyType = new ProviderPropertyType("find_main", PropertyKind.Boolean);
    public static final ProviderPropertyType<String> ExecutableFolderPropertyType = new ProviderPropertyType("folder", PropertyKind.Folder);
    public static final ProviderPropertyType<String> ModelFolderPropertyType = new ProviderPropertyType("model-folder", PropertyKind.Folder);
    public static final ProviderPropertyType<Boolean> PreferLocalFilesPropertyType = new ProviderPropertyType("prefer-local", PropertyKind.Boolean);
    private final String key;
    private final PropertyKind kind;

    ProviderPropertyType(String key, PropertyKind kind) {
        this.key = key;
        this.kind = kind;
    }

    public String key() {
        return this.key;
    }

    public PropertyKind kind() {
        return this.kind;
    }

    public T getProperty(DiscoveryProvider provider) {
        return (T)provider.getProperty(this.key);
    }

    public void setProperty(DiscoveryProvider provider, T value) {
        provider.getProperty(this.key).setValue(value);
    }

    public String toString() {
        return this.key + "[" + (Object)((Object)this.kind) + "]";
    }

    public static enum PropertyKind {
        BinaryFile,
        ArtifactFileSystem,
        BinaryFiles,
        SourceFile,
        MakeLogFile,
        Folder,
        Folders,
        String,
        Boolean,
        Object;

    }
}

