/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.cnd.repository.impl.spi.FSConverter;
import org.netbeans.modules.cnd.repository.impl.spi.FilePathConverter;
import org.netbeans.modules.cnd.repository.impl.spi.LayerConvertersProvider;
import org.netbeans.modules.cnd.repository.impl.spi.UnitsConverter;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.storage.data.UTF;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;

public final class RepositoryDataInputStream
extends DataInputStream
implements RepositoryDataInput {
    private final LayerConvertersProvider layersConverterProvider;
    private static final UnitsConverter noConversionUnits = new UnitsConverter(){

        public int clientToLayer(int unitID) {
            return unitID;
        }

        public int layerToClient(int unitID) {
            return unitID;
        }
    };
    private static final FSConverter noConversionsFS = new FSConverter(){

        public FileSystem layerToClient(int readInt) {
            throw new InternalError();
        }

        public int clientToLayer(FileSystem fileSystem) {
            throw new InternalError();
        }
    };
    private static final FilePathConverter noConversionsFilePath = new FilePathConverter(){

        public CharSequence layerToClient(int fileIdx) {
            throw new InternalError();
        }

        public int clientToLayer(CharSequence filePath) {
            throw new InternalError();
        }
    };

    public RepositoryDataInputStream(InputStream in, LayerConvertersProvider layersConverterProvider) {
        super(in);
        this.layersConverterProvider = layersConverterProvider;
    }

    public RepositoryDataInputStream(DataInputStream in) {
        this(in, LayerConvertersProvider.getReadInstance((UnitsConverter)noConversionUnits, (FSConverter)noConversionsFS, (FilePathConverter)noConversionsFilePath));
    }

    public CharSequence readCharSequenceUTF() throws IOException {
        return UTF.readCharSequenceUTF(this);
    }

    public int readUnitId() throws IOException {
        int rawData = this.readInt();
        UnitsConverter unitIDConverter = this.layersConverterProvider.getReadUnitsConverter();
        int clientUnitID = unitIDConverter == null ? rawData : unitIDConverter.layerToClient(rawData);
        CndUtils.assertTrue((rawData > -1 ? 1 : 0) != 0, (String)"Impossible on disk unit id: ", (Object)rawData);
        return clientUnitID;
    }

    public FileSystem readFileSystem() throws IOException {
        int fsIdx;
        FSConverter fsConverter = this.layersConverterProvider.getReadFSConverter();
        FileSystem fs = fsConverter.layerToClient(fsIdx = this.readInt());
        if (fs == null) {
            throw new IOException("Can not restore file system from persistence", new NullPointerException());
        }
        return fs;
    }

    public CharSequence readFilePath() throws IOException {
        FilePathConverter pathConverter = this.layersConverterProvider.getReadFilePathConverter();
        return FilePathCache.getManager().getString(pathConverter.layerToClient(this.readInt()));
    }

    public CharSequence readFilePathForFileSystem(FileSystem fs) throws IOException {
        return this.readFilePath();
    }
}

