/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.indexing.impl.TextLayerProvider;
import org.netbeans.modules.cnd.indexing.spi.TextIndexLayer;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerListener;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.UnitsConverter;

public final class TextIndexStorage
implements LayerListener {
    private final List<TextIndexLayer> layers;
    private final LayeringSupport layeringSupport;
    private final TextLayerProvider textLayerProvider;

    TextIndexStorage(LayeringSupport layeringSupport) {
        this.layeringSupport = layeringSupport;
        this.textLayerProvider = new TextLayerProvider();
        this.layers = Collections.unmodifiableList(this.createLayers(layeringSupport.getLayerDescriptors()));
    }

    public void put(CndTextIndexKey indexKey, Set<CharSequence> ids) {
        for (TextIndexLayer layer : this.layers) {
            if (!layer.getDescriptor().isWritable()) continue;
            CndTextIndexKey layerKey = this.toLayerKey(layer.getDescriptor(), indexKey);
            layer.put(layerKey, ids);
        }
    }

    public List<CndTextIndexKey> query(CharSequence text) {
        ArrayList<CndTextIndexKey> result = new ArrayList<CndTextIndexKey>();
        for (TextIndexLayer layer : this.layers) {
            Collection<CndTextIndexKey> data = layer.query(text);
            if (data == null) continue;
            for (CndTextIndexKey key : data) {
                result.add(this.toClientKey(layer.getDescriptor(), key));
            }
        }
        return result;
    }

    public void remove(CndTextIndexKey indexKey) {
        for (TextIndexLayer layer : this.layers) {
            if (!layer.getDescriptor().isWritable()) continue;
            CndTextIndexKey layerKey = this.toLayerKey(layer.getDescriptor(), indexKey);
            layer.remove(layerKey);
        }
    }

    private List<TextIndexLayer> createLayers(List<LayerDescriptor> layerDescriptors) {
        ArrayList<TextIndexLayer> result = new ArrayList<TextIndexLayer>();
        for (LayerDescriptor layerDescriptor : layerDescriptors) {
            TextIndexLayer layer = this.textLayerProvider.getLayer(layerDescriptor);
            if (layer == null) continue;
            result.add(layer);
        }
        return result;
    }

    private CndTextIndexKey toLayerKey(LayerDescriptor layerDescriptor, CndTextIndexKey clientKey) {
        int clientUnitID = clientKey.getUnitId();
        UnitsConverter writeUnitsConverter = this.layeringSupport.getWriteUnitsConverter(layerDescriptor);
        return new CndTextIndexKey(writeUnitsConverter.clientToLayer(clientUnitID), clientKey.getFileNameIndex());
    }

    public boolean layerOpened(LayerDescriptor layerDescriptor) {
        for (TextIndexLayer layer : this.layers) {
            if (!layerDescriptor.equals((Object)layer.getDescriptor())) continue;
            return layer.isValid();
        }
        return true;
    }

    public boolean isValid() {
        boolean isOK = true;
        for (TextIndexLayer layer : this.layers) {
            isOK &= layer.isValid();
        }
        return isOK;
    }

    private CndTextIndexKey toClientKey(LayerDescriptor layerDescriptor, CndTextIndexKey layerKey) {
        int layerUnitID = layerKey.getUnitId();
        UnitsConverter readUnitsConverter = this.layeringSupport.getReadUnitsConverter(layerDescriptor);
        int clientUnitID = readUnitsConverter.layerToClient(layerUnitID);
        return new CndTextIndexKey(clientUnitID, layerKey.getFileNameIndex());
    }

    void shutdown() {
        for (TextIndexLayer layer : this.layers) {
            if (!layer.getDescriptor().isWritable()) continue;
            layer.shutdown();
        }
        this.textLayerProvider.shutdown();
    }

    void unitRemoved(int unitId) {
        if (unitId < 0) {
            return;
        }
        for (TextIndexLayer layer : this.layers) {
            if (!layer.getDescriptor().isWritable()) continue;
            layer.unitRemoved(unitId);
        }
    }
}

