/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileChangeListener;
import org.openide.util.Exceptions;

public class RemoteFileSystemManager {
    private static final RemoteFileSystemManager INSTANCE = new RemoteFileSystemManager();
    private final Object lock = new Object();
    private final Map<ExecutionEnvironment, SoftReference<RemoteFileSystem>> fileSystems = new HashMap<ExecutionEnvironment, SoftReference<RemoteFileSystem>>();
    private final List<FileChangeListener> globalListsners = new ArrayList<FileChangeListener>();

    public static RemoteFileSystemManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFileSystem(ExecutionEnvironment execEnv, boolean clearCache) {
        Object object = this.lock;
        synchronized (object) {
            SoftReference<RemoteFileSystem> ref = this.fileSystems.remove(execEnv);
            if (ref != null) {
                RemoteFileSystem fs = ref.get();
                if (fs != null) {
                    fs.dispose();
                }
                if (clearCache) {
                    RemoteFileSystemUtils.deleteRecursively(fs.getCache());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileSystem getFileSystem(ExecutionEnvironment execEnv) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileSystem result;
            SoftReference<RemoteFileSystem> ref = this.fileSystems.get(execEnv);
            RemoteFileSystem remoteFileSystem = result = ref == null ? null : ref.get();
            if (result == null) {
                try {
                    result = new RemoteFileSystem(execEnv);
                    this.fileSystems.put(execEnv, new SoftReference<RemoteFileSystem>(result));
                    for (FileChangeListener listener : this.globalListsners) {
                        result.addFileChangeListener(listener);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(FileChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.globalListsners.add(listener);
            for (SoftReference<RemoteFileSystem> ref : this.fileSystems.values()) {
                RemoteFileSystem fs = ref.get();
                if (fs == null) continue;
                fs.addFileChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(FileChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.globalListsners.add(listener);
            for (SoftReference<RemoteFileSystem> ref : this.fileSystems.values()) {
                RemoteFileSystem fs = ref.get();
                if (fs == null) continue;
                fs.removeFileChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RemoteFileSystem> getAllFileSystems() {
        ArrayList<RemoteFileSystem> res = new ArrayList<RemoteFileSystem>();
        Object object = this.lock;
        synchronized (object) {
            for (SoftReference<RemoteFileSystem> ref : this.fileSystems.values()) {
                RemoteFileSystem fs = ref.get();
                if (fs == null) continue;
                res.add(fs);
            }
        }
        return res;
    }
}

