/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateHandler;
import org.openide.util.Exceptions;

public class QtResourceCreateFromTemplateHandler
extends CreateFromTemplateHandler {
    protected boolean accept(FileObject orig) {
        String mimeType = orig.getMIMEType();
        return "text/qtresource+xml".equals(mimeType) || "text/qttranslation+xml".equals(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject createFromTemplate(FileObject template, FileObject folder, String name, Map<String, Object> parameters) throws IOException {
        String ext = FileUtil.getExtension((String)name);
        if (ext.length() != 0) {
            name = name.substring(0, name.length() - ext.length() - 1);
        }
        FileObject targetFile = folder.createData(name, ext);
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileObject)targetFile);
        String lsType = "\n";
        try {
            HostInfo.OSFamily oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getOSFamily();
            switch (oSFamily) {
                case WINDOWS: {
                    lsType = "\r\n";
                    break;
                }
                case MACOSX: {
                    lsType = "\r";
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
        Charset encoding = Charset.forName("UTF-8");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(template.getInputStream(), encoding));){
            FileLock lock = targetFile.lock();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(targetFile.getOutputStream(lock), encoding));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write(lsType);
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        return targetFile;
    }
}

