/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.utils.cache.TinyArrayMap;
import org.netbeans.modules.cnd.utils.cache.TinySingletonMap;
import org.netbeans.modules.cnd.utils.cache.TinyTwoValuesMap;

public final class TinyMaps {
    private static final Map<?, ?> NO_CONTENT = Collections.emptyMap();

    private TinyMaps() {
    }

    public static <K, V> Map<K, V> createMap(int initialCapacity) {
        switch (initialCapacity) {
            case 0: {
                Map<?, ?> out = NO_CONTENT;
                return out;
            }
            case 1: {
                return new TinySingletonMap();
            }
            case 2: {
                return new TinyTwoValuesMap();
            }
            case 3: 
            case 4: {
                return new TinyMap4();
            }
            case 5: 
            case 6: {
                return new TinyMap6();
            }
            case 7: 
            case 8: {
                return new TinyMap8();
            }
        }
        if (initialCapacity <= 16) {
            return new TinyMap16();
        }
        if (initialCapacity <= 32) {
            return new TinyHashMap32();
        }
        if (initialCapacity <= 64) {
            return new TinyHashMap64();
        }
        if (initialCapacity <= 128) {
            return new TinyHashMap128();
        }
        return new TinyHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> expandForNextKey(Map<K, V> orig, K newElem) {
        if (orig instanceof CompactMap) {
            return ((CompactMap)((Object)orig)).expandForNextKeyIfNeeded(newElem);
        }
        if (orig == NO_CONTENT) {
            return TinyMaps.createMap(1);
        }
        return orig;
    }

    static final class TinyHashMap<K, V>
    extends HashMap<K, V>
    implements CompactMap<K, V> {
        public TinyHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        TinyHashMap(Map<K, V> other) {
            super(other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            return this;
        }
    }

    static final class TinyHashMap128<K, V>
    extends HashMap<K, V>
    implements CompactMap<K, V> {
        public TinyHashMap128() {
            super(128);
        }

        TinyHashMap128(Map<K, V> other) {
            super(other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() < 128 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyHashMap(this);
        }
    }

    static final class TinyHashMap64<K, V>
    extends HashMap<K, V>
    implements CompactMap<K, V> {
        public TinyHashMap64() {
            super(64);
        }

        TinyHashMap64(Map<K, V> other) {
            super(other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() < 64 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyHashMap128(this);
        }
    }

    static final class TinyHashMap32<K, V>
    extends HashMap<K, V>
    implements CompactMap<K, V> {
        public TinyHashMap32() {
            super(32);
        }

        TinyHashMap32(Map<K, V> other) {
            super(other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() < 32 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyHashMap64(this);
        }
    }

    static final class TinyMap16<K, V>
    extends TinyArrayMap<K, V>
    implements CompactMap<K, V> {
        public TinyMap16() {
            super(16);
        }

        TinyMap16(TinyArrayMap<K, V> other) {
            super(other, 16);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() < 16 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyHashMap32(this);
        }
    }

    static final class TinyMap8<K, V>
    extends TinyArrayMap<K, V>
    implements CompactMap<K, V> {
        public TinyMap8() {
            super(8);
        }

        TinyMap8(TinyArrayMap<K, V> other) {
            super(other, 8);
        }

        TinyMap8(Map<K, V> other) {
            super(8, other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() <= 7 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyMap16(this);
        }
    }

    static final class TinyMap6<K, V>
    extends TinyArrayMap<K, V>
    implements CompactMap<K, V> {
        public TinyMap6() {
            super(6);
        }

        TinyMap6(TinyArrayMap<K, V> other) {
            super(other, 6);
        }

        TinyMap6(Map<K, V> other) {
            super(6, other);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() <= 5 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyMap8(this);
        }
    }

    static final class TinyMap4<K, V>
    extends TinyArrayMap<K, V>
    implements CompactMap<K, V> {
        public TinyMap4() {
            super(4);
        }

        TinyMap4(TinyTwoValuesMap<K, V> twoValues) {
            super(twoValues, 4);
        }

        TinyMap4(Map<K, V> twoValues) {
            super(4, twoValues);
        }

        @Override
        public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
            if (this.size() <= 3 || this.containsKey(newElem)) {
                return this;
            }
            return new TinyMap6(this);
        }
    }

    static interface CompactMap<K, V> {
        public Map<K, V> expandForNextKeyIfNeeded(K var1);
    }
}

