/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.ServiceProviderElement;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ServiceProviderSelectorPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.ServiceProvider;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ServiceProvidersTablePanel
extends DefaultTablePanel {
    private static final String[] columnName = new String[]{NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"MSG_ServiceProviders")};
    private ServiceProvidersTableModel tablemodel;
    private STSConfiguration stsConfig;
    private Map<String, ServiceProviderElement> addedProviders;
    private RemoveActionListener removeActionListener;
    private AddActionListener addActionListener;
    private EditActionListener editActionListener;
    private ConfigVersion cfgVersion;

    public ServiceProvidersTablePanel(ServiceProvidersTableModel tablemodel, STSConfiguration stsConfig, ConfigVersion cfgVersion) {
        super((AbstractTableModel)tablemodel);
        this.stsConfig = stsConfig;
        this.tablemodel = tablemodel;
        this.cfgVersion = cfgVersion;
        this.editButton.setVisible(true);
        this.addedProviders = new HashMap<String, ServiceProviderElement>();
        this.editActionListener = new EditActionListener();
        ActionListener editListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.editActionListener, (Object)this.editButton);
        this.editButton.addActionListener(editListener);
        this.addActionListener = new AddActionListener();
        ActionListener addListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addActionListener, (Object)this.addButton);
        this.addButton.addActionListener(addListener);
        this.removeActionListener = new RemoveActionListener();
        ActionListener removeListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeActionListener, (Object)this.removeButton);
        this.removeButton.addActionListener(removeListener);
    }

    public List getChildren() {
        return this.tablemodel.getChildren();
    }

    public void populateModel() {
        this.tablemodel.setData(this.stsConfig);
    }

    public static class ServiceProvidersTableModel
    extends AbstractTableModel {
        List<ServiceProviderElement> children;

        @Override
        public Object getValueAt(int row, int column) {
            return this.children.get(row);
        }

        @Override
        public int getRowCount() {
            if (this.children != null) {
                return this.children.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return columnName.length;
        }

        public void removeRow(int row) {
            this.children.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addRow(ServiceProviderElement value) {
            this.children.add(value);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public void setData(STSConfiguration stsConfig) {
            this.children = new ArrayList<ServiceProviderElement>();
            List<ServiceProvider> spList = ProprietarySecurityPolicyModelHelper.getSTSServiceProviders(stsConfig);
            if (spList != null && !spList.isEmpty()) {
                for (ServiceProvider sp : spList) {
                    String endpoint = sp.getEndpoint();
                    String certAlias = ProprietarySecurityPolicyModelHelper.getSPCertAlias(sp);
                    String tokenType = ProprietarySecurityPolicyModelHelper.getSPTokenType(sp);
                    String keyType = ProprietarySecurityPolicyModelHelper.getSPKeyType(sp);
                    ServiceProviderElement spe = new ServiceProviderElement(endpoint, certAlias, tokenType, keyType);
                    this.children.add(spe);
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int column) {
            return columnName[column];
        }

        public List getChildren() {
            return this.children;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ServiceProvidersTablePanel.this.getTable().getSelectedRow();
            if (row == -1) {
                return;
            }
            ServiceProviderElement speOld = (ServiceProviderElement)ServiceProvidersTablePanel.this.getTable().getValueAt(row, 0);
            ServiceProviderSelectorPanel spPanel = new ServiceProviderSelectorPanel(speOld.getEndpoint(), speOld.getCertAlias(), speOld.getTokenType(), speOld.getKeyType());
            DialogDescriptor dd = new DialogDescriptor((Object)spPanel, NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"LBL_SelectSProvider_Title"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(ServiceProviderSelectorPanel.class), null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(DialogDescriptor.OK_OPTION) && spPanel != null) {
                String url = spPanel.getSpUrl();
                String alias = spPanel.getCertAlias();
                String ttype = spPanel.getTokenType();
                String ktype = spPanel.getKeyType();
                ServiceProviderElement speNew = new ServiceProviderElement(url, alias, ttype, ktype);
                ServiceProvidersTablePanel.this.addedProviders.put(url, speNew);
                ServiceProvidersTablePanel.this.tablemodel.removeRow(row);
                ServiceProvidersTablePanel.this.tablemodel.addRow(speNew);
                ProprietarySecurityPolicyModelHelper.removeSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, speNew);
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, speNew, ServiceProvidersTablePanel.this.cfgVersion);
            }
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceProviderSelectorPanel spPanel = new ServiceProviderSelectorPanel(null, null, null, null);
            DialogDescriptor dd = new DialogDescriptor((Object)spPanel, NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"LBL_SelectSProvider_Title"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(ServiceProviderSelectorPanel.class), null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(DialogDescriptor.OK_OPTION) && spPanel != null) {
                String url = spPanel.getSpUrl();
                String alias = spPanel.getCertAlias();
                String ttype = spPanel.getTokenType();
                String ktype = spPanel.getKeyType();
                ServiceProviderElement spe = new ServiceProviderElement(url, alias, ttype, ktype);
                ServiceProvidersTablePanel.this.addedProviders.put(url, spe);
                ServiceProvidersTablePanel.this.tablemodel.addRow(spe);
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, spe, ServiceProvidersTablePanel.this.cfgVersion);
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ServiceProvidersTablePanel.this.getTable().getSelectedRow();
            if (row == -1) {
                return;
            }
            ServiceProviderElement spe = (ServiceProviderElement)ServiceProvidersTablePanel.this.getTable().getValueAt(row, 0);
            if (this.confirmDeletion(spe)) {
                ServiceProvidersTablePanel.this.addedProviders.remove(spe);
                ServiceProvidersTablePanel.this.tablemodel.removeRow(row);
                ProprietarySecurityPolicyModelHelper.removeSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, spe);
            }
        }

        private boolean confirmDeletion(ServiceProviderElement spe) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"MSG_ServiceProviderConfirmDelete", (Object)spe.getEndpoint()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

