/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.design.ConfigRunnable;
import org.netbeans.modules.websvc.wsitconf.design.WsitServiceChangeListener;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SecurityConfiguration
implements WSConfiguration {
    private Service service;
    private DataObject implementationFile;
    private Project project;
    private ServiceModel serviceModel;
    private ServiceChangeListener scl;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Binding binding;
    private ComponentListener cl;
    private boolean clAdded = false;
    private PropertyChangeListener configCreationListener = null;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();

    public SecurityConfiguration(final Service service, final FileObject implementationFile) {
        try {
            this.service = service;
            this.implementationFile = DataObject.find((FileObject)implementationFile);
            this.project = FileOwnerQuery.getOwner((FileObject)implementationFile);
            this.serviceModel = ServiceModel.getServiceModel((FileObject)implementationFile);
            this.addServiceChangeListener();
            this.cl = new ComponentListener(){

                private void update() {
                    boolean enabled = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding);
                    for (PropertyChangeListener pcl : SecurityConfiguration.this.listeners) {
                        PropertyChangeEvent pce = new PropertyChangeEvent(SecurityConfiguration.this, "value", null, enabled);
                        pcl.propertyChange(pce);
                    }
                }

                public void valueChanged(ComponentEvent evt) {
                    this.update();
                }

                public void childrenAdded(ComponentEvent evt) {
                    this.update();
                }

                public void childrenDeleted(ComponentEvent evt) {
                    this.update();
                }
            };
            this.binding = WSITModelSupport.getBinding(service, implementationFile, this.project, false, this.createdFiles);
            if (this.binding != null) {
                this.addCListener(this.binding);
            } else {
                this.configCreationListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SecurityConfiguration.this.binding = WSITModelSupport.getBinding(service, implementationFile, SecurityConfiguration.this.project, false, SecurityConfiguration.this.createdFiles);
                        SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                        SecurityConfiguration.this.cl.valueChanged(null);
                    }
                };
                DesignerListenerProvider.registerListener(this.configCreationListener);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Component getComponent() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(SecurityConfiguration.class, (String)"DesignConfigPanel.Security");
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/wsitconf/resources/designer-security.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SecurityConfiguration.class, (String)"DesignConfigPanel.Security");
    }

    private void addServiceChangeListener() {
        if (this.scl == null) {
            this.scl = new WsitServiceChangeListener(this.service, this.implementationFile, this.project);
        }
        if (this.scl != null && this.serviceModel != null) {
            this.serviceModel.addServiceChangeListener(this.scl);
        }
    }

    private synchronized void addCListener(Binding binding) {
        if (!this.clAdded && binding != null) {
            binding.getModel().addComponentListener(this.cl);
            this.clAdded = true;
        }
    }

    public boolean isSet() {
        boolean set = false;
        this.binding = WSITModelSupport.getBinding(this.service, this.implementationFile.getPrimaryFile(), this.project, false, null);
        this.addCListener(this.binding);
        if (this.binding != null) {
            set = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        }
        return set;
    }

    public void set() {
        this.switchIt(true);
    }

    public void unset() {
        this.switchIt(false);
    }

    private void switchIt(final boolean enable) {
        final ConfigRunnable r = new ConfigRunnable();
        SwingUtilities.invokeLater(r);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (enable) {
                        SecurityConfiguration.this.binding = WSITModelSupport.getBinding(SecurityConfiguration.this.service, SecurityConfiguration.this.implementationFile.getPrimaryFile(), SecurityConfiguration.this.project, true, null);
                        if (SecurityConfiguration.this.binding == null) {
                            return;
                        }
                        SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                        if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding)) {
                            SecurityProfile secProf = SecurityProfileRegistry.getDefault().getProfile(ComboConstants.PROF_MUTUALCERT);
                            secProf.profileSelected((WSDLComponent)SecurityConfiguration.this.binding, true, ConfigVersion.getDefault());
                            if (!RMModelHelper.getInstance(ConfigVersion.getDefault()).isRMEnabled((WSDLComponent)SecurityConfiguration.this.binding) && secProf instanceof SecureConversationFeature) {
                                ((SecureConversationFeature)((Object)secProf)).enableSecureConversation((WSDLComponent)SecurityConfiguration.this.binding, true);
                            }
                            DefaultSettings.fillDefaults(SecurityConfiguration.this.project, false, true);
                            ProfilesModelHelper.setServiceDefaults(ComboConstants.PROF_MUTUALCERT, SecurityConfiguration.this.binding, SecurityConfiguration.this.project);
                            WSITModelSupport.save((WSDLComponent)SecurityConfiguration.this.binding);
                        }
                    } else {
                        if (SecurityConfiguration.this.binding == null) {
                            return;
                        }
                        if (SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)SecurityConfiguration.this.binding)) {
                            SecurityConfiguration.this.addCListener(SecurityConfiguration.this.binding);
                            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)SecurityConfiguration.this.binding)).disableSecurity((WSDLComponent)SecurityConfiguration.this.binding, true);
                            WSITModelSupport.save((WSDLComponent)SecurityConfiguration.this.binding);
                        }
                    }
                }
                finally {
                    r.stop();
                }
            }
        });
    }

    public void registerListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void finalize() {
        if (this.scl != null && this.serviceModel != null) {
            this.serviceModel.removeServiceChangeListener(this.scl);
        }
        if (this.binding != null && this.clAdded) {
            this.binding.getModel().removeComponentListener(this.cl);
        }
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (this.implementationFile == null || !this.implementationFile.isValid()) {
            return false;
        }
        Node n = this.implementationFile.getNodeDelegate();
        JaxWsModel model = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        enabled = !SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(n, model);
        return enabled;
    }
}

