/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.api;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class WSITConfigProvider {
    private static final Logger logger = Logger.getLogger(WSITEditor.class.getName());
    private static WSITConfigProvider instance;

    private WSITConfigProvider() {
    }

    public static synchronized WSITConfigProvider getDefault() {
        if (instance == null) {
            instance = new WSITConfigProvider();
        }
        return instance;
    }

    public final JComponent getWSITServiceConfig(WSDLModel wsdlModel, UndoManager undoManager, Collection<Binding> bindings, Node node) {
        ServiceTopComponent stc = new ServiceTopComponent(wsdlModel, undoManager, bindings, node);
        return stc;
    }

    public final JComponent getWSITClientConfig(org.netbeans.modules.xml.wsdl.model.Service service, WSDLModel clientModel, WSDLModel serviceModel, Node node) {
        if (clientModel == null) {
            throw new IllegalArgumentException("Client model cannot be null! " + Thread.getAllStackTraces());
        }
        ClientTopComponent ctc = new ClientTopComponent(service, clientModel, serviceModel, node);
        return ctc;
    }

    public final boolean isWsitSecurityEnabled(Node node, JaxWsModel jaxWsModel) {
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        Project p = null;
        if (jaxWsModel != null) {
            p = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (p != null) {
            try {
                WSDLModel wsdlModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wsdlModel != null) {
                    if (client != null) {
                        JAXWSClientSupport wscs = JAXWSClientSupport.getJaxWsClientSupport((FileObject)p.getProjectDirectory());
                        if (wscs != null) {
                            WSDLModel serviceWsdlModel = WSITModelSupport.getServiceModelForClient(wscs, client);
                            Collection bindings = serviceWsdlModel.getDefinitions().getBindings();
                            for (Binding b : bindings) {
                                if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)b)) continue;
                                return true;
                            }
                        }
                    } else if (service != null) {
                        Collection bindings = wsdlModel.getDefinitions().getBindings();
                        for (Binding b : bindings) {
                            if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)b)) continue;
                            return true;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        return false;
    }

    public final boolean isWsitEnabled(Node node, JaxWsModel jaxWsModel) {
        Project p = null;
        if (jaxWsModel != null) {
            p = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (p != null) {
            try {
                WSDLModel wsdlModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wsdlModel != null) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSStackVersion getHighestWSStackVersion(Project project) {
        WSStack wsStack;
        J2eePlatform platform = ServerUtils.getJ2eePlatform(project);
        WSStackVersion version = null;
        WSStack wSStack = wsStack = platform == null ? null : JaxWsStackSupport.getJaxWsStack((J2eePlatform)platform);
        if (wsStack != null) {
            version = wsStack.getVersion();
        }
        InputStream is = null;
        BufferedReader r = null;
        try {
            SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
            FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/version.properties");
            if (wsimportFO != null && wsimportFO.isValid()) {
                is = wsimportFO.getInputStream();
                r = new BufferedReader(new InputStreamReader(is));
                String ln = null;
                String ver = null;
                while ((ln = r.readLine()) != null) {
                    String line = ln.trim();
                    if (!line.startsWith("major-version=")) continue;
                    ver = line.substring(14);
                    break;
                }
                WSStackVersion projectVersion = WSStackFactory.createWSStackVersion(ver);
                if (version == null) {
                    version = projectVersion;
                } else if (projectVersion.compareTo(version) > 0) {
                    version = projectVersion;
                }
            }
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return version;
    }
}

