/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.MakeProjectImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ComponentType;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ConfigurationDescriptorProvider {
    public static final boolean VCS_WRITE = true;
    public static final String PROP_CONFIGURATIONS_LOADED = "loadedConfigurations";
    public static final String USG_PROJECT_CONFIG_CND = "USG_PROJECT_CONFIG_CND";
    public static final String USG_PROJECT_OPEN_CND = "USG_PROJECT_OPEN_CND";
    public static final String USG_PROJECT_CREATE_CND = "USG_PROJECT_CREATE_CND";
    private static final String USG_CND_PROJECT_ACTION = "USG_CND_PROJECT_ACTION";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final RequestProcessor RP = new RequestProcessor("Configuration Updater", 1);
    private final FileObject projectDirectory;
    private final Project project;
    private final Object readLock = new Object();
    private final AtomicBoolean isOpened = new AtomicBoolean();
    private final FileChangeListener configFilesListener = new ConfigurationXMLChangeListener();
    private final List<FileObject> trackedConfigFiles = new ArrayList<FileObject>(2);
    private final MakeConfigurationDescriptor projectDescriptor;
    private boolean hasTried;
    private String relativeOffset;
    private boolean needReload = true;
    private volatile Interrupter interrupter;

    protected ConfigurationDescriptorProvider(Project project, FileObject projectDirectory) {
        this.project = project;
        this.projectDirectory = projectDirectory;
        this.isOpened.set(true);
        this.projectDescriptor = new MakeConfigurationDescriptor(project, projectDirectory, projectDirectory);
    }

    public void setRelativeOffset(String relativeOffset) {
        this.relativeOffset = relativeOffset;
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.getConfigurationDescriptor(false);
    }

    protected MakeConfigurationDescriptor getConfigurationDescriptorImpl() {
        return this.projectDescriptor;
    }

    protected abstract void fireConfigurationDescriptorLoaded();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBeLoaded() {
        AtomicBoolean atomicBoolean = this.isOpened;
        synchronized (atomicBoolean) {
            return this.needReload && !this.hasTried;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MakeConfigurationDescriptor getConfigurationDescriptor(boolean reload) {
        Object object = this.isOpened;
        synchronized (object) {
            if (!this.isOpened.get()) {
                return null;
            }
        }
        if (this.shouldBeLoaded()) {
            object = this.readLock;
            synchronized (object) {
                if (this.shouldBeLoaded()) {
                    LOGGER.log(Level.FINE, "Start reading project descriptor for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                    AtomicBoolean atomicBoolean = this.isOpened;
                    synchronized (atomicBoolean) {
                        this.needReload = false;
                    }
                    ConfigurationXMLReader reader = new ConfigurationXMLReader(this.project, this.projectDirectory);
                    try {
                        SnapShot delta = this.startModifications();
                        if (reload) {
                            this.projectDescriptor.clean();
                        }
                        reader.read(this.projectDescriptor, this.relativeOffset, this.interrupter);
                        this.projectDescriptor.waitInitTask();
                        this.endModifications(delta, true, LOGGER);
                        RP.post(this::fireConfigurationDescriptorLoaded);
                        LOGGER.log(Level.FINE, "End of reading project descriptor for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                    }
                    catch (IOException x) {
                        x.printStackTrace(System.err);
                    }
                    AtomicBoolean atomicBoolean2 = this.isOpened;
                    synchronized (atomicBoolean2) {
                        this.hasTried = true;
                    }
                }
            }
        }
        this.projectDescriptor.waitInitTask();
        return this.projectDescriptor;
    }

    public SnapShot startModifications() {
        return new Delta(this.projectDescriptor);
    }

    public void endModifications(SnapShot snapShot, boolean sendChangeEvent, Logger logger) {
        if (snapShot instanceof Delta) {
            Delta delta = (Delta)snapShot;
            if (sendChangeEvent) {
                delta.computeDelta(this.projectDescriptor);
                if (logger != null) {
                    delta.printStatistic(logger);
                }
                this.projectDescriptor.checkForChangedItems(delta);
            }
        }
    }

    public boolean gotDescriptor() {
        return this.isOpened.get() && this.projectDescriptor.getState() != ConfigurationDescriptor.State.READING;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet auxObjectProviders = new HashSet();
        Collection collection = Lookup.getDefault().lookupAll(ConfigurationAuxObjectProvider.class);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            auxObjectProviders.add(iterator.next());
        }
        return auxObjectProviders.toArray(new ConfigurationAuxObjectProvider[auxObjectProviders.size()]);
    }

    public static void recordMetrics(String msg, MakeConfigurationDescriptor descr) {
        ConfigurationDescriptorProvider.recordMetricsImpl(msg, null, descr, null);
    }

    public static void recordCreatedProjectMetrics(MakeConfiguration[] confs) {
        if (confs != null && confs.length > 0) {
            ConfigurationDescriptorProvider.recordMetricsImpl(USG_PROJECT_CREATE_CND, confs[0], null, null);
        }
    }

    public static void recordActionMetrics(String action, MakeConfigurationDescriptor descr) {
        ConfigurationDescriptorProvider.recordMetricsImpl(USG_CND_PROJECT_ACTION, null, descr, action);
    }

    private static void recordMetricsImpl(String msg, MakeConfiguration makeConfiguration, MakeConfigurationDescriptor descr, String action) {
        String family;
        String flavor;
        String[] families;
        CompilerSet compilerSet;
        String host;
        String type;
        if (CndUtils.isUnitTestMode()) {
            return;
        }
        if (descr == null && makeConfiguration == null) {
            return;
        }
        Item[] projectItems = null;
        if (makeConfiguration == null) {
            if (descr.getConfs() == null || descr.getConfs().getActive() == null) {
                return;
            }
            if (makeConfiguration == null) {
                makeConfiguration = descr.getActiveConfiguration();
            }
            projectItems = descr.getProjectItems();
            if (!(USG_PROJECT_CREATE_CND.equals(msg) || projectItems != null && projectItems.length != 0)) {
                return;
            }
        }
        switch (makeConfiguration.getConfigurationType().getValue()) {
            case 0: {
                type = "MAKEFILE";
                break;
            }
            case 1: {
                type = "APPLICATION";
                break;
            }
            case 7: {
                type = "DB_APPLICATION";
                break;
            }
            case 2: {
                type = "DYNAMIC_LIB";
                break;
            }
            case 3: {
                type = "STATIC_LIB";
                break;
            }
            case 4: {
                type = "QT_APPLICATION";
                break;
            }
            case 5: {
                type = "QT_DYNAMIC_LIB";
                break;
            }
            case 6: {
                type = "QT_STATIC_LIB";
                break;
            }
            default: {
                type = "UNKNOWN";
            }
        }
        if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
            host = "LOCAL";
            compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        } else {
            host = "REMOTE";
            compilerSet = null;
        }
        if (compilerSet != null) {
            families = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
            flavor = compilerSet.getCompilerFlavor().getToolchainDescriptor().getName();
        } else {
            families = new String[]{};
            if (makeConfiguration.getCompilerSet() != null) {
                families = new String[]{makeConfiguration.getCompilerSet().getName()};
            }
            flavor = makeConfiguration.getCompilerSet().getFlavor();
        }
        if (families.length == 0) {
            family = flavor;
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < families.length; ++i) {
                if (families[i] == null) continue;
                buffer.append(families[i]);
                if (i >= families.length - 1) continue;
                buffer.append(",");
            }
            family = buffer.toString();
        }
        int platformID = makeConfiguration.getDevelopmentHost().getBuildPlatform();
        String platform = Platforms.getPlatform(platformID) != null ? Platforms.getPlatform(platformID).getName() : "UNKNOWN_PLATFORM";
        String ideType = ComponentType.OSS_IDE.getTag();
        if (USG_PROJECT_CREATE_CND.equals(msg)) {
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{type, flavor, family, host, platform, "USER_PROJECT", ideType});
        } else if (USG_CND_PROJECT_ACTION.equals(msg)) {
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{action, type, flavor, family, host, platform, ideType});
        } else if (projectItems != null) {
            makeConfiguration.reCountLanguages(descr);
            int size = 0;
            int allItems = projectItems.length;
            boolean cLang = false;
            boolean ccLang = false;
            boolean fLang = false;
            boolean aLang = false;
            block17: for (Item item : projectItems) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue()) continue;
                ++size;
                switch (itemConfiguration.getTool()) {
                    case CCompiler: {
                        cLang = true;
                        continue block17;
                    }
                    case CCCompiler: {
                        ccLang = true;
                        continue block17;
                    }
                    case FortranCompiler: {
                        fLang = true;
                        continue block17;
                    }
                    case Assembler: {
                        aLang = true;
                    }
                }
            }
            String ccUsage = ccLang ? "USE_CPP" : "NO_CPP";
            String cUsage = cLang ? "USE_C" : "NO_C";
            String fUsage = fLang ? "USE_FORTRAN" : "NO_FORTRAN";
            String aUsage = aLang ? "USE_ASM" : "NO_ASM";
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{type, flavor, family, host, platform, ConfigurationDescriptorProvider.toSizeString(allItems), ConfigurationDescriptorProvider.toSizeString(size), ccUsage, cUsage, fUsage, aUsage, ideType});
        }
    }

    private static String toSizeString(int size) {
        String strSize = size < 25 ? "25" : (size < 100 ? "100" : (size < 500 ? "500" : (size < 1000 ? "1000" : (size < 2000 ? "2000" : (size < 5000 ? "5000" : (size < 10000 ? "10000" : (size < 20000 ? "20000" : (size < 50000 ? "50000" : "99999"))))))));
        return strSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        this.detachConfigurationFilesListener();
        MakeConfigurationDescriptor descr = this.getConfigurationDescriptor();
        if (descr != null) {
            descr.closed();
        }
        AtomicBoolean atomicBoolean = this.isOpened;
        synchronized (atomicBoolean) {
            this.isOpened.set(false);
            this.projectDescriptor.clean();
            this.hasTried = false;
            this.relativeOffset = null;
            this.needReload = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void opening(Interrupter interrupter) {
        AtomicBoolean atomicBoolean = this.isOpened;
        synchronized (atomicBoolean) {
            this.isOpened.set(true);
            this.needReload = true;
            this.hasTried = false;
            this.projectDescriptor.setState(ConfigurationDescriptor.State.READING);
            this.interrupter = interrupter;
        }
    }

    public void opened() {
        MakeConfigurationDescriptor descr = this.getConfigurationDescriptor(true);
        if (descr != null) {
            descr.opened(this.interrupter);
        }
        if (this.interrupter != null && this.interrupter.cancelled()) {
            return;
        }
        this.attachConfigurationFilesListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachConfigurationFilesListener() {
        List<FileObject> list = this.trackedConfigFiles;
        synchronized (list) {
            this.initTrackedConfigFiles();
            if (this.trackedConfigFiles.size() == 2) {
                for (FileObject fileObject : this.trackedConfigFiles) {
                    fileObject.addFileChangeListener(this.configFilesListener);
                    LOGGER.log(Level.FINE, "attached config file {2} listener for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory, System.identityHashCode(this), fileObject});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachConfigurationFilesListener() {
        List<FileObject> list = this.trackedConfigFiles;
        synchronized (list) {
            for (FileObject fileObject : this.trackedConfigFiles) {
                fileObject.removeFileChangeListener(this.configFilesListener);
                LOGGER.log(Level.FINE, "detached config file {2} listener for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory, System.identityHashCode(this), fileObject});
            }
        }
    }

    private void initTrackedConfigFiles() {
        assert (Thread.holdsLock(this.trackedConfigFiles));
        if (this.trackedConfigFiles.size() != 2) {
            LOGGER.log(Level.FINE, "(re)initializing config files {2} for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory, System.identityHashCode(this), this.trackedConfigFiles});
            this.trackedConfigFiles.clear();
            boolean first = true;
            for (String path : new String[]{"nbproject/configurations.xml", "nbproject/private/configurations.xml"}) {
                FileObject fo = this.projectDirectory.getFileObject(path);
                if (fo != null) {
                    this.trackedConfigFiles.add(fo);
                } else if (first) {
                    CndUtils.threadsDump();
                    new Exception("Attempt to read project before creation. Not found file " + this.projectDirectory.getPath() + "/" + path).printStackTrace(System.err);
                }
                first = false;
            }
            LOGGER.log(Level.FINE, "initialized config files {2} for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory, System.identityHashCode(this), this.trackedConfigFiles});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConfiguration() {
        AtomicBoolean writeLock = MakeConfigurationDescriptor.getWriteLock(this.project);
        if (writeLock.get()) {
            return;
        }
        if (this.projectDescriptor.isModified()) {
            if (this.interrupter.cancelled()) {
                return;
            }
            if (this.project instanceof MakeProjectImpl && ((MakeProjectImpl)this.project).isDeleted()) {
                return;
            }
            String title = NbBundle.getMessage(ConfigurationDescriptorProvider.class, (String)"MakeConfigurationDescriptor.UpdateConfigurationTitle");
            String txt = NbBundle.getMessage(ConfigurationDescriptorProvider.class, (String)"MakeConfigurationDescriptor.UpdateConfigurationText", (Object)this.project.getProjectDirectory().getPath());
            String autoConfirm = NbBundle.getMessage(ConfigurationDescriptorProvider.class, (String)"MakeConfigurationDescriptor.UpdateConfigurationText.auto");
            if (CndUtils.isStandalone()) {
                System.err.print(txt);
                System.err.println(autoConfirm);
            } else {
                ConfirmSupport.AutoConfirm confirm = ConfirmSupport.getAutoConfirmFactory().create(title, txt, autoConfirm);
                if (confirm == null) {
                    return;
                }
            }
        }
        Object object = this.readLock;
        synchronized (object) {
            LOGGER.log(Level.FINE, "Mark to reload project descriptor MakeConfigurationDescriptor@{0} for project {1} in ConfigurationDescriptorProvider@{2}", new Object[]{System.identityHashCode(this.projectDescriptor), this.projectDirectory.getNameExt(), System.identityHashCode(this)});
            AtomicBoolean atomicBoolean = this.isOpened;
            synchronized (atomicBoolean) {
                if (this.isOpened.get()) {
                    this.needReload = true;
                    this.hasTried = false;
                }
            }
            RP.post(() -> this.getConfigurationDescriptor(true));
        }
    }

    public static final class Delta
    implements SnapShot {
        private final Map<String, Pair> oldState = new HashMap<String, Pair>();
        private final List<Item> included = new ArrayList<Item>();
        private final List<Item> added = new ArrayList<Item>();
        private final List<Item> excluded = new ArrayList<Item>();
        private final List<Item> deleted = new ArrayList<Item>();
        private final List<Item> changed = new ArrayList<Item>();
        private final List<Item> replaced = new ArrayList<Item>();

        private Delta(MakeConfigurationDescriptor oldDescriptor) {
            if (oldDescriptor != null) {
                for (Item item : oldDescriptor.getProjectItems()) {
                    this.oldState.put(item.getAbsolutePath(), new Pair(item, item.getCRC(), item.isExcluded()));
                }
            }
        }

        private void computeDelta(MakeConfigurationDescriptor newDescriptor) {
            Item[] newItems;
            HashSet oldSet = new HashSet();
            this.oldState.entrySet().forEach(entry -> oldSet.add(((Pair)entry.getValue()).item));
            for (Item item2 : newItems = newDescriptor.getProjectItems()) {
                Pair pair = this.oldState.get(item2.getAbsolutePath());
                if (pair == null) {
                    this.added.add(item2);
                    continue;
                }
                oldSet.remove(pair.item);
                if (item2.isExcluded() && pair.excluded) {
                    this.replaced.add(item2);
                    continue;
                }
                if (item2.isExcluded() && !pair.excluded) {
                    this.excluded.add(item2);
                    continue;
                }
                if (!item2.isExcluded() && pair.excluded) {
                    this.included.add(item2);
                    continue;
                }
                if (item2.getCRC() != pair.crc) {
                    this.changed.add(item2);
                    continue;
                }
                if (pair.item == item2) continue;
                this.replaced.add(item2);
            }
            oldSet.forEach(item -> this.deleted.add((Item)item));
            this.oldState.clear();
        }

        public void printStatistic(Logger logger) {
            if (logger.isLoggable(CndUtils.isUnitTestMode() ? Level.FINE : Level.INFO)) {
                logger.log(Level.INFO, "Configuration updated:\n\t{0} deleted items\n\t{1} added items\n\t{2} changed items", new Object[]{this.deleted.size() + this.excluded.size(), this.added.size() + this.included.size(), this.changed.size()});
            }
        }

        public boolean isEmpty() {
            return this.included.isEmpty() && this.added.isEmpty() && this.excluded.isEmpty() && this.deleted.isEmpty() && this.changed.isEmpty();
        }

        public List<Item> getIncluded() {
            return Collections.unmodifiableList(this.included);
        }

        public List<Item> getAdded() {
            return Collections.unmodifiableList(this.added);
        }

        public List<Item> getExcluded() {
            return Collections.unmodifiableList(this.excluded);
        }

        public List<Item> getDeleted() {
            return Collections.unmodifiableList(this.deleted);
        }

        public List<Item> getChanged() {
            return Collections.unmodifiableList(this.changed);
        }

        public List<Item> getReplaced() {
            return Collections.unmodifiableList(this.replaced);
        }

        private static final class Pair {
            final int crc;
            final boolean excluded;
            final Item item;

            private Pair(Item item, int crc, boolean excluded) {
                this.crc = crc;
                this.excluded = excluded;
                this.item = item;
            }
        }
    }

    public static interface SnapShot {
    }

    private class ConfigurationXMLChangeListener
    implements FileChangeListener {
        private ConfigurationXMLChangeListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            ConfigurationDescriptorProvider.this.resetConfiguration();
        }

        public void fileDataCreated(FileEvent fe) {
            ConfigurationDescriptorProvider.this.resetConfiguration();
        }

        public void fileChanged(FileEvent fe) {
            ConfigurationDescriptorProvider.this.resetConfiguration();
        }

        public void fileDeleted(FileEvent fe) {
            ConfigurationDescriptorProvider.this.resetConfiguration();
        }

        public void fileRenamed(FileRenameEvent fe) {
            ConfigurationDescriptorProvider.this.resetConfiguration();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

