/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.refactoring;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AppletXMLRefactoringSupport {
    protected Document doc;
    protected final DocumentBuilder docBuilder;
    private XPathFactory xpFactory = XPathFactory.newInstance();
    private XPath xPath = this.xpFactory.newXPath();
    private XPathExpression appletClassXPression;
    private XPathExpression appletAIDXPression;

    private AppletXMLRefactoringSupport(DocumentBuilderFactory factory, File file) throws SAXException, IOException {
        try {
            this.appletClassXPression = this.xPath.compile("/applet-app/applet/applet-class/text()");
            this.appletAIDXPression = this.xPath.compile("/applet-app/applet/applet-AID/text()");
        }
        catch (XPathExpressionException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        try {
            this.docBuilder = factory.newDocumentBuilder();
            this.doc = this.docBuilder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Internal error: failed to obtain DocumentBuilder instance.", e);
        }
    }

    public static AppletXMLRefactoringSupport fromFile(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            return new AppletXMLRefactoringSupport(factory, file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public NodeList getAppletClassElements() {
        try {
            return (NodeList)this.appletClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            return null;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean isAppletDefined(String appletAID) {
        try {
            XPathExpression xPression = this.xPath.compile("/applet-app/applet/applet-AID[text()='" + appletAID + "']");
            return (Boolean)xPression.evaluate(this.doc, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            return false;
        }
    }

    public void addAppletInfo(String appletAID, String className) {
        if (this.isAppletDefined(appletAID)) {
            throw new IllegalArgumentException("Servlet with name '" + appletAID + "' is already defined.");
        }
        this.addAppletElement(appletAID, className);
    }

    public void addAppletElement(String appletAID, String className) {
        Element servlet = this.doc.createElement("applet");
        Element sName = this.doc.createElement("applet-AID");
        sName.setTextContent(appletAID);
        Element sClass = this.doc.createElement("applet-class");
        sClass.setTextContent(className);
        servlet.appendChild(sClass);
        servlet.appendChild(sName);
        this.getAppletAppNode().appendChild(servlet);
    }

    public Node getAppletAppNode() {
        Element node = this.doc.getDocumentElement();
        if (node == null) {
            Element root = this.doc.createElement("applet-app");
            Attr attr = this.doc.createAttribute("version");
            attr.setNodeValue("3.0");
            this.doc.appendChild(root);
            return root;
        }
        if (node.getNodeName().equals("applet-app")) {
            return node;
        }
        return null;
    }

    public Collection<String> getAllAppletAIDs() {
        HashSet<String> names = new HashSet<String>();
        try {
            NodeList nodes = (NodeList)this.appletAIDXPression.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                names.add(nodes.item(i).getNodeValue());
            }
        }
        catch (XPathExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return names;
    }
}

