/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.DependenciesProvider;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ui.AddDependencyWizardIterator;
import org.netbeans.spi.actions.Single;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddDependencyAction
extends Single<JCProject> {
    public AddDependencyAction() {
        super(JCProject.class, NbBundle.getMessage(AddDependencyAction.class, (String)"ACTION_ADD_DEPENDENCY"), null);
    }

    protected void actionPerformed(JCProject target) {
        DependenciesProvider prov = (DependenciesProvider)target.getLookup().lookup(DependenciesProvider.class);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(AddDependencyAction.class, (String)"MSG_LOADING_DEPS"));
        WaitRunnable wr = new WaitRunnable(target, prov, handle);
        GuiUtils.showProgressDialogAndRun((ProgressHandle)handle, (Runnable)wr, (boolean)false);
    }

    protected boolean isEnabled(JCProject target) {
        return target.getLookup().lookup(DependenciesProvider.class) != null;
    }

    private static class R
    implements DependenciesProvider.Receiver,
    Runnable {
        private volatile ResolvedDependencies deps;
        private volatile boolean done;
        private final JCProject project;

        private R(JCProject project) {
            this.project = project;
        }

        @Override
        public void receive(ResolvedDependencies deps) {
            this.deps = deps;
            this.done = true;
            if (deps != null) {
                EventQueue.invokeLater(this);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public boolean failed(Throwable failure) {
            this.done = true;
            return false;
        }

        @Override
        public void run() {
            AddDependencyWizardIterator.show(this.deps, this.project);
            if (this.deps.isModified()) {
                try {
                    this.deps.save();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class WaitRunnable
    implements Runnable {
        private Cancellable c;
        private final DependenciesProvider prov;
        private final ProgressHandle handle;
        private final JCProject project;

        WaitRunnable(JCProject project, DependenciesProvider prov, ProgressHandle handle) {
            this.project = project;
            this.prov = prov;
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                this.handle.start();
                this.handle.switchToIndeterminate();
                try {
                    R r = new R(this.project);
                    this.c = this.prov.requestDependencies(r);
                    if (this.c == null) break block9;
                    Cancellable cancellable = this.c;
                    synchronized (cancellable) {
                        try {
                            while (!r.done) {
                                this.c.wait();
                            }
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                finally {
                    this.handle.finish();
                }
            }
        }
    }
}

