/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.Dependencies;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.Path;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DependenciesResolver {
    private final FileObject projDir;
    private final PropertyEvaluator eval;
    public static final Logger LOGGER = Logger.getLogger(DependenciesResolver.class.getName());

    public DependenciesResolver(FileObject projDir, PropertyEvaluator eval) {
        this.projDir = projDir;
        this.eval = eval;
    }

    public boolean isValid(Dependency dep) {
        boolean result = true;
        for (ArtifactKind a : dep.getKind().supportedArtifacts()) {
            File f;
            if (!a.mayBeNull() && !(result &= (f = this.resolveFile(dep.getPropertyName(a))) != null && f.exists())) break;
        }
        return result;
    }

    public Path resolveAntPath(String absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        File f = new File(absolutePath);
        File proj = FileUtil.toFile((FileObject)this.projDir);
        String relPath = null;
        int backup = 0;
        boolean ignoreCase = Utilities.isWindows();
        do {
            boolean isCommonParent;
            boolean bl = isCommonParent = ignoreCase ? f.getPath().toLowerCase().startsWith(proj.getPath().toLowerCase()) : f.getPath().startsWith(proj.getPath());
            if (isCommonParent) {
                relPath = f.getPath().substring(proj.getPath().length());
                for (int i = 0; i < backup; ++i) {
                    relPath = relPath.startsWith(File.separator) ? ".." + relPath : "../" + relPath;
                }
                break;
            }
            proj = proj.getParentFile();
            ++backup;
        } while (proj != null);
        if (relPath != null) {
            if (File.separatorChar != '/') {
                relPath = relPath.replace(File.separatorChar, '/');
            }
            return new Path(relPath, true);
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        if (fo == null) {
            return new Path(absolutePath.replace(File.separatorChar, '/'), false);
        }
        return new Path(fo.getPath(), false);
    }

    public FileObject resolveArtifact(Dependency dep, ArtifactKind artifact) {
        File file = this.resolveFile(dep, artifact);
        return file == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    public File resolveFile(Dependency dep, ArtifactKind kind) {
        File result = this.resolveFile(dep.getPropertyName(kind));
        try {
            return result == null ? null : result.getCanonicalFile();
        }
        catch (IOException ex) {
            IOException nue = new IOException("Exception canonicalizing " + result.getPath());
            nue.initCause(ex);
            Exceptions.printStackTrace((Throwable)nue);
            return result;
        }
    }

    private File resolveFile(String propName) {
        File result;
        String val = this.eval.getProperty(propName);
        if (val == null || "".equals(val)) {
            return null;
        }
        if (File.separatorChar != '/') {
            val = val.replace('/', File.separatorChar);
        }
        if (!(result = new File(FileUtil.toFile((FileObject)this.projDir), val)).exists()) {
            result = new File(val);
        }
        return result;
    }

    public File[] resolveClasspath(Dependencies deps, boolean pruneDuplicates, boolean fullClosure) {
        ArrayList<File> l = new ArrayList<File>();
        for (Dependency d : deps.all()) {
            FileObject origin = this.getArtifact(d, ArtifactKind.ORIGIN);
            if (d.getKind().isOriginAFolder()) {
                Project p = FileOwnerQuery.getOwner((FileObject)origin);
                if (p == null) continue;
                AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
                for (AntArtifact a : prov.getBuildArtifacts()) {
                    if (!"jar".equals(a.getType())) continue;
                    for (URI uri : a.getArtifactLocations()) {
                        try {
                            int ix;
                            File f = new File(uri.toURL().getFile()).getAbsoluteFile();
                            if (pruneDuplicates && (ix = l.indexOf(f)) >= 0) {
                                l.remove(ix);
                            }
                            l.add(f);
                        }
                        catch (MalformedURLException ex) {
                            Logger.getLogger(DependenciesResolver.class.getName()).log(Level.INFO, "Project at " + p.getProjectDirectory().getPath() + " returns " + "invalid URI for Ant Artifact " + a + ": " + uri);
                        }
                    }
                }
                if (!fullClosure) continue;
            }
            l.add(FileUtil.toFile((FileObject)origin));
        }
        return l.toArray(new File[l.size()]);
    }

    private FileObject resolveFileObject(String path) {
        FileObject fo = this.projDir.getFileObject(path);
        if (fo == null) {
            File f;
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
                if (Utilities.isUnix() && path.charAt(0) != File.separatorChar) {
                    path = File.separatorChar + path;
                }
            }
            if ((f = new File(path)).exists()) {
                fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            }
        }
        return fo;
    }

    FileObject getArtifact(Dependency dep, ArtifactKind artifact) {
        String prop = dep.getPropertyName(artifact);
        String val = this.eval.evaluate("{" + prop + "}");
        return val == null ? null : this.resolveFileObject(val);
    }

    public void save(JCProject project, ResolvedDependencies dependencies, Element cfgRoot) throws IOException {
        LOGGER.log(Level.FINER, "Save project metadata {0}", project.getProjectDirectory());
        if (!ProjectManager.mutex().isWriteAccess()) {
            throw new IllegalStateException("Not in ProjectManager.mutex().writeAccess()");
        }
        NodeList nls = cfgRoot.getElementsByTagNameNS("http://www.netbeans.org/ns/javacard-project/3", "dependencies");
        if (nls.getLength() == 0) {
            throw new IOException("<dependencies> section missing from project.xml");
        }
        if (nls.getLength() > 1) {
            throw new IOException("project.xml contains multiple <dependencies> sections in " + project.getProjectDirectory().getPath());
        }
        cfgRoot.removeChild(nls.item(0));
        Element nue = cfgRoot.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/javacard-project/3", "dependencies");
        AntProjectHelper helper = project.getAntProjectHelper();
        EditableProperties pubProps = helper.getProperties("nbproject/project.properties");
        EditableProperties privProps = helper.getProperties("nbproject/private/private.properties");
        boolean privChanged = false;
        boolean pubChanged = false;
        FileObject root = project.getProjectDirectory();
        List<? extends ResolvedDependency> l = dependencies.all();
        for (ResolvedDependency resolvedDependency : l) {
            Dependency dependency = resolvedDependency.getDependency();
            for (ArtifactKind kind : resolvedDependency.getModifiedArtifactKinds()) {
                String propName = dependency.getPropertyName(kind);
                String path = resolvedDependency.getPath(kind);
                if (path == null) {
                    privChanged |= privProps.remove((Object)propName) != null;
                    pubChanged |= pubProps.remove((Object)propName) != null;
                    continue;
                }
                File f = new File(path);
                FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
                String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)file);
                if (relPath == null) {
                    privProps.put(propName, file.getPath());
                    privChanged = true;
                    continue;
                }
                pubProps.put(propName, relPath);
                pubChanged = true;
            }
        }
        for (ResolvedDependency resolvedDependency : l) {
            Dependency dependency = resolvedDependency.getDependency();
            Element el = nue.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/javacard-project/3", "dependency");
            el.setAttribute("id", dependency.getID());
            el.setAttribute("kind", dependency.getKind().name());
            el.setAttribute("deployment", dependency.getDeploymentStrategy().name());
            LOGGER.log(Level.FINER, "Created element {0} for {1} ({2})", new Object[]{el, dependency, resolvedDependency});
            nue.appendChild(el);
        }
        cfgRoot.appendChild(nue);
        if (privChanged) {
            helper.putProperties("nbproject/private/private.properties", privProps);
        }
        if (pubChanged) {
            helper.putProperties("nbproject/project.properties", pubProps);
        }
        StringBuilder sb = new StringBuilder();
        for (ResolvedDependency resolvedDependency : dependencies.all()) {
            File f = resolvedDependency.resolveFile(ArtifactKind.ORIGIN);
            if (f == null) continue;
            if (resolvedDependency.getKind().isProjectDependency()) {
                AntArtifactProvider prov;
                Project p;
                FileObject fo = resolvedDependency.resolve(ArtifactKind.ORIGIN);
                if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null && (prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class)) != null) {
                    for (AntArtifact a : prov.getBuildArtifacts()) {
                        for (URI uri : a.getArtifactLocations()) {
                            File f1;
                            try {
                                f1 = new File(uri);
                            }
                            catch (IllegalArgumentException e) {
                                File proj = FileUtil.toFile((FileObject)p.getProjectDirectory());
                                f1 = new File(proj, uri.toString());
                            }
                            if (sb.length() > 0) {
                                sb.append(File.pathSeparatorChar);
                            }
                            sb.append(f1.getAbsolutePath());
                        }
                    }
                }
            } else if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getAbsolutePath());
        }
        LOGGER.log(Level.FINER, "Set deprecated class.path prop to {0}", sb);
        pubProps.setProperty("class.path", sb.toString());
        project.getAntProjectHelper().putProperties("nbproject/project.properties", pubProps);
        try {
            ProjectManager.getDefault().saveProject((Project)project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
    }
}

