/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.Enumeration;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Bundle;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RunTestsCommand
extends Command
implements Displayable {
    public static final String ID = "runTestsInFolder";
    public static final String DISPLAY_NAME = Bundle.RunTestsCommand_label();

    public RunTestsCommand(PhpProject project) {
        super(project);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public void invokeActionInternal(Lookup context) {
        FileObject folder = this.findFolderWithTest(context);
        if (folder == null) {
            this.logger.warning("Folder should be found for running tests");
            return;
        }
        ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).runFile(Lookups.fixed((Object[])new Object[]{folder}));
    }

    @Override
    public boolean isActionEnabledInternal(Lookup context) {
        return this.findFolderWithTest(context) != null;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    private FileObject findFolderWithTest(Lookup context) {
        FileObject[] files = CommandUtils.filesForContextOrSelectedNodes(context);
        if (files.length != 1) {
            return null;
        }
        FileObject file = files[0];
        if (!file.isFolder()) {
            return null;
        }
        Enumeration children = file.getChildren(true);
        while (children.hasMoreElements()) {
            FileObject child = (FileObject)children.nextElement();
            if (!child.isData() || !this.isTestFile(child) || !FileUtils.isPhpFile((FileObject)child)) continue;
            return file;
        }
        return null;
    }
}

