/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;

public class ProfilerPopupFactory {
    public static Popup getPopup(Component invoker, Component content, int x, int y) {
        return ProfilerPopupFactory.getPopup(invoker, content, x, y, null);
    }

    public static Popup getPopup(Component invoker, Component content, int x, int y, Listener listener) {
        PopupPane pane = new PopupPane(content, listener);
        Point loc = new Point(x, y);
        SwingUtilities.convertPointToScreen(loc, invoker);
        Popup popup = PopupFactory.getSharedInstance().getPopup(invoker, pane, loc.x, loc.y);
        pane.setPopup(popup);
        return popup;
    }

    public static boolean isInPopup(Component component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PopupPane)) continue;
            return true;
        }
        return false;
    }

    private static class PopupFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PopupFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            List<Component> l = this.components(aContainer);
            int i = l.indexOf(aComponent);
            return i == -1 || i == l.size() - 1 ? null : l.get(i + 1);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            List<Component> l = this.components(aContainer);
            int i = l.indexOf(aComponent);
            return i == -1 || i == 0 ? null : l.get(i - 1);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            List<Component> l = this.components(aContainer);
            return l.isEmpty() ? null : l.get(0);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            List<Component> l = this.components(aContainer);
            return l.isEmpty() ? null : l.get(l.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            ButtonModel bm;
            Component c = this.getFirstComponent(aContainer);
            if (c instanceof AbstractButton && (bm = ((AbstractButton)c).getModel()) instanceof DefaultButtonModel) {
                Enumeration<AbstractButton> en;
                ButtonGroup bg = ((DefaultButtonModel)bm).getGroup();
                Enumeration<AbstractButton> enumeration = en = bg == null ? null : bg.getElements();
                while (en != null && en.hasMoreElements()) {
                    AbstractButton ab = en.nextElement();
                    if (!ab.isSelected()) continue;
                    return ab;
                }
            }
            return c;
        }

        protected List<Component> components(Container aContainer) {
            ArrayList<Component> l = new ArrayList<Component>();
            for (int i = 0; i < aContainer.getComponentCount(); ++i) {
                Component c = aContainer.getComponent(i);
                if (c instanceof JPanel || c instanceof JToolBar) {
                    l.addAll(this.components((Container)c));
                    continue;
                }
                if (c instanceof JScrollPane) {
                    l.addAll(this.components(((JScrollPane)c).getViewport()));
                    continue;
                }
                if (!this.focusable(c)) continue;
                l.add(c);
            }
            return l;
        }

        protected boolean focusable(Component c) {
            if (c instanceof JLabel) {
                return false;
            }
            return c.isVisible() && c.isEnabled() && c.isFocusable();
        }
    }

    private static class PopupPane
    extends JPanel
    implements AWTEventListener,
    ComponentListener,
    WindowListener {
        private Popup popup;
        private final Listener listener;
        private Reference<Component> focus;
        private boolean skippingEvents;
        private boolean internal = false;

        PopupPane(Component content, Listener listener) {
            this.listener = listener;
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new PopupFocusTraversalPolicy());
            this.setLayout(new BorderLayout());
            this.add(content, "Center");
            JPopupMenu ref = new JPopupMenu();
            if (!UIUtils.isNimbus()) {
                this.setBorder(ref.getBorder());
            } else {
                this.setBorder(BorderFactory.createLineBorder(UIUtils.getDisabledLineColor()));
            }
            this.setBackground(ref.getBackground());
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }

        void setPopup(Popup popup) {
            this.popup = popup;
        }

        @Override
        public void addNotify() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null) {
                this.focus = new WeakReference<Component>(focusOwner);
            }
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component defaultFocus = PopupPane.this.getFocusTraversalPolicy().getDefaultComponent(PopupPane.this);
                    if (defaultFocus != null) {
                        defaultFocus.requestFocusInWindow();
                    }
                }
            });
            this.installListeners();
            if (this.listener != null) {
                this.listener.popupShown();
            }
        }

        @Override
        public void removeNotify() {
            this.uninstallListeners();
            if (this.focus != null) {
                Component focusOwner = this.focus.get();
                this.focus.clear();
                this.focus = null;
                if (focusOwner != null) {
                    focusOwner.requestFocusInWindow();
                }
            }
            super.removeNotify();
            if (this.listener != null) {
                this.listener.popupHidden();
            }
        }

        private void installListeners() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.addWindowListener(this);
                window.addComponentListener(this);
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 131096L);
        }

        private void uninstallListeners() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.removeComponentListener(this);
                window.removeWindowListener(this);
            }
            this.popup = null;
        }

        private void closePopup() {
            if (this.popup != null) {
                this.popup.hide();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void eventDispatched(AWTEvent e) {
            block19: {
                block18: {
                    if (this.skippingEvents) {
                        return;
                    }
                    if (!(e instanceof MouseEvent)) break block18;
                    me = (MouseEvent)e;
                    if (this.internal || me.isConsumed()) {
                        return;
                    }
                    src = me.getComponent();
                    if (src == null) {
                        return;
                    }
                    if ((src = SwingUtilities.getDeepestComponentAt(src, me.getX(), me.getY())) == null) {
                        return;
                    }
                    switch (me.getID()) {
                        case 501: 
                        case 507: {
                            if (this.isInPopup(src)) ** GOTO lbl17
                            this.closePopup();
                            ** GOTO lbl24
lbl17:
                            // 1 sources

                            this.internal = true;
                            try {
                                src.dispatchEvent(me);
                            }
                            finally {
                                this.internal = false;
                            }
lbl24:
                            // 2 sources

                            me.consume();
                        }
                    }
                    break block19;
                }
                if (e instanceof KeyEvent) {
                    me = (KeyEvent)e;
                    if (this.internal || me.isConsumed()) {
                        return;
                    }
                    if (me.getKeyCode() != 27 || me.getID() != 401) {
                        return;
                    }
                    src = me.getComponent();
                    this.internal = true;
                    try {
                        src.dispatchEvent(me);
                    }
                    finally {
                        this.internal = false;
                    }
                    if (!me.isConsumed()) {
                        this.closePopup();
                    }
                    me.consume();
                }
            }
        }

        private boolean isInPopup(Component comp) {
            while (comp != null) {
                if (comp == this || comp instanceof JPopupMenu) {
                    return true;
                }
                comp = comp.getParent();
            }
            return false;
        }

        private boolean skipClose(Component comp) {
            if (comp instanceof JComponent) {
                return Boolean.FALSE.equals(((JComponent)comp).getClientProperty("HidePopupKey"));
            }
            if (comp instanceof Container) {
                for (Component c : ((Container)comp).getComponents()) {
                    if (!this.skipClose(c)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (SwingUtilities.getWindowAncestor(this) != e.getComponent()) {
                this.closePopup();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.closePopup();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.closePopup();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.closePopup();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.closePopup();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (!this.skipClose(e.getOppositeWindow())) {
                this.closePopup();
            } else {
                this.skippingEvents = true;
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.skippingEvents = false;
        }
    }

    public static abstract class Listener {
        protected void popupShown() {
        }

        protected void popupHidden() {
        }
    }
}

