/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.jdbc.TablesSelector;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.modules.profiler.api.ActionsSupport;

abstract class SQLFilterPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String QUERIES_CAPTION = messages.getString("SQLFilterPanel_QueriesCaption");
    private static final String FILTER_BUTTON = messages.getString("SQLFilterPanel_FilterButton");
    private static final String COMMANDS_DROPDOWN = messages.getString("SQLFilterPanel_CommandsDropdown");
    private static final String COMMANDS_NOTAVAILABLE = messages.getString("SQLFilterPanel_CommandsNotAvailable");
    private static final String TABLES_DROPDOWN = messages.getString("SQLFilterPanel_TablesDropdown");
    private static final String TABLES_NOTAVAILABLE = messages.getString("SQLFilterPanel_TablesNotAvailable");
    private static final String STATEMENTS_DROPDOWN = messages.getString("SQLFilterPanel_StatementsDropdown");
    private static final String STATEMENT_REGULAR = messages.getString("SQLFilterPanel_StatementRegular");
    private static final String STATEMENT_PREPARED = messages.getString("SQLFilterPanel_StatementPrepared");
    private static final String STATEMENT_CALLABLE = messages.getString("SQLFilterPanel_StatementCallable");
    private static final String FILTER_TOOLTIP = messages.getString("SQLFilterPanel_FilterTooltip");
    private static final String COMMANDS_TOOLTIP = messages.getString("SQLFilterPanel_CommandsTooltip");
    private static final String TABLES_TOOLTIP = messages.getString("SQLFilterPanel_TablesTooltip");
    private static final String STATEMENTS_TOOLTIP = messages.getString("SQLFilterPanel_StatementsTooltip");
    private static final String APPLY_ACTION_KEY = "apply-action-key";
    private boolean initialized = false;
    private JButton applyB;
    private Configuration current = new Configuration();
    private Configuration applied = new Configuration();

    SQLFilterPanel() {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")), BorderFactory.createMatteBorder(6, 3, 6, 3, UIUtils.getProfilerResultsBackground())));
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        InvisibleToolbar toolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        KeyStroke applyKey = KeyStroke.getKeyStroke(10, 0);
        AbstractAction applyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SQLFilterPanel.this.applyB.isEnabled()) {
                            SQLFilterPanel.this.applyB.doClick();
                        }
                    }
                });
            }
        };
        toolbar.add(Box.createHorizontalStrut(3));
        toolbar.add(new JLabel(QUERIES_CAPTION));
        toolbar.add(Box.createHorizontalStrut(3));
        final JTextField filterF = new JTextField(20){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = super.getPreferredSize().height;
                if (UIUtils.isMetalLookAndFeel()) {
                    dim.height += 4;
                }
                return dim;
            }
        };
        filterF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handle();
            }

            private void handle() {
                ((SQLFilterPanel)SQLFilterPanel.this).current.filter = filterF.getText().trim().toLowerCase(Locale.ENGLISH);
                SQLFilterPanel.this.changed();
            }
        });
        filterF.getActionMap().put(APPLY_ACTION_KEY, applyAction);
        filterF.getInputMap().put(applyKey, APPLY_ACTION_KEY);
        toolbar.add(filterF);
        toolbar.add(Box.createHorizontalStrut(10));
        this.applyB = new JButton(FILTER_BUTTON){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SQLFilterPanel.this.apply();
            }
        };
        String filterAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)applyKey);
        this.applyB.setToolTipText(MessageFormat.format(FILTER_TOOLTIP, filterAccelerator));
        this.applyB.setOpaque(false);
        JPanel applyP = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        applyP.add((Component)this.applyB, "Center");
        applyP.setOpaque(false);
        toolbar.add(applyP);
        toolbar.add(Box.createHorizontalStrut(10));
        ((JToolBar)toolbar).addSeparator();
        toolbar.add(Box.createHorizontalStrut(8));
        PopupButton commands = new PopupButton(" " + COMMANDS_DROPDOWN + " "){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                ArrayList<String> commands = new ArrayList<String>(SQLFilterPanel.this.getCommands());
                if (commands.isEmpty()) {
                    JLabel l = new JLabel(COMMANDS_NOTAVAILABLE);
                    l.setBorder(BorderFactory.createEmptyBorder(9, 6, 9, 6));
                    popup.add(l);
                } else {
                    Collections.sort(commands);
                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.retainAll(commands);
                    Iterator iterator = commands.iterator();
                    while (iterator.hasNext()) {
                        String command;
                        JCheckBoxMenuItem i = new JCheckBoxMenuItem(command, !((SQLFilterPanel)SQLFilterPanel.this).current.commands.contains(command = (String)iterator.next())){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                if (!this.isSelected()) {
                                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.add(command);
                                } else {
                                    ((SQLFilterPanel)SQLFilterPanel.this).current.commands.remove(command);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SQLFilterPanel.this.apply();
                                    }
                                });
                            }
                        };
                        popup.add(i);
                    }
                }
            }
        };
        commands.setToolTipText(COMMANDS_TOOLTIP);
        toolbar.add(commands);
        toolbar.add(Box.createHorizontalStrut(5));
        PopupButton tables = new PopupButton(" " + TABLES_DROPDOWN + " "){

            @Override
            protected void displayPopup() {
                HashSet<String> tables = new HashSet<String>(SQLFilterPanel.this.getTables());
                if (tables.isEmpty()) {
                    super.displayPopup();
                } else {
                    ((SQLFilterPanel)SQLFilterPanel.this).current.tables.retainAll(tables);
                    new TablesSelector(tables, ((SQLFilterPanel)SQLFilterPanel.this).current.tables){

                        @Override
                        protected void selectionChanged(Collection<String> selected) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.tables.clear();
                            ((SQLFilterPanel)SQLFilterPanel.this).current.tables.addAll(selected);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SQLFilterPanel.this.apply();
                                }
                            });
                        }
                    }.show(this);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup) {
                JLabel l = new JLabel(TABLES_NOTAVAILABLE);
                l.setBorder(BorderFactory.createEmptyBorder(9, 6, 9, 6));
                popup.add(l);
            }
        };
        tables.setToolTipText(TABLES_TOOLTIP);
        toolbar.add(tables);
        toolbar.add(Box.createHorizontalStrut(5));
        PopupButton statements = new PopupButton(" " + STATEMENTS_DROPDOWN + " "){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(STATEMENT_REGULAR, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(0)){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(0);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(0);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
                popup.add(new JCheckBoxMenuItem(STATEMENT_PREPARED, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(1)){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(1);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(1);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
                popup.add(new JCheckBoxMenuItem(STATEMENT_CALLABLE, !((SQLFilterPanel)SQLFilterPanel.this).current.statements.contains(2)){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        if (!this.isSelected()) {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.add(2);
                        } else {
                            ((SQLFilterPanel)SQLFilterPanel.this).current.statements.remove(2);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLFilterPanel.this.apply();
                            }
                        });
                    }
                });
            }
        };
        statements.setToolTipText(STATEMENTS_TOOLTIP);
        toolbar.add(statements);
        toolbar.add(Box.createHorizontalStrut(3));
        this.add((Component)toolbar, "Center");
        this.initialized = true;
        this.changed();
    }

    private void changed() {
        if (this.initialized) {
            this.applyB.setEnabled(!this.applied.equals(this.current));
        }
    }

    private void apply() {
        this.applyB.setEnabled(false);
        this.applied.set(this.current);
        this.applyFilter();
    }

    abstract Set<String> getCommands();

    abstract Set<String> getTables();

    abstract void applyFilter();

    boolean passes(String query, String command, String[] tables, int statement) {
        if (!this.applied.filter.isEmpty() && !query.toLowerCase(Locale.ENGLISH).contains(this.applied.filter)) {
            return false;
        }
        if (!this.applied.commands.isEmpty() && this.applied.commands.contains(command)) {
            return false;
        }
        if (!this.applied.statements.isEmpty() && this.applied.statements.contains(statement)) {
            return false;
        }
        if (this.applied.tables.isEmpty()) {
            return true;
        }
        for (String table : tables) {
            if (this.applied.tables.contains(table)) continue;
            return true;
        }
        return false;
    }

    private static class Configuration {
        String filter = "";
        final Set<String> commands = new HashSet<String>();
        final Set<String> tables = new HashSet<String>();
        final Set<Integer> statements = new HashSet<Integer>();

        private Configuration() {
        }

        void set(Configuration o) {
            this.filter = o.filter;
            this.commands.clear();
            this.commands.addAll(o.commands);
            this.tables.clear();
            this.tables.addAll(o.tables);
            this.statements.clear();
            this.statements.addAll(o.statements);
        }

        public boolean equals(Object o) {
            Configuration c = (Configuration)o;
            return this.filter.equals(c.filter) && this.commands.equals(c.commands) && this.tables.equals(c.tables) && this.statements.equals(c.statements);
        }
    }
}

