/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.JExtendedTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class JCheckTree
extends JExtendedTree {
    private PrivateComponentListener componentListener = new PrivateComponentListener();
    private Collection<CheckTreeListener> checkTreeListeners = new CopyOnWriteArraySet<CheckTreeListener>();

    public JCheckTree() {
        if (!UIUtils.isGTKLookAndFeel()) {
            this.setUI(new CheckTreeUI());
        }
        this.setCellRenderer(new CheckTreeCellRenderer());
        this.setModel(JCheckTree.getDefaultTreeModel());
        this.addMouseListener(this.componentListener);
        this.addKeyListener(this.componentListener);
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        if (this.getCellRenderer() instanceof TreeCellRendererPersistent) {
            return new Point(this.rendererRect.getLocation().x + CheckTreeCellRenderer.getCheckBoxDimension().width - 1, this.rendererRect.getLocation().y - 1);
        }
        return super.getCellTipLocation();
    }

    public void addCheckTreeListener(CheckTreeListener listener) {
        if (listener != null) {
            this.checkTreeListeners.add(listener);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JCheckTreeTester");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JCheckTree checkTree = new JCheckTree();
        checkTree.addCheckTreeListener(new CheckTreeListener(){

            public void checkTreeChanged(Collection changedNodes) {
                System.out.println(changedNodes);
            }

            @Override
            public void checkNodeToggled(TreePath path, boolean before) {
                System.out.println("Node toggled");
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JScrollPane(checkTree));
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e instanceof MouseWheelEvent) {
            Container target = this.getParent();
            if (target == null || !(target instanceof JViewport)) {
                target = this;
            }
            MouseEvent mwe = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)e, target);
            target.dispatchEvent((MouseWheelEvent)mwe);
        } else {
            super.processMouseEvent(e);
        }
    }

    public void removeCheckTreeListener(CheckTreeListener listener) {
        this.checkTreeListeners.remove(listener);
    }

    protected static TreeModel getDefaultTreeModel() {
        CheckTreeNode root = new CheckTreeNode("JTree");
        CheckTreeNode parent = new CheckTreeNode("colors");
        root.add(parent);
        parent.add(new CheckTreeNode("blue"));
        parent.add(new CheckTreeNode("violet"));
        parent.add(new CheckTreeNode("red"));
        parent.add(new CheckTreeNode("yellow"));
        parent = new CheckTreeNode("sports");
        root.add(parent);
        parent.add(new CheckTreeNode("basketball"));
        parent.add(new CheckTreeNode("soccer"));
        parent.add(new CheckTreeNode("football"));
        parent.add(new CheckTreeNode("hockey"));
        parent = new CheckTreeNode("food");
        root.add(parent);
        parent.add(new CheckTreeNode("hot dogs"));
        parent.add(new CheckTreeNode("pizza"));
        parent.add(new CheckTreeNode("ravioli"));
        parent.add(new CheckTreeNode("bananas"));
        return new DefaultTreeModel(root);
    }

    @Override
    protected void processCellTipMouseMove(MouseEvent e) {
        TreePath currentTreePath = null;
        try {
            currentTreePath = this.getPathForLocation(e.getX(), e.getY());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentTreePath == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            this.lastTreePath = currentTreePath;
            return;
        }
        int row = this.getRowForPath(this.lastTreePath);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof TreeCellRendererPersistent)) {
            return;
        }
        Component cellRenderer = treeCellRenderer.getTreeCellRendererComponent(this, currentTreePath.getLastPathComponent(), false, this.isExpanded(row), this.getModel().isLeaf(currentTreePath.getLastPathComponent()), row, false);
        Component cellRendererPersistent = ((TreeCellRendererPersistent)treeCellRenderer).getTreeCellRendererComponentPersistent(this, currentTreePath.getLastPathComponent(), false, this.isExpanded(row), this.getModel().isLeaf(currentTreePath.getLastPathComponent()), row, false);
        if (cellRenderer == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            this.lastTreePath = currentTreePath;
            return;
        }
        Point cellStart = this.getPathBounds(currentTreePath).getLocation();
        this.rendererRect = new Rectangle(cellStart.x, cellStart.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height + 2);
        if (e.getX() <= this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width) {
            this.lastTreePath = new TreePath(new Object());
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        if (currentTreePath == this.lastTreePath) {
            return;
        }
        this.lastTreePath = currentTreePath;
        if (!this.rendererRect.contains(e.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle visibleRect = this.getVisibleRect();
        if (this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width >= visibleRect.x && this.rendererRect.x + this.rendererRect.width <= visibleRect.x + visibleRect.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(cellRendererPersistent, "Center");
        this.cellTip.setPreferredSize(new Dimension(cellRendererPersistent.getPreferredSize().width + 2, this.getRowHeight() + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    protected boolean shouldShowCellTipAt(Point position) {
        if (this.rendererRect == null) {
            return false;
        }
        return position.x > this.rendererRect.x + CheckTreeCellRenderer.getCheckBoxDimension().width;
    }

    private boolean isOverCheckBox(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        return path != null && path.getPathCount() != 0 && path.getLastPathComponent() instanceof CheckTreeNode && x <= this.getPathBounds((TreePath)path).x + CheckTreeCellRenderer.getCheckBoxDimension().width;
    }

    private void fireCheckTreeChanged(Collection changedNodes) {
        if (changedNodes.size() > 0) {
            for (CheckTreeListener l : this.checkTreeListeners) {
                l.checkTreeChanged(changedNodes);
            }
        }
    }

    private void fireNodeToggled(TreePath path, boolean before) {
        for (CheckTreeListener l : this.checkTreeListeners) {
            l.checkNodeToggled(path, before);
        }
    }

    private Collection togglePathState(TreePath path) {
        return ((CheckTreeNode)path.getLastPathComponent()).toggleState();
    }

    private class PrivateComponentListener
    implements MouseListener,
    KeyListener {
        private PrivateComponentListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath[] paths;
            if (e.getKeyCode() == 32 && (paths = JCheckTree.this.getSelectionPaths()) != null && paths.length > 0) {
                ArrayList changedNodes = new ArrayList();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    if (path != null && path.getPathCount() > 0 && path.getLastPathComponent() instanceof CheckTreeNode && (((CheckTreeNode)path.getLastPathComponent()).isLeaf() || i == paths.length - 1)) {
                        JCheckTree.this.fireNodeToggled(path, true);
                    }
                    changedNodes.addAll(JCheckTree.this.togglePathState(path));
                    JCheckTree.this.fireNodeToggled(path, false);
                }
                JCheckTree.this.treeDidChange();
                JCheckTree.this.fireCheckTreeChanged(changedNodes);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JCheckTree.this.isOverCheckBox(e.getX(), e.getY())) {
                TreePath path = JCheckTree.this.getPathForLocation(e.getX(), e.getY());
                JCheckTree.this.fireNodeToggled(path, true);
                Collection changedNodes = JCheckTree.this.togglePathState(JCheckTree.this.getPathForLocation(e.getX(), e.getY()));
                JCheckTree.this.treeDidChange();
                JCheckTree.this.fireNodeToggled(path, false);
                JCheckTree.this.fireCheckTreeChanged(changedNodes);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class CheckTreeUI
    extends BasicTreeUI {
        private CheckTreeUI() {
        }

        @Override
        protected boolean isToggleEvent(MouseEvent event) {
            if (JCheckTree.this.isOverCheckBox(event.getX(), event.getY())) {
                return false;
            }
            return super.isToggleEvent(event);
        }
    }

    public static interface CheckTreeListener {
        public void checkNodeToggled(TreePath var1, boolean var2);

        public void checkTreeChanged(Collection<CheckTreeNode> var1);
    }
}

