/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.Bundle;
import org.netbeans.modules.j2ee.weblogic9.CertificateQuestionPanel;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class WLTrustHandler
implements WebLogicTrustHandler {
    public static final String TRUST_EXCEPTION_PROPERTY = "trustException";
    private static final Logger LOGGER = Logger.getLogger(WLTrustHandler.class.getName());
    private static final RequestProcessor TRUST_CHECK = new RequestProcessor("Trust Handler Check", 5);
    private static final RequestProcessor TRUST_MANAGER_ACCESS = new RequestProcessor(WLTrustHandler.class);
    private static final int CHECK_TIMEOUT = 5000;
    private static final String TRUST_STORE_PATH = "J2EE/TrustStores/wlstruststore.jks";
    private static final String TRUST_PASSWORD_KEY = "nb_weblogic_truststore";
    private static final SecureRandom RANDOM = new SecureRandom();

    public TrustManager getTrustManager(WebLogicConfiguration config) throws GeneralSecurityException {
        return new DelegatingTrustManager(config);
    }

    public Map<String, String> getTrustProperties(WebLogicConfiguration config) {
        WLTrustHandler.check(config);
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)WLDeploymentFactory.getUrl(config));
        boolean trustException = Boolean.parseBoolean(ip.getProperty(TRUST_EXCEPTION_PROPERTY));
        if (!trustException) {
            return Collections.emptyMap();
        }
        FileObject fo = FileUtil.getConfigFile((String)TRUST_STORE_PATH);
        if (fo == null) {
            return Collections.emptyMap();
        }
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("weblogic.security.TrustKeyStore", "CustomTrust");
        result.put("weblogic.security.CustomTrustKeyStoreType", "JKS");
        result.put("weblogic.security.CustomTrustKeyStoreFileName", file.getAbsolutePath());
        result.put("weblogic.security.SSL.ignoreHostnameVerification", "true");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeFromTrustStore(String url) throws GeneralSecurityException, IOException {
        FileObject root = FileUtil.getConfigRoot();
        FileObject ts = root.getFileObject(TRUST_STORE_PATH);
        if (ts == null) {
            return;
        }
        char[] password = Keyring.read((String)TRUST_PASSWORD_KEY);
        KeyStore keystore = KeyStore.getInstance("JKS");
        BufferedInputStream is = new BufferedInputStream(ts.getInputStream());
        try {
            keystore.load(is, password);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return;
        }
        finally {
            ((InputStream)is).close();
        }
        keystore.deleteEntry(url);
        BufferedOutputStream out = new BufferedOutputStream(ts.getOutputStream());
        try {
            keystore.store(out, password);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static boolean check(final WebLogicConfiguration config) {
        Future task = TRUST_CHECK.submit(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public Boolean call() {
                try {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, new TrustManager[]{new DelegatingTrustManager(config)}, RANDOM);
                    SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
                    try {
                        socket.connect(new InetSocketAddress(config.getHost(), config.getPort()), 5000);
                        socket.setSoTimeout(5000);
                        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), true);
                        try {
                            out.println("GET / HTTP/1.1\nHost:\n");
                            Boolean bl = true;
                            out.close();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            out.close();
                            throw throwable;
                        }
                    }
                    finally {
                        socket.close();
                    }
                }
                catch (GeneralSecurityException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                return false;
            }
        });
        try {
            return (Boolean)task.get(6000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return false;
    }

    private static X509Certificate[] sortChain(X509Certificate[] certificates) {
        if (certificates != null && certificates.length == 1) {
            return certificates;
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.addAll(Arrays.asList(certificates));
        X509Certificate certChain = (X509Certificate)certs.get(0);
        certs.remove(certChain);
        LinkedList<X509Certificate> chainList = new LinkedList<X509Certificate>();
        chainList.add(certChain);
        Principal certIssuer = certChain.getIssuerDN();
        Principal certSubject = certChain.getSubjectDN();
        while (!certs.isEmpty()) {
            ArrayList<X509Certificate> tempcerts = new ArrayList<X509Certificate>();
            tempcerts.addAll(certs);
            for (X509Certificate cert : tempcerts) {
                if (cert.getIssuerDN().equals(certSubject)) {
                    chainList.addFirst(cert);
                    certSubject = cert.getSubjectDN();
                    certs.remove(cert);
                    continue;
                }
                if (!cert.getSubjectDN().equals(certIssuer)) continue;
                chainList.addLast(cert);
                certIssuer = cert.getIssuerDN();
                certs.remove(cert);
            }
        }
        return chainList.toArray(new X509Certificate[chainList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addToTrustStore(String url, X509Certificate cert) throws GeneralSecurityException, IOException {
        FileObject root = FileUtil.getConfigRoot();
        FileObject ts = root.getFileObject(TRUST_STORE_PATH);
        char[] password = Keyring.read((String)TRUST_PASSWORD_KEY);
        if (password == null) {
            password = new BigInteger(130, RANDOM).toString(32).toCharArray();
            Keyring.save((String)TRUST_PASSWORD_KEY, (char[])password, null);
        }
        KeyStore keystore = KeyStore.getInstance("JKS");
        BufferedInputStream is = ts == null ? null : new BufferedInputStream(ts.getInputStream());
        try {
            keystore.load(is, password);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            keystore.load(null, null);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        keystore.setCertificateEntry(url, cert);
        if (ts == null) {
            ts = FileUtil.createData((FileObject)root, (String)TRUST_STORE_PATH);
        }
        BufferedOutputStream out = new BufferedOutputStream(ts.getOutputStream());
        try {
            keystore.store(out, password);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static synchronized X509TrustManager createTrustManager(FileObject fo) throws GeneralSecurityException, IOException {
        KeyStore ts = KeyStore.getInstance("JKS");
        BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
        try {
            ts.load(in, null);
        }
        finally {
            ((InputStream)in).close();
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)tms[i];
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    private static class DelegatingTrustManager
    implements X509TrustManager {
        private final WebLogicConfiguration config;
        private X509TrustManager pkixTrustManager;

        DelegatingTrustManager(WebLogicConfiguration config) throws NoSuchAlgorithmException, KeyStoreException {
            this.config = config;
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init((KeyStore)null);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                this.pkixTrustManager = (X509TrustManager)tms[i];
                break;
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("TrustManager does not trust any client");
        }

        @Override
        public void checkServerTrusted(final X509Certificate[] chain, final String authType) throws CertificateException {
            final String url = WLDeploymentFactory.getUrl(this.config);
            final InstanceProperties ip = InstanceProperties.getInstanceProperties((String)url);
            if (ip == null) {
                return;
            }
            try {
                this.pkixTrustManager.checkServerTrusted(chain, authType);
                String rawTrustValue = ip.getProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY);
                if (rawTrustValue != null) {
                    ip.setProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY, null);
                    try {
                        WLTrustHandler.removeFromTrustStore(url);
                    }
                    catch (GeneralSecurityException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
            }
            catch (CertificateException excep) {
                LOGGER.log(Level.FINE, null, excep);
                Future task = TRUST_MANAGER_ACCESS.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws GeneralSecurityException, IOException {
                        FileObject fo;
                        String rawTrustValue = ip.getProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY);
                        boolean trustException = Boolean.parseBoolean(rawTrustValue);
                        if (trustException && (fo = FileUtil.getConfigFile((String)WLTrustHandler.TRUST_STORE_PATH)) != null) {
                            try {
                                X509TrustManager m = WLTrustHandler.createTrustManager(fo);
                                try {
                                    m.checkServerTrusted(chain, authType);
                                    return true;
                                }
                                catch (CertificateException ex) {
                                    LOGGER.log(Level.FINE, null, ex);
                                }
                            }
                            catch (GeneralSecurityException ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                        if (rawTrustValue != null && !trustException) {
                            return false;
                        }
                        X509Certificate[] sorted = WLTrustHandler.sortChain(chain);
                        X509Certificate last = sorted[sorted.length - 1];
                        String removeOption = Bundle.LBL_RemoveServer();
                        NotifyDescriptor descriptor = new NotifyDescriptor((Object)new CertificateQuestionPanel(last), Bundle.LBL_Certificate(), 0, 2, new Object[]{removeOption, NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                        Object result = DialogDisplayer.getDefault().notify(descriptor);
                        if (result == NotifyDescriptor.YES_OPTION) {
                            WLTrustHandler.addToTrustStore(url, last);
                            ip.setProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY, Boolean.TRUE.toString());
                            return true;
                        }
                        if (result.equals(removeOption)) {
                            ip.setProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY, Boolean.FALSE.toString());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    InstanceProperties.removeInstance((String)url);
                                }
                            });
                            return false;
                        }
                        ip.setProperty(WLTrustHandler.TRUST_EXCEPTION_PROPERTY, Boolean.FALSE.toString());
                        return false;
                    }
                });
                try {
                    if (!((Boolean)task.get()).booleanValue()) {
                        throw excep;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                    throw new CertificateException(ex);
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.pkixTrustManager.getAcceptedIssuers();
        }
    }
}

