/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.common.ant;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.j2me.common.ant.Bundle;
import org.netbeans.modules.j2me.common.ant.LibletUtils;

public class ExtractTask
extends Task {
    private Path classPath;
    private Path exClassPath;
    private File dir;
    private boolean excludeManifest = false;

    public void execute() throws BuildException {
        if (this.classPath == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "classPath"));
        }
        if (this.dir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "dir"));
        }
        if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_Extract_InvalidDir", this.dir != null ? this.dir.getAbsolutePath() : null));
        }
        String[] archives = this.classPath.list();
        Set<Object> excludes = this.exClassPath == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(this.exClassPath.list()));
        Map<String, Boolean> libletsInProject = LibletUtils.loadLibletsInProject(this.getProject());
        if (archives != null) {
            for (int a = 0; a < archives.length; ++a) {
                Map<Object, Object> manifestAttributes;
                if (excludes.contains(archives[a]) || LibletUtils.isJarLiblet(manifestAttributes = LibletUtils.getJarManifestAttributes(archives[a])) && !libletsInProject.get(LibletUtils.getLibletDetails(manifestAttributes)).booleanValue()) continue;
                File source = new File(archives[a]);
                this.log(Bundle.getMessage("MSG_Extract_ProcessingPath", source.getAbsolutePath()), 3);
                if (!source.exists()) {
                    this.log(Bundle.getMessage("WARN_Extract_IgnoringPath", source.getAbsolutePath()), 1);
                    continue;
                }
                if (source.isFile()) {
                    String name = source.getName().toLowerCase();
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) {
                        this.log(Bundle.getMessage("WARN_Extract_IgnoringPath", source.getAbsolutePath()), 1);
                        continue;
                    }
                    this.extractZip(source, this.dir);
                    continue;
                }
                if (!source.isDirectory()) continue;
                this.copyDir(source, this.dir);
            }
        }
    }

    private void extractZip(File source, File target) throws BuildException {
        Expand e = new Expand();
        e.setProject(this.getProject());
        e.setOverwrite(false);
        if (this.excludeManifest) {
            PatternSet ps = new PatternSet();
            ps.setExcludes("META-INF,META-INF/MANIFEST.MF");
            e.addPatternset(ps);
        }
        e.setSrc(source);
        e.setDest(target);
        e.execute();
    }

    private void copyDir(File source, File target) throws BuildException {
        Copy c = new Copy();
        c.setProject(this.getProject());
        c.setOverwrite(false);
        FileSet fileset = new FileSet();
        fileset.setDir(source);
        c.addFileset(fileset);
        c.setTodir(target);
        c.execute();
    }

    public void setClassPath(Path classPath) {
        this.createClassPath().append(classPath);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setExcludeClassPath(Path classPath) {
        this.createExcludeClassPath().append(classPath);
    }

    public Path createExcludeClassPath() {
        if (this.exClassPath == null) {
            this.exClassPath = new Path(this.getProject());
        }
        return this.exClassPath.createPath();
    }

    public void setClassPathRef(Reference classPathRef) {
        this.createClassPath().setRefid(classPathRef);
    }

    public void setExcludeClassPathRef(Reference classPathRef) {
        this.createExcludeClassPath().setRefid(classPathRef);
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setExcludeManifest(boolean excludeManifest) {
        this.excludeManifest = excludeManifest;
    }
}

