/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.FileID;
import org.clang.basic.FixItHint;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.llvm.DenseMapInfoFileID;
import org.clang.lex.Lexer;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallDenseMap;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;

public final class DiagnosticRendererStatics {
    public static StringRef getImmediateMacroName(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return DiagnosticRendererStatics.getImmediateMacroName(Loc.getRawEncoding(), SM, LangOpts);
    }

    public static StringRef getImmediateMacroName(int Loc, SourceManager SM, LangOptions LangOpts) {
        assert (SourceLocation.isMacroID((int)Loc)) : "Only reasonble to call this on macros";
        while (SM.isMacroArgExpansion(Loc)) {
            Loc = BasicClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc));
        }
        if (SM.getFileEntryForID(SM.getFileID(SM.getSpellingLoc(Loc))) == null) {
            return new StringRef();
        }
        Loc = SM.getSpellingLoc(BasicClangGlobals.$first_SourceLocation((long)SM.getImmediateExpansionRange(Loc)));
        long ExpansionInfo = SM.getDecomposedLoc(Loc);
        int MacroTokenLength = Lexer.MeasureTokenLength((int)Loc, (SourceManager)SM, (LangOptions)LangOpts);
        StringRef ExpansionBuffer = SM.getBufferData(BasicClangGlobals.$first_FileID((long)ExpansionInfo));
        return ExpansionBuffer.substr(BasicClangGlobals.$second_offset((long)ExpansionInfo), MacroTokenLength);
    }

    public static void mergeFixits(ArrayRef<FixItHint> FixItHints, SourceManager SM, LangOptions LangOpts, SmallVectorImpl<FixItHint> MergedFixits) {
        llvm.errs().$out("NOT IMPLEMENTED DiagnosticRendererStatics.mergeFixits\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapDiagnosticRanges(SourceLocation CaretLoc, ArrayRef<CharSourceRange> Ranges, SmallVectorImpl<CharSourceRange> SpellingRanges, SourceManager SM) {
        FileID CaretLocFileID = SM.getFileID(CaretLoc);
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Ranges.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Ranges.end());
        while (I.$noteq((Object)E)) {
            SmallDenseMap BeginLocsMap = null;
            try {
                SourceLocation Begin = ((CharSourceRange)I.$star()).getBegin();
                SourceLocation End = ((CharSourceRange)I.$star()).getEnd();
                boolean IsTokenRange = ((CharSourceRange)I.$star()).isTokenRange();
                FileID BeginFileID = SM.getFileID(Begin);
                FileID EndFileID = SM.getFileID(End);
                BeginLocsMap = new SmallDenseMap((DenseMapInfo)new DenseMapInfoFileID(), (Object)new SourceLocation());
                while (Begin.isMacroID() && BeginFileID.$noteq(EndFileID)) {
                    ((SourceLocation)BeginLocsMap.$at((Object)BeginFileID)).$assign(Begin);
                    Begin.$assign((SourceLocation)SM.getImmediateExpansionRange((SourceLocation)Begin).first);
                    BeginFileID.$assign(SM.getFileID(Begin));
                }
                if (BeginFileID.$noteq(EndFileID)) {
                    while (End.isMacroID() && BeginLocsMap.count((Object)EndFileID) == 0) {
                        End.$assign((SourceLocation)SM.getImmediateExpansionRange((SourceLocation)End).second);
                        EndFileID.$assign(SM.getFileID(End));
                    }
                    if (End.isMacroID()) {
                        Begin.$assign((SourceLocation)BeginLocsMap.$at((Object)EndFileID));
                        BeginFileID.$assign(EndFileID);
                    }
                }
                while (Begin.isMacroID() && BeginFileID.$noteq(CaretLocFileID)) {
                    if (SM.isMacroArgExpansion(Begin)) {
                        Begin.$assign(SM.getImmediateSpellingLoc(Begin));
                        End.$assign(SM.getImmediateSpellingLoc(End));
                    } else {
                        Begin.$assign((SourceLocation)SM.getImmediateExpansionRange((SourceLocation)Begin).first);
                        End.$assign((SourceLocation)SM.getImmediateExpansionRange((SourceLocation)End).second);
                    }
                    BeginFileID.$assign(SM.getFileID(Begin));
                    if (!BeginFileID.$noteq(SM.getFileID(End))) continue;
                    Begin.$assign(End.$assign(new SourceLocation()));
                    break;
                }
                Begin.$assign(SM.getSpellingLoc(Begin));
                End.$assign(SM.getSpellingLoc(End));
                SpellingRanges.push_back((Object)new CharSourceRange(new SourceRange(Begin, End), IsTokenRange));
            }
            finally {
                if (BeginLocsMap != null) {
                    BeginLocsMap.$destroy();
                }
            }
            I.$preInc();
        }
    }
}

