/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public abstract class AddCardHandler {
    private final String name;

    protected AddCardHandler(String name) {
        this.name = name;
    }

    public abstract Card showNewDeviceDialog(DataObject var1, JavacardPlatform var2, CardCreatedCallback var3, FileObject var4);

    public boolean isEnabled(JavacardPlatform target) {
        return target.isValid();
    }

    public final String getName() {
        return this.name;
    }

    public static final Lookup.Result<? extends AddCardHandler> handlersFor(JavacardPlatform platform) {
        String path = "org-netbeans-modules-javacard-spi/kinds/" + platform.getPlatformKind();
        return Lookups.forPath((String)path).lookupResult(AddCardHandler.class);
    }

    public static Action createAddDeviceAction(DataObject pdo, JavacardPlatform platform, CardCreatedCallback callback) {
        Collection c = AddCardHandler.handlersFor(platform).allItems();
        int ct = c.size();
        if (ct == 0) {
            return null;
        }
        if (ct == 1) {
            return new SingleHandlerAction(platform, pdo, (AddCardHandler)((Lookup.Item)c.iterator().next()).getInstance(), callback);
        }
        return new AddAction(pdo, platform, callback);
    }

    public static interface CardCreatedCallback {
        public void onCardCreated(Card var1, FileObject var2);
    }

    private static class SingleHandlerAction
    extends AbstractAction {
        private final JavacardPlatform platform;
        private final DataObject pdo;
        private final AddCardHandler handler;
        private final CardCreatedCallback callback;

        public SingleHandlerAction(JavacardPlatform platform, DataObject pdo, AddCardHandler handler, CardCreatedCallback callback) {
            this.platform = platform;
            this.callback = callback;
            this.pdo = pdo;
            this.handler = handler;
            this.putValue("Name", NbBundle.getMessage(SingleHandlerAction.class, (String)"ACTION_ADD", (Object)handler.getName()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject targetFolder = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)this.platform.getSystemName(), (boolean)true);
            Card card = this.handler.showNewDeviceDialog(this.pdo, this.platform, this.callback, targetFolder);
        }
    }

    private static final class AddAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JavacardPlatform platform;
        private final DataObject pdo;
        private final CardCreatedCallback callback;

        private AddAction(DataObject pdo, JavacardPlatform platform, CardCreatedCallback callback) {
            this.pdo = pdo;
            this.platform = platform;
            this.callback = callback;
            this.putValue("Name", NbBundle.getMessage(AddAction.class, (String)"SUBMENU_NEW_CARD"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new AssertionError((Object)"Not supported.");
        }

        public JMenuItem getPopupPresenter() {
            JMenu menu = new JMenu(this);
            for (AddCardHandler handler : AddCardHandler.handlersFor(this.platform).allInstances()) {
                menu.add(new SingleHandlerAction(this.platform, this.pdo, handler, this.callback));
            }
            return menu;
        }
    }
}

