/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.propdos;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesBasedDataObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class AntStyleResolvingProperties
extends ObservableProperties {
    private final Set<PropertyChangeEvent> pendingEvents = new HashSet<PropertyChangeEvent>();
    private final List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();
    private volatile boolean loading;
    private final Runnable r = new R();
    private static RequestProcessor rp = new RequestProcessor("Resolving Properties", 1, true);
    private final RequestProcessor.Task task = rp.create(this.r);
    private final boolean sync;
    static final Pattern NESTED_PROP_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public AntStyleResolvingProperties() {
        this(false);
    }

    public AntStyleResolvingProperties(boolean fireChangesSynchronously) {
        this.sync = fireChangesSynchronously;
    }

    @Override
    public String getProperty(String key, String def) {
        String result = this.getProperty(key);
        return result == null ? def : result;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, true);
    }

    public String getProperty(String key, boolean resolve) {
        String result = (String)this.get(key);
        if (resolve && result != null && result.indexOf("${") >= 0) {
            result = this.resolve(key, result);
        }
        return result;
    }

    protected boolean isSavableProperty(String key) {
        return true;
    }

    public String resolve(String key, String value) {
        if (value != null && value.equals("${" + key + "}")) {
            return key;
        }
        StringBuilder sb = new StringBuilder(value);
        Matcher m = NESTED_PROP_PATTERN.matcher(sb);
        while (m.find()) {
            String replacement;
            String resolveKey = m.group(1);
            if (resolveKey.equals(key) || (replacement = this.getProperty(resolveKey)) == null) continue;
            int start = m.start();
            int end = m.end();
            sb.replace(start, end, replacement);
            m = NESTED_PROP_PATTERN.matcher(sb);
        }
        return sb.toString().trim();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        this.loading = true;
        try {
            super.load(inStream);
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.FINE)) {
            PropertiesBasedDataObject.LOGGER.log(Level.FINE, "Writing a {0} to disk", this.getClass().getName());
        }
        if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.FINEST)) {
            PropertiesBasedDataObject.LOGGER.log(Level.FINEST, "DATA:{0}", this);
        }
        EditableProperties props = new EditableProperties(true);
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            String key = (String)e.getKey();
            if (!this.isSavableProperty(key)) continue;
            props.setProperty(key, this.getProperty(key, false));
        }
        props.store(out);
    }

    void onChangeOccurred() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePendingChangeEvents() {
        HashSet<PropertyChangeEvent> toFire;
        AntStyleResolvingProperties antStyleResolvingProperties = this;
        synchronized (antStyleResolvingProperties) {
            toFire = new HashSet<PropertyChangeEvent>(this.pendingEvents);
            this.pendingEvents.clear();
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.r;
        synchronized (this.r) {
            PropertyChangeListener[] ls = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            for (PropertyChangeListener l : ls) {
                for (PropertyChangeEvent e : toFire) {
                    try {
                        l.propertyChange(e);
                    }
                    catch (RuntimeException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        Runnable runnable = this.r;
        synchronized (runnable) {
            this.listeners.add(pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvents(Collection<PropertyChangeEvent> events) {
        AntStyleResolvingProperties antStyleResolvingProperties = this;
        synchronized (antStyleResolvingProperties) {
            this.pendingEvents.addAll(events);
        }
        this.firePendingChangeEvents();
    }

    protected final boolean isLoading() {
        return this.loading;
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object result = super.put(key, value);
        if (!this.equals(value, result) && !this.loading) {
            CoalescablePropertyChangeEvent evt = new CoalescablePropertyChangeEvent(this, key.toString(), result, value);
            this.pendingEvents.add(evt);
            if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.FINEST)) {
                PropertiesBasedDataObject.LOGGER.log(Level.FINEST, "Scheduling write of " + this + " in 500ms due to write of property " + key + " to " + value, new Exception());
            }
            if (!Boolean.getBoolean("JCProjectTest")) {
                if (!this.sync) {
                    this.task.schedule(500);
                } else {
                    this.r.run();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        Runnable runnable = this.r;
        synchronized (runnable) {
            this.listeners.remove(pcl);
        }
    }

    private static final class CoalescablePropertyChangeEvent
    extends PropertyChangeEvent {
        CoalescablePropertyChangeEvent(AntStyleResolvingProperties source, String name, Object old, Object nue) {
            super(source, name, old, nue);
            Parameters.notNull((CharSequence)"property name", (Object)name);
            Parameters.notNull((CharSequence)"source", (Object)source);
        }

        public boolean equals(Object obj) {
            boolean result;
            boolean bl = result = obj != null && obj.getClass() == CoalescablePropertyChangeEvent.class;
            if (result) {
                CoalescablePropertyChangeEvent other = (CoalescablePropertyChangeEvent)obj;
                Object otherSource = other.getSource();
                boolean bl2 = result = otherSource == this.getSource();
                if (result) {
                    String otherName = other.getPropertyName();
                    result = this.getPropertyName().equals(otherName);
                }
            }
            return result;
        }

        public int hashCode() {
            int srcCode = System.identityHashCode(this.getSource());
            return srcCode * 41 * this.getPropertyName().hashCode();
        }
    }

    private final class R
    implements Runnable {
        private R() {
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                try {
                    AntStyleResolvingProperties.this.onChangeOccurred();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    EventQueue.invokeLater(this);
                }
            } else {
                AntStyleResolvingProperties.this.firePendingChangeEvents();
            }
        }
    }
}

