/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class BrowserUtils {
    public static final ImageIcon ICON_INSTANCE = Icons.getImageIcon((String)"LanguageIcons.Instance");
    public static final ImageIcon ICON_PRIMITIVE = Icons.getImageIcon((String)"LanguageIcons.Primitive");
    public static final ImageIcon ICON_ARRAY = Icons.getImageIcon((String)"LanguageIcons.Array");
    public static final ImageIcon ICON_PROGRESS = Icons.getImageIcon((String)"HeapWalkerIcons.Progress");
    public static final ImageIcon ICON_STATIC = Icons.getImageIcon((String)"HeapWalkerIcons.Static");
    public static final ImageIcon ICON_LOOP = Icons.getImageIcon((String)"HeapWalkerIcons.Loop");
    public static final ImageIcon ICON_GCROOT = Icons.getImageIcon((String)"HeapWalkerIcons.GcRoot");
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("HeapWalker Processor", 5, true);
    private static final int MAX_FULLNAME_LENGTH = 100;

    public static String getArrayItemType(String arrayTypeName) {
        int arrayBracketsIdx = arrayTypeName.lastIndexOf(91);
        return arrayBracketsIdx == -1 ? arrayTypeName : arrayTypeName.substring(0, arrayBracketsIdx);
    }

    public static String getArrayBaseType(String arrayTypeName) {
        int arrayBracketsIdx = arrayTypeName.indexOf(91);
        return arrayBracketsIdx == -1 ? arrayTypeName : arrayTypeName.substring(0, arrayBracketsIdx);
    }

    public static String getFullNodeName(HeapWalkerNode node) {
        StringBuilder sb = new StringBuilder();
        while (!node.isRoot()) {
            int length = sb.length();
            if (length < 100) {
                String nodeName = BrowserUtils.getNodeName(node);
                sb.insert(0, "." + nodeName);
                node = node.getParent();
                continue;
            }
            sb.delete(0, Bundle.BrowserUtils_TruncatedMsg().length());
            sb.insert(0, Bundle.BrowserUtils_TruncatedMsg());
            break;
        }
        sb.insert(0, BrowserUtils.getNodeName(node));
        return sb.toString();
    }

    public static GroupingInfo getGroupingInfo(int itemsCount) {
        int childrenCount = itemsCount;
        int collapseUnitSize = 500;
        int containersCount = (int)Math.ceil((float)childrenCount / (float)collapseUnitSize);
        while (containersCount > 5000 && collapseUnitSize < 5000) {
            containersCount = (int)Math.ceil((float)childrenCount / (float)(collapseUnitSize += 500));
        }
        return new GroupingInfo(containersCount, collapseUnitSize);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode node) {
        while (node != null && !node.isRoot()) {
            node = node.getParent();
        }
        return node == null ? null : node;
    }

    public static String getSimpleType(String fullType) {
        int simpleTypeIdx = fullType.lastIndexOf(46);
        if (simpleTypeIdx == -1) {
            return fullType;
        }
        if (fullType.startsWith("<")) {
            return "<" + fullType.substring(simpleTypeIdx + 1);
        }
        return fullType.substring(simpleTypeIdx + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static TreePath ensurePathComputed(HeapWalkerNode root, TreePath path, Set<HeapWalkerNode> processed) {
        ArrayList<HeapWalkerNode> p = new ArrayList<HeapWalkerNode>();
        Object[] obj = path.getPath();
        if (root == null || !((Object)((Object)root)).equals(obj[0])) {
            return null;
        }
        p.add(root);
        for (int i = 1; i <= obj.length; ++i) {
            HeapWalkerNode[] ch = null;
            if (root instanceof AbstractHeapWalkerNode && !processed.contains((Object)root)) {
                AbstractHeapWalkerNode a = (AbstractHeapWalkerNode)root;
                ChildrenComputer c = a.getChildrenComputer();
                if (c != null) {
                    ch = c.computeChildren();
                }
                a.setChildren(ch);
                processed.add(root);
            }
            if (ch == null) {
                ch = root.getChildren();
            }
            root = null;
            if (i < obj.length) {
                for (HeapWalkerNode x : ch) {
                    if (!((Object)((Object)x)).equals(obj[i])) continue;
                    root = x;
                    p.add(root);
                    break;
                }
            }
            if (root == null) break;
        }
        return new TreePath(p.toArray());
    }

    public static void restoreState(JTreeTable ttable, List paths, TreePath selected) {
        if (paths != null) {
            JTree tree = ttable.getTree();
            HeapWalkerNode root = (HeapWalkerNode)((Object)tree.getModel().getRoot());
            for (Object path : paths) {
                BrowserUtils.ensurePathComputed(root, (TreePath)path, new HashSet<HeapWalkerNode>());
            }
            ttable.setup(paths, selected);
        }
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        HeapWalkerNode node = instanceNode;
        Instance instance = instanceNode.getInstance();
        Instance nextInstance = instance.getNearestGCRootPointer();
        HeapWalkerNode[] children = null;
        while (!instance.equals(nextInstance)) {
            if (nextInstance == null || node == null) {
                node = null;
                break;
            }
            if (children == null) {
                if (node instanceof InstanceNode && !node.currentlyHasChildren()) {
                    InstanceNode inode = node;
                    children = inode.getChildrenComputer().computeChildren();
                    inode.setChildren(children);
                } else {
                    children = ((HeapWalkerNode)node).getChildren();
                }
            }
            for (int i = 0; i < children.length; ++i) {
                HeapWalkerNode child = children[i];
                if (child instanceof InstanceNode) {
                    if (!((InstanceNode)child).getInstance().equals(nextInstance)) continue;
                    node = child;
                    children = null;
                    break;
                }
                if (!(child instanceof InstancesContainerNode) || !((InstancesContainerNode)child).getInstances().contains(nextInstance)) continue;
                node = child;
                children = null;
                break;
            }
            instance = nextInstance;
            nextInstance = nextInstance.getNearestGCRootPointer();
        }
        return node;
    }

    public static ImageIcon createGCRootIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode parent, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        if (parent instanceof AbstractHeapWalkerNode) {
                            HeapWalkerNode[] computedChildren;
                            boolean oome = false;
                            try {
                                computedChildren = childrenComputer.computeChildren();
                            }
                            catch (OutOfMemoryError e) {
                                oome = true;
                                computedChildren = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(parent)};
                            }
                            final HeapWalkerNode[] computedChildrenF = computedChildren;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((AbstractHeapWalkerNode)parent).changeChildren(computedChildrenF);
                                    HeapWalkerNode root = BrowserUtils.getRoot(parent);
                                    if (root instanceof RootNode) {
                                        ((RootNode)((Object)root)).refreshView();
                                    }
                                }
                            });
                            if (oome) {
                                ProfilerDialogs.displayError((String)Bundle.BrowserUtils_OutOfMemoryMsg());
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(parent)};
    }

    public static void copyPathFromRoot(final TreePath path) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                StringSelection s = new StringSelection(BrowserUtils.pathFromRoot(path));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
                ProfilerDialogs.displayInfo((String)Bundle.BrowserUtils_PathCopiedToClipboard());
            }
        });
    }

    private static String pathFromRoot(TreePath path) {
        int m = ((HeapWalkerNode)((Object)path.getLastPathComponent())).getMode();
        Object[] nodes = path.getPath();
        StringBuilder b = new StringBuilder();
        int s = nodes.length;
        for (int i = 0; i < s; ++i) {
            HeapWalkerNode n = (HeapWalkerNode)((Object)nodes[i]);
            if (m == 1) {
                BrowserUtils.fieldFromRoot(n, b, i, s);
            } else {
                BrowserUtils.referenceFromRoot(n, b, i, s);
            }
            b.append("\n");
        }
        return b.toString().replace("].[", "");
    }

    private static void fieldFromRoot(HeapWalkerNode n, StringBuilder b, int i, int s) {
        if (i == 0) {
            b.append(n.getName());
            b.append("     - ");
            b.append("value: ");
            b.append(n.getType());
            b.append(" ");
            b.append(n.getValue());
        } else {
            BrowserUtils.indent(b, i);
            b.append("-> ");
            b.append(n.getName());
            b.append("     - ");
            b.append("class: ");
            b.append(n.getParent().getType());
            b.append(", ");
            b.append("value: ");
            b.append(n.getType());
            b.append(" ");
            b.append(n.getValue());
        }
    }

    private static void referenceFromRoot(HeapWalkerNode n, StringBuilder b, int i, int s) {
        if (i == 0) {
            b.append(n.getName());
            b.append("     - ");
            b.append("value: ");
            b.append(n.getType());
            b.append(" ");
            b.append(n.getValue());
        } else {
            BrowserUtils.indent(b, i);
            b.append("<- ");
            b.append(n.getName());
            b.append("     - ");
            b.append("class: ");
            b.append(n.getType());
            b.append(", ");
            b.append("value: ");
            b.append(n.getParent().getType());
            b.append(" ");
            b.append(n.getParent().getValue());
        }
    }

    private static void indent(StringBuilder b, int i) {
        while (i-- > 0) {
            b.append(" ");
        }
    }

    public static RequestProcessor.Task performTask(Runnable task) {
        return REQUEST_PROCESSOR.post(task);
    }

    public static RequestProcessor.Task performTask(Runnable task, int timeToWait) {
        return REQUEST_PROCESSOR.post(task, timeToWait);
    }

    private static String getNodeName(HeapWalkerNode node) {
        String name = node.getName();
        if (name.endsWith(")")) {
            name = name.substring(0, name.indexOf(40)).trim();
        }
        return name;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int containersCount, int collapseUnitSize) {
            this.containersCount = containersCount;
            this.collapseUnitSize = collapseUnitSize;
        }
    }
}

