/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;

class DispatchClientMethodGenerator
implements Task<WorkingCopy> {
    private String operation;
    private int position;
    private String body;
    private boolean isBodyContext;

    DispatchClientMethodGenerator(String operation, String body, int position) {
        this.operation = operation;
        this.position = position;
        this.body = body;
    }

    public void run(WorkingCopy copy) throws Exception {
        copy.toPhase(JavaSource.Phase.RESOLVED);
        ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)copy);
        if (javaClass != null) {
            this.identifyConext(javaClass, copy);
            if (this.isMethodBody()) {
                return;
            }
            TreeMaker maker = copy.getTreeMaker();
            HashSet<Modifier> methodModifs = new HashSet<Modifier>();
            methodModifs.add(Modifier.PRIVATE);
            PrimitiveTypeTree returnTypeTree = maker.PrimitiveType(TypeKind.VOID);
            MethodTree methodTree = maker.Method(maker.Modifiers(methodModifs), (CharSequence)this.suggestMethodName(javaClass), (Tree)returnTypeTree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{" + this.body + "}", null);
            ClassTree modifiedClass = maker.addClassMember(javaClass, (Tree)methodTree);
            copy.rewrite((Tree)javaClass, (Tree)modifiedClass);
        }
    }

    public boolean isMethodBody() {
        return this.isBodyContext;
    }

    private void identifyConext(ClassTree javaClass, WorkingCopy copy) {
        boolean isBlock = false;
        for (TreePath treePath = copy.getTreeUtilities().pathFor(this.position); treePath != null; treePath = treePath.getParentPath()) {
            Tree tree = treePath.getLeaf();
            if (tree instanceof BlockTree) {
                isBlock = true;
            }
            if (!(tree instanceof MethodTree) || !isBlock) continue;
            this.isBodyContext = true;
            return;
        }
    }

    private String suggestMethodName(ClassTree javaClass) {
        String suggestedName = this.operation;
        boolean scanningNeeded = true;
        int i = 1;
        while (scanningNeeded) {
            boolean foundDuplicity = false;
            for (Tree tree : javaClass.getMembers()) {
                MethodTree method;
                if (Tree.Kind.METHOD != tree.getKind() || !(method = (MethodTree)tree).getName().contentEquals(suggestedName)) continue;
                suggestedName = this.operation + "_" + String.valueOf(i++);
                foundDuplicity = true;
                break;
            }
            scanningNeeded = foundDuplicity;
        }
        return suggestedName;
    }
}

