/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class TagTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String TAG_FILE = "tag_file";
    public static final String IS_TLD_SELECTED = "isTldSelected";
    public static final String TLD_FILE_OBJECT = "tldFileObject";
    public static final String TAG_NAME = "tagName";
    private Profile myJ2eeVersion;
    private TagUIManager myUIManager = new TagUIManager();

    @Override
    public String getResultExtension(TargetChooserPanel<FileType> panel) {
        String ext = super.getResultExtension(panel);
        if (this.getUIManager().isSegment()) {
            ext = ext + "f";
        } else if (this.getUIManager().isXml()) {
            ext = ext + "x";
        }
        return ext;
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + TAG_FILE;
    }

    public TagUIManager getUIManager() {
        return this.myUIManager;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TITLE_TagFile");
    }

    @Override
    public void init(TargetChooserPanel<FileType> panel) {
        WebModule wm;
        this.myJ2eeVersion = Profile.J2EE_14;
        if (panel.getSourceGroups() != null && panel.getSourceGroups().length > 0 && (wm = WebModule.getWebModule((FileObject)panel.getSourceGroups()[0].getRootFolder())) != null) {
            this.myJ2eeVersion = wm.getJ2eeProfile();
        }
    }

    @Override
    public boolean isValid(TargetChooserPanel<FileType> panel) {
        if (Profile.J2EE_13.equals(this.myJ2eeVersion)) {
            panel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_13notSupported"));
            return false;
        }
        if (!panel.checkValid()) {
            return false;
        }
        if (this.getUIManager().isTldCheckBoxSelected()) {
            String mes = null;
            FileObject tldFo = this.getUIManager().getTldFileObject();
            String tagName = this.getUIManager().getTagName();
            if (tldFo == null) {
                mes = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_noTldSelectedForTagFile");
            } else if (this.getUIManager().isTagNameEmpty(tagName)) {
                mes = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_missingTagName");
            } else if (!this.getUIManager().isValidTagName(tagName)) {
                mes = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_wrongTagName", (Object)tagName);
            } else if (this.getUIManager().tagNameExists(tagName)) {
                mes = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_tagNameExists", (Object)tagName);
            }
            if (mes != null) {
                panel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)mes);
                return false;
            }
        }
        return true;
    }

    public boolean isApplicable(FileType id) {
        return id == FileType.TAG;
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> panel) {
        panel.getTemplateWizard().putProperty(FileType.IS_XML, (Object)this.getUIManager().isXml());
        panel.getTemplateWizard().putProperty(FileType.IS_SEGMENT, (Object)this.getUIManager().isSegment());
        panel.getTemplateWizard().putProperty(IS_TLD_SELECTED, (Object)this.getUIManager().isTldCheckBoxSelected());
        panel.getTemplateWizard().putProperty(TLD_FILE_OBJECT, (Object)this.getUIManager().getTldFileObject());
        panel.getTemplateWizard().putProperty(TAG_NAME, (Object)this.getUIManager().getTagName());
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }
}

