/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public class Context {
    private final String executable;
    private final String hostname;

    public Context(String executable, String hostname) {
        if (!NativeDebuggerManager.isPerTargetBpts()) {
            hostname = null;
        }
        String string = this.executable = executable == null ? "" : executable;
        this.hostname = hostname == null ? "" : (hostname.equals("localhost") ? "" : hostname);
    }

    public static Context parse(String s) {
        String hostname;
        String executable;
        int slashX = s.indexOf(64);
        if (slashX == -1) {
            executable = s;
            hostname = null;
        } else if (slashX == 0) {
            executable = null;
            hostname = s.substring(slashX);
        } else {
            executable = s.substring(0, slashX);
            hostname = s.substring(slashX + 1);
        }
        if (!NativeDebuggerManager.isPerTargetBpts()) {
            hostname = null;
        }
        Context c = new Context(executable, hostname);
        return c;
    }

    public Context(Context that) {
        this.executable = that.executable;
        this.hostname = that.hostname;
    }

    public String toString() {
        if (IpeUtils.isEmpty(this.hostname)) {
            return this.executable;
        }
        return this.executable + "@" + this.hostname;
    }

    public boolean matches(Context that) {
        if (this == that) {
            return true;
        }
        return IpeUtils.sameString(this.executable, that.executable) && IpeUtils.sameString(this.hostname, that.hostname);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Context)) {
            return false;
        }
        Context that = (Context)o;
        if (this == that) {
            return true;
        }
        return IpeUtils.sameString(this.executable, that.executable) && IpeUtils.sameString(this.hostname, that.hostname);
    }

    public int hashCode() {
        int result = 7632;
        if (this.executable != null) {
            result = 5 * result + this.executable.hashCode();
        }
        if (this.hostname != null) {
            result = 7 * result + this.hostname.hashCode();
        }
        return result;
    }
}

