/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.beans.PropertyEditor;
import org.netbeans.api.debugger.Properties;
import org.netbeans.spi.viewmodel.ColumnModel;

public abstract class AbstractColumnModel
extends ColumnModel {
    private String id = null;
    private boolean defaultVisible = false;
    private String displayName;
    private String shortDescription;
    private Class type;
    private PropertyEditor propertyEditor;
    private boolean sorted = false;
    private boolean sortedDescending = false;
    Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

    protected AbstractColumnModel() {
    }

    protected AbstractColumnModel(String id, String displayName, String shortDescription, Class type, boolean defaultVisible, PropertyEditor propertyEditor) {
        this.id = id;
        this.displayName = displayName;
        this.shortDescription = shortDescription;
        this.type = type;
        this.defaultVisible = defaultVisible;
        this.propertyEditor = propertyEditor;
    }

    public void setCurrentOrderNumber(int newOrderNumber) {
        this.properties.setInt(this.getID() + ".currentOrderNumber", newOrderNumber);
    }

    public int getCurrentOrderNumber() {
        return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
    }

    public boolean isVisible() {
        return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
    }

    public void setVisible(boolean visible) {
        this.properties.setBoolean(this.getID() + ".visible", visible);
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Class getType() {
        return this.type;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public boolean isSortable() {
        return false;
    }

    public void setSorted(boolean sorted) {
        this.properties.setBoolean(this.getID() + ".sorted", sorted);
    }

    public boolean isSorted() {
        return this.properties.getBoolean(this.getID() + ".sorted", false);
    }

    public void setSortedDescending(boolean sortedDescending) {
        this.properties.setBoolean(this.getID() + ".sortedDescending", sortedDescending);
    }

    public boolean isSortedDescending() {
        return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
    }

    public void setColumnWidth(int columnWidth) {
        this.properties.setInt(this.getID() + ".columnWidth", columnWidth);
    }

    public int getColumnWidth() {
        int width = this.properties.getInt(this.getID() + ".columnWidth", 150);
        return width;
    }
}

