/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.capture;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.debugger.common2.capture.CaptureInfo;
import org.netbeans.modules.cnd.debugger.common2.capture.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

class CapturePanel
extends JPanel {
    private final CaptureInfo captureInfo;
    private JLabel alertTitleLabel;
    private JTextArea textArea;
    private JLabel projectLabel;
    private JComboBox projectComboBox;
    private JLabel errorLabel;
    public final String PROJECT_NONE = Catalog.get("NO_PROJECT");
    public final String PROJECT_NEW = Catalog.get("NEW_PROJECT");
    private Project[] projectChoices;
    private static Project lastSelectedProject;

    CapturePanel(CaptureInfo captureInfo) {
        this.captureInfo = captureInfo;
        this.initComponents();
        if (!NativeDebuggerManager.isStandalone()) {
            this.populateProjectMenu();
        }
    }

    public Project getSelectedProject() {
        if (NativeDebuggerManager.isStandalone()) {
            return null;
        }
        int index = this.projectComboBox.getSelectedIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1) {
            return null;
        }
        lastSelectedProject = this.projectChoices[index - 2];
        return lastSelectedProject;
    }

    public boolean getNoProject() {
        if (NativeDebuggerManager.isStandalone()) {
            return true;
        }
        int index = this.projectComboBox.getSelectedIndex();
        return index == 0;
    }

    private int mapProject(Project target) {
        for (int px = 0; px < this.projectChoices.length; ++px) {
            if (target != this.projectChoices[px]) continue;
            return px + 2;
        }
        return 0;
    }

    private void populateProjectMenu() {
        this.projectComboBox.removeAllItems();
        this.projectChoices = OpenProjects.getDefault().getOpenProjects();
        this.projectComboBox.addItem(this.PROJECT_NONE);
        this.projectComboBox.addItem(this.PROJECT_NEW);
        for (Project p : this.projectChoices) {
            String projectName = ProjectUtils.getInformation((Project)p).getName();
            this.projectComboBox.addItem(projectName);
        }
        Project p = this.projectFromExecutable(this.captureInfo.executable);
        int chosenIndex = 0;
        if (p != null) {
            chosenIndex = this.mapProject(p);
        }
        this.projectComboBox.setSelectedIndex(chosenIndex);
    }

    private boolean match(Project candidate, String executable) {
        String baseName = CndPathUtilities.getBaseName((String)executable);
        String projectName = ProjectUtils.getInformation((Project)candidate).getName();
        return projectName.equals(baseName);
    }

    private Project projectFromExecutable(String executable) {
        for (int px = 0; px < this.projectChoices.length; ++px) {
            Project candidate = this.projectChoices[px];
            if (!this.match(candidate, executable)) continue;
            return candidate;
        }
        return null;
    }

    private void initComponents() {
        boolean debug = false;
        Catalog.setAccessibleDescription(this, "ASCD_CapturePanel");
        this.setLayout(new GridBagLayout());
        boolean dialogMargin = false;
        int labelSpace = 11;
        int titleSpace = 12;
        int bottomMargin = 12;
        this.alertTitleLabel = new JLabel();
        String alertMsg = this.captureInfo.hostName == null ? Catalog.format("FMT_Captured", this.captureInfo.executable) : Catalog.format("FMT_CapturedOnHost", this.captureInfo.executable, this.captureInfo.hostName);
        alertMsg = String.format("<html><b>%s", alertMsg);
        this.alertTitleLabel.setText(alertMsg);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.alertTitleLabel, gbc);
        int rows = 5;
        int cols = 60;
        this.textArea = new JTextArea(this.captureInfo.messageString(), 5, 60);
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        boolean noBorder = false;
        Color bgColor = (Color)UIManager.getDefaults().get("TextArea.background");
        this.textArea.setBorder(new EtchedBorder(1));
        this.textArea.setBackground(bgColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 17, 0);
        this.add((Component)this.textArea, gbc);
        if (!NativeDebuggerManager.isStandalone()) {
            this.projectComboBox = new JComboBox();
            Catalog.setAccessibleDescription(this.projectComboBox, "ACSD_Project");
            this.projectComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CapturePanel.this.clearError();
                    if (CapturePanel.this.getSelectedProject() != null) {
                        CapturePanel.this.setWarning(Catalog.get("MSG_overrideWarn"));
                    }
                }
            });
            this.projectLabel = new JLabel();
            this.projectLabel.setText(Catalog.get("ASSOCIATED_PROJECT_LBL"));
            this.projectLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNM_Project"));
            this.projectLabel.setLabelFor(this.projectComboBox);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 12, 11);
            this.add((Component)this.projectLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 12, 0);
            this.add((Component)this.projectComboBox, gbc);
        }
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.clearError();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.errorLabel, gbc);
    }

    private void setWarning(String msg) {
        this.errorLabel.setText(msg);
    }

    private void clearError() {
        this.errorLabel.setText(" ");
    }
}

