/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    @Override
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        DefaultRequest<ListMetricsRequest> request = new DefaultRequest<ListMetricsRequest>(listMetricsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        if (listMetricsRequest != null && listMetricsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(listMetricsRequest.getNamespace()));
        }
        if (listMetricsRequest != null && listMetricsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(listMetricsRequest.getMetricName()));
        }
        if (listMetricsRequest != null) {
            List<DimensionFilter> dimensionsList = listMetricsRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (DimensionFilter dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null && dimensionsListValue.getName() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                }
                if (dimensionsListValue != null && dimensionsListValue.getValue() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                }
                ++dimensionsListIndex;
            }
        }
        if (listMetricsRequest != null && listMetricsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listMetricsRequest.getNextToken()));
        }
        return request;
    }
}

