/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.ui.diff.ExportAsFilePanel;
import org.netbeans.modules.git.remote.ui.diff.ExportCommitPanel;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.remotefs.versioning.api.ExportDiffSupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

abstract class ExportCommit
extends ExportDiffSupport {
    private final ExportCommitPanel panel;
    private ExportDiffSupport.AbstractExportDiffPanel aedp;
    private DocumentListener listener;
    private DialogDescriptor dd;
    private final RevisionDialogController controller;

    public ExportCommit(VCSFileProxy repository, String preselectedRevision) {
        super(new VCSFileProxy[]{repository}, GitModuleConfig.getDefault().getPreferences());
        this.controller = new RevisionDialogController(repository, new VCSFileProxy[]{repository}, preselectedRevision);
        this.panel = new ExportCommitPanel(this.controller.getPanel());
    }

    private void nameChange() {
        if (this.aedp.getOutputFileText().trim().length() > 0) {
            this.dd.setValid(true);
        } else {
            this.dd.setValid(false);
        }
    }

    public String getOutputFileName() {
        if (this.aedp == null) {
            return null;
        }
        return this.aedp.getOutputFileText().trim();
    }

    public String getSelectionRevision() {
        return this.controller.getRevision().getRevision();
    }

    protected ExportDiffSupport.AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        this.aedp = new ExportAsFilePanel();
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportCommit.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportCommit.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportCommit.this.nameChange();
            }
        };
        this.setInsidePanel(this.aedp);
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportCommit.class, (String)"CTL_ExportDialog"));
        this.dd.setModal(true);
        this.dd.setHelpCtx(new HelpCtx(((Object)((Object)this)).getClass()));
        this.dd.setValid(false);
        this.aedp.addOutputFileTextDocumentListener(this.listener);
        return this.aedp;
    }

    protected void createComplexDialog(ExportDiffSupport.AbstractExportDiffPanel insidePanel) {
        this.setInsidePanel(insidePanel);
        this.aedp = insidePanel;
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportCommit.class, (String)"CTL_ExportDialog"));
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dd;
    }

    private void setInsidePanel(ExportDiffSupport.AbstractExportDiffPanel aedp) {
        this.panel.insidePanel.removeAll();
        this.panel.insidePanel.setLayout(new BorderLayout());
        this.panel.insidePanel.add((Component)aedp, "Center");
    }
}

